/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.SSLSocketVerifier;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class HostNameSSLSocketVerifier
extends SSLSocketVerifier {
    private final boolean allowWildcards;

    public HostNameSSLSocketVerifier(boolean allowWildcards) {
        this.allowWildcards = allowWildcards;
    }

    @Override
    public void verifySSLSocket(String host, int port, SSLSocket sslSocket) throws LDAPException {
        block7: {
            try {
                SSLSession sslSession = sslSocket.getSession();
                if (sslSession == null) {
                    throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_NO_SESSION.get(host, port));
                }
                Certificate[] peerCertificates = sslSession.getPeerCertificates();
                if (peerCertificates == null || peerCertificates.length == 0) {
                    throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_NO_PEER_CERTS.get(host, port));
                }
                if (peerCertificates[0] instanceof X509Certificate) {
                    StringBuilder certInfo = new StringBuilder();
                    if (!HostNameSSLSocketVerifier.certificateIncludesHostname(host, (X509Certificate)peerCertificates[0], this.allowWildcards, certInfo)) {
                        throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_HOSTNAME_NOT_FOUND.get(host, certInfo.toString()));
                    }
                    break block7;
                }
                throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_PEER_NOT_X509.get(host, port, peerCertificates[0].getType()));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_EXCEPTION.get(host, port, StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    static boolean certificateIncludesHostname(String host, X509Certificate certificate, boolean allowWildcards, StringBuilder certInfo) {
        Collection<List<?>> subjectAltNames;
        String lowerHost = StaticUtils.toLowerCase(host);
        String subjectDN = certificate.getSubjectX500Principal().getName("RFC2253");
        certInfo.append("subject='");
        certInfo.append(subjectDN);
        certInfo.append('\'');
        try {
            DN dn = new DN(subjectDN);
            for (RDN rdn : dn.getRDNs()) {
                String[] names = rdn.getAttributeNames();
                String[] values = rdn.getAttributeValues();
                for (int i = 0; i < names.length; ++i) {
                    String withoutWildcard;
                    String lowerName = StaticUtils.toLowerCase(names[i]);
                    if (!lowerName.equals("cn") && !lowerName.equals("commonname") && !lowerName.equals("2.5.4.3")) continue;
                    String lowerValue = StaticUtils.toLowerCase(values[i]);
                    if (lowerHost.equals(lowerValue)) {
                        return true;
                    }
                    if (!allowWildcards || !lowerValue.startsWith("*.") || !lowerHost.endsWith(withoutWildcard = lowerValue.substring(1))) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            subjectAltNames = certificate.getSubjectAlternativeNames();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
        if (subjectAltNames != null) {
            block13: for (List<?> l : subjectAltNames) {
                try {
                    Integer type = (Integer)l.get(0);
                    switch (type) {
                        case 2: {
                            String dnsName = (String)l.get(1);
                            certInfo.append(" dNSName='");
                            certInfo.append(dnsName);
                            certInfo.append('\'');
                            String lowerDNSName = StaticUtils.toLowerCase(dnsName);
                            if (lowerHost.equals(lowerDNSName)) {
                                return true;
                            }
                            if (!allowWildcards || !lowerDNSName.startsWith("*.")) break;
                            String withoutWildcard = lowerDNSName.substring(1);
                            if (!lowerHost.endsWith(withoutWildcard)) continue block13;
                            return true;
                        }
                        case 6: {
                            String uriString = (String)l.get(1);
                            certInfo.append(" uniformResourceIdentifier='");
                            certInfo.append(uriString);
                            certInfo.append('\'');
                            URI uri = new URI(uriString);
                            if (!lowerHost.equals(StaticUtils.toLowerCase(uri.getHost()))) break;
                            return true;
                        }
                        case 7: {
                            String ipAddressString = (String)l.get(1);
                            certInfo.append(" iPAddress='");
                            certInfo.append(ipAddressString);
                            certInfo.append('\'');
                            InetAddress inetAddress = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getByName(ipAddressString);
                            if (!Character.isDigit(host.charAt(0)) && host.indexOf(58) < 0) break;
                            InetAddress a = InetAddress.getByName(host);
                            if (!inetAddress.equals(a)) continue block13;
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return false;
    }
}

