/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.util.HeadingCollectingVisitor;
import com.vladsch.flexmark.ext.toc.SimTocBlock;
import com.vladsch.flexmark.ext.toc.SimTocContent;
import com.vladsch.flexmark.ext.toc.SimTocOption;
import com.vladsch.flexmark.ext.toc.SimTocOptionList;
import com.vladsch.flexmark.ext.toc.internal.SimTocOptionsParser;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.ext.toc.internal.TocUtils;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.Paired;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimTocNodeRenderer
implements NodeRenderer {
    public static final AttributablePart TOC_CONTENT = TocUtils.TOC_CONTENT;
    private final TocOptions options;

    public SimTocNodeRenderer(DataHolder options) {
        this.options = new TocOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(SimTocBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<SimTocBlock>(){

            public void render(SimTocBlock node, NodeRendererContext context, HtmlWriter html) {
                SimTocNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SimTocContent.class, (CustomNodeRenderer)new CustomNodeRenderer<SimTocContent>(){

            public void render(SimTocContent node, NodeRendererContext context, HtmlWriter html) {
                SimTocNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SimTocOptionList.class, (CustomNodeRenderer)new CustomNodeRenderer<SimTocOptionList>(){

            public void render(SimTocOptionList node, NodeRendererContext context, HtmlWriter html) {
                SimTocNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SimTocOption.class, (CustomNodeRenderer)new CustomNodeRenderer<SimTocOption>(){

            public void render(SimTocOption node, NodeRendererContext context, HtmlWriter html) {
                SimTocNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(SimTocContent node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SimTocOptionList node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SimTocOption node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SimTocBlock node, NodeRendererContext context, HtmlWriter html) {
        HeadingCollectingVisitor visitor = new HeadingCollectingVisitor();
        ArrayList headings = visitor.collectAndGetHeadings((Node)node.getDocument());
        if (headings != null) {
            SimTocOptionsParser optionsParser = new SimTocOptionsParser();
            TocOptions options = (TocOptions)optionsParser.parseOption(node.getStyle(), this.options, null).getFirst();
            if (node.getTitle().isNotNull()) {
                options = options.withTitle(node.getTitle().unescape());
            }
            this.renderTocHeaders(context, html, (Node)node, headings, options);
        }
    }

    private void renderTocHeaders(NodeRendererContext context, HtmlWriter html, Node node, List<Heading> headings, TocOptions options) {
        List<Heading> filteredHeadings = TocUtils.filteredHeadings(headings, options);
        Paired<List<Heading>, List<String>> paired = TocUtils.htmlHeadingTexts(context, filteredHeadings, options);
        TocUtils.renderHtmlToc(html, context.getHtmlOptions().sourcePositionAttribute.isEmpty() ? BasedSequence.NULL : node.getChars(), (List)paired.getFirst(), (List)paired.getSecond(), options);
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new SimTocNodeRenderer(options);
        }
    }
}

