/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.dependency;

import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import com.vladsch.flexmark.util.dependency.Dependent;
import com.vladsch.flexmark.util.dependency.DependentItem;
import com.vladsch.flexmark.util.dependency.DependentItemMap;
import com.vladsch.flexmark.util.dependency.ResolvedDependencies;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DependencyHandler<D extends Dependent<D>, S, R extends ResolvedDependencies<S>> {
    protected abstract S createStage(List<D> var1);

    protected abstract Class getDependentClass(D var1);

    protected abstract R createResolvedDependencies(List<S> var1);

    public R resolveDependencies(List<D> dependentsList) {
        DependentItem item;
        if (dependentsList.size() == 0) {
            return this.createResolvedDependencies(Collections.EMPTY_LIST);
        }
        if (dependentsList.size() == 1) {
            HashMap nodeMap = new HashMap();
            Dependent dependent = (Dependent)dependentsList.get(0);
            List<Dependent> dependents = Collections.singletonList(dependent);
            return this.createResolvedDependencies(Collections.singletonList(this.createStage(dependents)));
        }
        int dependentCount = dependentsList.size();
        DependentItemMap dependentItemMap = new DependentItemMap(dependentCount);
        for (Dependent dependent : dependentsList) {
            Class dependentClass = this.getDependentClass(dependent);
            if (dependentItemMap.containsKey(dependentClass)) {
                throw new IllegalStateException("Dependent class " + dependentClass + " is duplicated. Only one instance can be present in the list");
            }
            item = new DependentItem(dependentItemMap.size(), dependent, this.getDependentClass(dependent), dependent.affectsGlobalScope());
            dependentItemMap.put(dependentClass, item);
        }
        for (Map.Entry entry : dependentItemMap) {
            Set<Class> beforeDependents;
            DependentItem item2 = (DependentItem)entry.getValue();
            Set<Class> afterDependencies = ((Dependent)item2.dependent).getAfterDependents();
            if (afterDependencies != null && afterDependencies.size() > 0) {
                for (Class clazz : afterDependencies) {
                    DependentItem dependentItem = (DependentItem)dependentItemMap.get(clazz);
                    if (dependentItem == null) continue;
                    item2.addDependency(dependentItem);
                    dependentItem.addDependent(item2);
                }
            }
            if ((beforeDependents = ((Dependent)item2.dependent).getBeforeDependents()) == null || beforeDependents.size() <= 0) continue;
            for (Class dependentClass3 : beforeDependents) {
                DependentItem dependentItem = (DependentItem)dependentItemMap.get(dependentClass3);
                if (dependentItem == null) continue;
                dependentItem.addDependency(item2);
                item2.addDependent(dependentItem);
            }
        }
        dependentItemMap = this.prioritize(dependentItemMap);
        dependentCount = dependentItemMap.size();
        BitSet newReady = new BitSet(dependentCount);
        Ref<BitSet> ref = new Ref<BitSet>(newReady);
        ReversibleIndexedIterator iterator = dependentItemMap.valueIterator();
        while (iterator.hasNext()) {
            item = (DependentItem)iterator.next();
            if (item.hasDependencies()) continue;
            ((BitSet)ref.value).set(item.index);
        }
        BitSet dependents = new BitSet(dependentCount);
        dependents.set(0, dependentItemMap.size());
        ArrayList<S> dependencyStages = new ArrayList<S>();
        while (newReady.nextSetBit(0) != -1) {
            int i;
            ArrayList arrayList = new ArrayList();
            BitSet nextDependents = new BitSet();
            while ((i = newReady.nextSetBit(0)) >= 0) {
                newReady.clear(i);
                DependentItem item3 = (DependentItem)dependentItemMap.getValue(i);
                arrayList.add(item3.dependent);
                dependents.clear(i);
                if (item3.hasDependents()) {
                    int j;
                    while ((j = item3.dependents.nextSetBit(0)) >= 0) {
                        item3.dependents.clear(j);
                        DependentItem dependentItem = (DependentItem)dependentItemMap.getValue(j);
                        if (dependentItem.removeDependency(item3)) continue;
                        if (item3.isGlobalScope) {
                            nextDependents.set(j);
                            continue;
                        }
                        newReady.set(j);
                    }
                    continue;
                }
                if (!item3.isGlobalScope) continue;
                nextDependents.or(newReady);
                break;
            }
            newReady = nextDependents;
            dependencyStages.add(this.createStage(arrayList));
        }
        if (dependents.nextSetBit(0) != -1) {
            throw new IllegalStateException("have dependents with dependency cycles" + dependents);
        }
        return this.createResolvedDependencies(dependencyStages);
    }

    protected DependentItemMap<D> prioritize(DependentItemMap<D> dependentMap) {
        return dependentMap;
    }
}

