/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.crypto.asymmetric;

import com.xiaoleilu.hutool.crypto.CryptoException;
import com.xiaoleilu.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import com.xiaoleilu.hutool.crypto.asymmetric.AsymmetricCriptor;
import com.xiaoleilu.hutool.crypto.asymmetric.KeyType;
import com.xiaoleilu.hutool.lang.BCD;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.security.Key;
import java.security.interfaces.RSAKey;

public class RSA
extends AsymmetricCriptor {
    private static final AsymmetricAlgorithm ALGORITHM_RSA = AsymmetricAlgorithm.RSA;

    public RSA() {
        super(ALGORITHM_RSA);
    }

    public RSA(byte[] privateKey, byte[] publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public String encryptStr(String data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        int keyLength = ((RSAKey)((Object)key)).getModulus().bitLength() / 8;
        StringBuilder sb = StrUtil.builder();
        this.lock.lock();
        try {
            String[] datas;
            this.clipher.init(1, key);
            for (String s : datas = StrUtil.split(data, keyLength - 11)) {
                sb.append(BCD.bcdToStr(this.clipher.doFinal(s.getBytes())));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }

    public String decryptStr(String data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        int keyLength = ((RSAKey)((Object)key)).getModulus().bitLength() / 8;
        StringBuilder sb = StrUtil.builder();
        this.lock.lock();
        try {
            byte[][] arrays;
            this.clipher.init(2, key);
            byte[] bcd = BCD.ascToBcd(StrUtil.utf8Bytes(data));
            for (byte[] arr : arrays = ArrayUtil.split(bcd, keyLength)) {
                sb.append(StrUtil.str(this.clipher.doFinal(arr), CharsetUtil.CHARSET_UTF_8));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }
}

