/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.date;

import com.xiaoleilu.hutool.date.DateUnit;

public class BetweenFormater {
    private long betweenMs;
    private Level level;

    public BetweenFormater(long betweenMs, Level level) {
        this.betweenMs = betweenMs;
        this.level = level;
    }

    public String format() {
        if (this.betweenMs == 0L) {
            return "0";
        }
        long day = this.betweenMs / DateUnit.DAY.getMillis();
        long hour = this.betweenMs / DateUnit.HOUR.getMillis() - day * 24L;
        long minute = this.betweenMs / DateUnit.MINUTE.getMillis() - day * 24L * 60L - hour * 60L;
        long second = this.betweenMs / DateUnit.SECOND.getMillis() - ((day * 24L + hour) * 60L + minute) * 60L;
        long millisecond = this.betweenMs - (((day * 24L + hour) * 60L + minute) * 60L + second) * 1000L;
        StringBuilder sb = new StringBuilder();
        int level = this.level.value;
        if (0L != day && level > 0) {
            sb.append(day).append("\u5929");
        }
        if (0L != hour && level > 1) {
            sb.append(hour).append("\u5c0f\u65f6");
        }
        if (0L != minute && level > 2) {
            sb.append(minute).append("\u5206");
        }
        if (0L != second && level > 3) {
            sb.append(second).append("\u79d2");
        }
        if (0L != millisecond && level > 4) {
            sb.append(millisecond).append("\u6beb\u79d2");
        }
        return sb.toString();
    }

    public long getBetweenMs() {
        return this.betweenMs;
    }

    public void setBetweenMs(long betweenMs) {
        this.betweenMs = betweenMs;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public static enum Level {
        DAY(1),
        HOUR(2),
        MINUTE(3),
        SECOND(4),
        MILLSECOND(5);

        private int value;

        private Level(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

