/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.date;

import com.xiaoleilu.hutool.date.BetweenFormater;
import com.xiaoleilu.hutool.date.DateBetween;
import com.xiaoleilu.hutool.date.DateException;
import com.xiaoleilu.hutool.date.DateField;
import com.xiaoleilu.hutool.date.DateUnit;
import com.xiaoleilu.hutool.date.DateUtil;
import com.xiaoleilu.hutool.date.Month;
import com.xiaoleilu.hutool.date.Week;
import com.xiaoleilu.hutool.util.StrUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTime
extends Date {
    private static final long serialVersionUID = -5395712593979185936L;

    public static DateTime of(Date date) {
        return new DateTime(date);
    }

    public static DateTime of(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime of(String dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime now() {
        return new DateTime();
    }

    public DateTime() {
    }

    public DateTime(Date date) {
        this(date.getTime());
    }

    public DateTime(Calendar calendar) {
        this(calendar.getTime());
    }

    public DateTime(long timeMillis) {
        super(timeMillis);
    }

    public DateTime(String dateStr, String format) {
        this(dateStr, new SimpleDateFormat(format));
    }

    public DateTime(String dateStr, SimpleDateFormat simpleDateFormat) {
        this(DateTime.parse(dateStr, simpleDateFormat));
    }

    public DateTime offsite(DateField datePart, int offsite) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this);
        cal.add(datePart.getValue(), offsite);
        this.setTime(cal.getTimeInMillis());
        return this;
    }

    public int getField(DateField field) {
        return this.getField(field.getValue());
    }

    public int getField(int field) {
        return this.toCalendar().get(field);
    }

    public DateTime setField(DateField field, int value) {
        return this.setField(field.getValue(), value);
    }

    public DateTime setField(int field, int value) {
        this.toCalendar().set(field, value);
        return this;
    }

    public int year() {
        return this.getField(DateField.YEAR);
    }

    public int season() {
        return this.month() / 3 + 1;
    }

    public int month() {
        return this.getField(DateField.MONTH);
    }

    public Month monthEnum() {
        return Month.of(this.month());
    }

    public int weekOfYear() {
        return this.getField(DateField.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(DateField.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(DateField.DAY_OF_MONTH);
    }

    public int dayOfWeek() {
        return this.getField(DateField.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(DateField.DAY_OF_WEEK_IN_MONTH);
    }

    public Week dayOfWeekEnum() {
        return Week.of(this.dayOfWeek());
    }

    public int hour(boolean is24HourClock) {
        return this.getField(is24HourClock ? DateField.HOUR_OF_DAY : DateField.HOUR);
    }

    public int minute() {
        return this.getField(DateField.MINUTE);
    }

    public int second() {
        return this.getField(DateField.SECOND);
    }

    public int millsecond() {
        return this.getField(DateField.MILLISECOND);
    }

    public boolean isAM() {
        return 0 == this.getField(DateField.AM_PM);
    }

    public boolean isPM() {
        return 1 == this.getField(DateField.AM_PM);
    }

    public boolean isLeapYear() {
        return DateUtil.isLeapYear(this.year());
    }

    public Calendar toCalendar() {
        return DateUtil.calendar(this);
    }

    public DateBetween between(Date date) {
        return new DateBetween(this, date);
    }

    public long between(Date date, DateUnit unit) {
        return new DateBetween(this, date).between(unit);
    }

    public String between(Date date, DateUnit unit, BetweenFormater.Level formatLevel) {
        return new DateBetween(this, date).toString(formatLevel);
    }

    @Override
    public String toString() {
        return DateUtil.formatDateTime(this);
    }

    public String toString(String format) {
        return DateUtil.format(this, format);
    }

    public String toMsStr() {
        return DateUtil.format(this, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    private static Date parse(String dateStr, SimpleDateFormat simpleDateFormat) {
        try {
            return simpleDateFormat.parse(dateStr);
        }
        catch (Exception e) {
            throw new DateException(StrUtil.format("Parse [{}] with format [{}] error!", dateStr, simpleDateFormat.toPattern()), e);
        }
    }
}

