/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.date;

import com.xiaoleilu.hutool.date.BetweenFormater;
import com.xiaoleilu.hutool.date.DateBetween;
import com.xiaoleilu.hutool.date.DateException;
import com.xiaoleilu.hutool.date.DateField;
import com.xiaoleilu.hutool.date.DatePatternLocal;
import com.xiaoleilu.hutool.date.DateTime;
import com.xiaoleilu.hutool.date.DateUnit;
import com.xiaoleilu.hutool.date.Month;
import com.xiaoleilu.hutool.date.TimeInterval;
import com.xiaoleilu.hutool.date.Week;
import com.xiaoleilu.hutool.util.StrUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;

public class DateUtil {
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    public static final String NORM_TIME_PATTERN = "HH:mm:ss";
    public static final String NORM_DATETIME_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String NORM_DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String HTTP_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static Calendar calendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Calendar calendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static String now() {
        return DateUtil.formatDateTime(new DateTime());
    }

    public static long current(boolean isNano) {
        return isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public static String today() {
        return DateUtil.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int season(Date date) {
        return DateTime.of(date).season();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static Month monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static Week dayOfWeekEnum(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static int millsecond(Date date) {
        return DateTime.of(date).millsecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateUtil.year(DateUtil.date());
    }

    public static int thisMonth() {
        return DateUtil.month(DateUtil.date());
    }

    public static Month thisMonthEnum() {
        return DateUtil.monthEnum(DateUtil.date());
    }

    public static int thisWeekOfYear() {
        return DateUtil.weekOfYear(DateUtil.date());
    }

    public static int thisWeekOfMonth() {
        return DateUtil.weekOfMonth(DateUtil.date());
    }

    public static int thisDayOfMonth() {
        return DateUtil.dayOfMonth(DateUtil.date());
    }

    public static int thisDayOfWeek() {
        return DateUtil.dayOfWeek(DateUtil.date());
    }

    public static Week thisDayOfWeekEnum() {
        return DateUtil.dayOfWeekEnum(DateUtil.date());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateUtil.hour(DateUtil.date(), is24HourClock);
    }

    public static int thisMinute() {
        return DateUtil.minute(DateUtil.date());
    }

    public static int thisSecond() {
        return DateUtil.second(DateUtil.date());
    }

    public static int thisMillsecond() {
        return DateUtil.millsecond(DateUtil.date());
    }

    public static String yearAndSeason(Date date) {
        return DateUtil.yearAndSeason(DateUtil.calendar(date));
    }

    public static LinkedHashSet<String> yearAndSeasons(Date startDate, Date endDate) {
        LinkedHashSet<String> seasons = new LinkedHashSet<String>();
        if (startDate == null || endDate == null) {
            return seasons;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (true) {
            if (startDate.after(endDate)) {
                startDate = endDate;
            }
            seasons.add(DateUtil.yearAndSeason(cal));
            if (startDate.equals(endDate)) break;
            cal.add(2, 3);
            startDate = cal.getTime();
        }
        return seasons;
    }

    public static String format(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePatternLocal.NORM_DATETIME_FORMAT.get().format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePatternLocal.NORM_DATE_FORMAT.get().format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePatternLocal.HTTP_DATETIME_FORMAT.get().format(date);
    }

    public static DateTime parse(String dateStr, SimpleDateFormat simpleDateFormat) {
        return new DateTime(dateStr, simpleDateFormat);
    }

    public static DateTime parse(String dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parseDateTime(String dateString) {
        return DateUtil.parse(dateString, DatePatternLocal.NORM_DATETIME_FORMAT.get());
    }

    public static DateTime parseDate(String dateString) {
        return DateUtil.parse(dateString, DatePatternLocal.NORM_DATE_FORMAT.get());
    }

    public static DateTime parseTime(String timeString) {
        return DateUtil.parse(timeString, DatePatternLocal.NORM_TIME_FORMAT.get());
    }

    public static DateTime parse(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        dateStr = dateStr.trim();
        int length = dateStr.length();
        try {
            if (length == NORM_DATETIME_PATTERN.length()) {
                return DateUtil.parseDateTime(dateStr);
            }
            if (length == NORM_DATE_PATTERN.length()) {
                return DateUtil.parseDate(dateStr);
            }
            if (length == NORM_TIME_PATTERN.length()) {
                return DateUtil.parseTime(dateStr);
            }
            if (length == NORM_DATETIME_MINUTE_PATTERN.length()) {
                return DateUtil.parse(dateStr, NORM_DATETIME_MINUTE_PATTERN);
            }
            if (length >= NORM_DATETIME_MS_PATTERN.length() - 2) {
                return DateUtil.parse(dateStr, NORM_DATETIME_MS_PATTERN);
            }
        }
        catch (Exception e) {
            throw new DateException(StrUtil.format("Parse [{}] with format normal error!", dateStr));
        }
        throw new DateException(StrUtil.format(" [{}] format is not fit for date pattern!", dateStr));
    }

    public static DateTime beginOfDay(Date date) {
        return DateUtil.beginOfDay(DateUtil.calendar(date));
    }

    public static DateTime endOfDay(Date date) {
        return DateUtil.endOfDay(DateUtil.calendar(date));
    }

    public static DateTime beginOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new DateTime(calendar.getTime());
    }

    public static DateTime endOfDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new DateTime(calendar.getTime());
    }

    public static DateTime yesterday() {
        return DateUtil.offsiteDay(new DateTime(), -1);
    }

    public static DateTime lastWeek() {
        return DateUtil.offsiteWeek(new DateTime(), -1);
    }

    public static DateTime lastMouth() {
        return DateUtil.offsiteMonth(new DateTime(), -1);
    }

    public static DateTime offsiteMillisecond(Date date, int offsite) {
        return DateUtil.offsiteDate(date, DateField.MILLISECOND, offsite);
    }

    public static DateTime offsiteSecond(Date date, int offsite) {
        return DateUtil.offsiteDate(date, DateField.SECOND, offsite);
    }

    public static DateTime offsiteMinute(Date date, int offsite) {
        return DateUtil.offsiteDate(date, DateField.MINUTE, offsite);
    }

    public static DateTime offsiteHour(Date date, int offsite) {
        return DateUtil.offsiteDate(date, DateField.HOUR_OF_DAY, offsite);
    }

    public static DateTime offsiteDay(Date date, int offsite) {
        return DateUtil.offsiteDate(date, DateField.DAY_OF_YEAR, offsite);
    }

    public static DateTime offsiteWeek(Date date, int offsite) {
        return DateUtil.offsiteDate(date, DateField.WEEK_OF_YEAR, offsite);
    }

    public static DateTime offsiteMonth(Date date, int offsite) {
        return DateUtil.offsiteDate(date, DateField.MONTH, offsite);
    }

    public static DateTime offsiteDate(Date date, DateField datePart, int offsite) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(datePart.getValue(), offsite);
        return new DateTime(cal.getTime());
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return new DateBetween(beginDate, endDate).between(unit);
    }

    public static String formatBetween(Date beginDate, Date endDate, BetweenFormater.Level level) {
        return DateUtil.formatBetween(DateUtil.between(beginDate, endDate, DateUnit.MS), level);
    }

    public static String formatBetween(long betweenMs, BetweenFormater.Level level) {
        return new BetweenFormater(betweenMs, level).format();
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtil.format(date, "yyMMddHHmm"));
    }

    public static int weekCount(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekofYear = startCalendar.get(3);
        int endWeekofYear = endCalendar.get(3);
        int count = endWeekofYear - startWeekofYear + 1;
        if (1 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    public static TimeInterval timer() {
        return new TimeInterval();
    }

    public static int ageOfNow(String birthDay) {
        return DateUtil.ageOfNow(DateUtil.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateUtil.age(birthDay, DateUtil.date());
    }

    public static int age(Date birthDay, Date dateToCompare) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToCompare);
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException(StrUtil.format("Birthday is after date {}!", DateUtil.formatDate(dateToCompare)));
        }
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        cal.setTime(birthDay);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            int dayOfMonthBirth = cal.get(5);
            if (dayOfMonth < dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    private static String yearAndSeason(Calendar cal) {
        return "" + cal.get(1) + (cal.get(2) / 3 + 1);
    }
}

