/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Session;
import com.xiaoleilu.hutool.db.SqlConnRunner;
import com.xiaoleilu.hutool.db.SqlRunner;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.dialect.DialectFactory;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.db.meta.Column;
import com.xiaoleilu.hutool.db.meta.Table;
import com.xiaoleilu.hutool.db.sql.Condition;
import com.xiaoleilu.hutool.db.sql.SqlFormatter;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DbUtil {
    private static final Log log = StaticLog.get();

    private DbUtil() {
    }

    public static SqlConnRunner newSqlConnRunner(Dialect dialect) {
        return SqlConnRunner.create(dialect);
    }

    public static SqlConnRunner newSqlConnRunner(DataSource ds) {
        return SqlConnRunner.create(ds);
    }

    public static SqlConnRunner newSqlConnRunner(Connection conn) {
        return SqlConnRunner.create(DialectFactory.newDialect(conn));
    }

    public static SqlRunner newSqlRunner() {
        return SqlRunner.create(DbUtil.getDs());
    }

    public static SqlRunner newSqlRunner(DataSource ds) {
        return SqlRunner.create(ds);
    }

    public static SqlRunner newSqlRunner(DataSource ds, Dialect dialect) {
        return SqlRunner.create(ds, dialect);
    }

    public static Session newSession() {
        return Session.create(DbUtil.getDs());
    }

    public static Session newSession(DataSource ds) {
        return Session.create(ds);
    }

    public static Session newSession(Connection conn) {
        return Session.create(conn);
    }

    public static void close(Object ... objsToClose) {
        for (Object obj : objsToClose) {
            try {
                if (obj == null) continue;
                if (obj instanceof ResultSet) {
                    ((ResultSet)obj).close();
                    continue;
                }
                if (obj instanceof Statement) {
                    ((Statement)obj).close();
                    continue;
                }
                if (obj instanceof PreparedStatement) {
                    ((PreparedStatement)obj).close();
                    continue;
                }
                if (obj instanceof Connection) {
                    ((Connection)obj).close();
                    continue;
                }
                log.warn("Object " + obj.getClass().getName() + " not a ResultSet or Statement or PreparedStatement or Connection!", new Object[0]);
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    public static DataSource getDs() {
        return DSFactory.get();
    }

    public static DataSource getDs(String group) {
        return DSFactory.get(group);
    }

    public static DataSource getJndiDsWithLog(String jndiName) {
        try {
            return DbUtil.getJndiDs(jndiName);
        }
        catch (DbRuntimeException e) {
            log.error(e.getCause(), "Find JNDI datasource error!", new Object[0]);
            return null;
        }
    }

    public static DataSource getJndiDs(String jndiName) {
        try {
            return (DataSource)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static List<String> getTables(DataSource ds) {
        ResultSet rs;
        Connection conn;
        ArrayList<String> tables;
        block6: {
            tables = new ArrayList<String>();
            conn = null;
            rs = null;
            conn = ds.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getTables(conn.getCatalog(), null, null, new String[]{"TABLES"});
            if (rs != null) break block6;
            List<String> list = null;
            DbUtil.close(rs, conn);
            return list;
        }
        try {
            while (rs.next()) {
                String table = rs.getString("TABLE_NAME");
                if (StrUtil.isBlank(table)) continue;
                tables.add(table);
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get tables error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, conn);
                throw throwable;
            }
        }
        DbUtil.close(rs, conn);
        return tables;
    }

    public static String[] getColumnNames(ResultSet rs) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] labelNames = new String[columnCount];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = rsmd.getColumnLabel(i + 1);
            }
            return labelNames;
        }
        catch (Exception e) {
            throw new DbRuntimeException("Get colunms error!", e);
        }
    }

    public static String[] getColumnNames(DataSource ds, String tableName) {
        String[] stringArray;
        ArrayList<String> columnNames = new ArrayList<String>();
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getColumns(conn.getCatalog(), null, tableName, null);
            while (rs.next()) {
                columnNames.add(rs.getString("COLUMN_NAME"));
            }
            stringArray = columnNames.toArray(new String[columnNames.size()]);
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, conn);
                throw throwable;
            }
        }
        DbUtil.close(rs, conn);
        return stringArray;
    }

    public static Entity createLimitedEntity(DataSource ds, String tableName) {
        String[] columnNames = DbUtil.getColumnNames(ds, tableName);
        return Entity.create(tableName).setFieldNames(columnNames);
    }

    public static Table getTableMeta(DataSource ds, String tableName) {
        Table table = Table.create(tableName);
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = ds.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getPrimaryKeys(conn.getCatalog(), null, tableName);
            while (rs.next()) {
                table.addPk("COLUMN_NAME");
            }
            rs = metaData.getColumns(conn.getCatalog(), null, tableName, null);
            while (rs.next()) {
                table.setColumn(Column.create(tableName, rs));
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs, conn);
                throw throwable;
            }
        }
        DbUtil.close(rs, conn);
        return table;
    }

    public static void fillParams(PreparedStatement ps, Collection<Object> params) throws SQLException {
        DbUtil.fillParams(ps, params.toArray(new Object[params.size()]));
    }

    public static void fillParams(PreparedStatement ps, Object ... params) throws SQLException {
        if (ArrayUtil.isEmpty(params)) {
            return;
        }
        ParameterMetaData pmd = ps.getParameterMetaData();
        for (int i = 0; i < params.length; ++i) {
            int paramIndex = i + 1;
            if (params[i] != null) {
                ps.setObject(paramIndex, params[i]);
                continue;
            }
            int sqlType = 12;
            try {
                sqlType = pmd.getParameterType(paramIndex);
            }
            catch (SQLException e) {
                log.warn("Param get type fail, by: " + e.getMessage(), new Object[0]);
            }
            ps.setNull(paramIndex, sqlType);
        }
    }

    public static Long getGeneratedKeyOfLong(PreparedStatement ps) throws SQLException {
        Long l;
        ResultSet rs = null;
        try {
            rs = ps.getGeneratedKeys();
            Long generatedKey = null;
            if (rs != null && rs.next()) {
                try {
                    generatedKey = rs.getLong(1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            l = generatedKey;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        return l;
    }

    public static List<Object> getGeneratedKeys(PreparedStatement ps) throws SQLException {
        ArrayList<Object> arrayList;
        ArrayList<Object> keys = new ArrayList<Object>();
        ResultSet rs = null;
        int i = 1;
        try {
            rs = ps.getGeneratedKeys();
            if (rs != null && rs.next()) {
                keys.add(rs.getObject(i++));
            }
            arrayList = keys;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        return arrayList;
    }

    public static String buildEqualsWhere(Entity entity, List<Object> paramValues) {
        if (null == entity || entity.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" WHERE ");
        boolean isNotFirst = false;
        for (Map.Entry entry : entity.entrySet()) {
            if (isNotFirst) {
                sb.append(" and ");
            } else {
                isNotFirst = true;
            }
            sb.append("`").append((String)entry.getKey()).append("`").append(" = ?");
            paramValues.add(entry.getValue());
        }
        return sb.toString();
    }

    public static Condition[] buildConditions(Entity entity) {
        if (null == entity || entity.isEmpty()) {
            return null;
        }
        Condition[] conditions = new Condition[entity.size()];
        int i = 0;
        for (Map.Entry entry : entity.entrySet()) {
            conditions[i++] = new Condition((String)entry.getKey(), entry.getValue());
        }
        return conditions;
    }

    public static String identifyDriver(String nameContainsProductInfo) {
        if (StrUtil.isBlank(nameContainsProductInfo)) {
            return null;
        }
        nameContainsProductInfo = nameContainsProductInfo.toLowerCase();
        String driver = null;
        if (nameContainsProductInfo.contains("mysql")) {
            driver = "com.mysql.jdbc.Driver";
        } else if (nameContainsProductInfo.contains("oracle")) {
            driver = "oracle.jdbc.driver.OracleDriver";
        } else if (nameContainsProductInfo.contains("postgresql")) {
            driver = "org.postgresql.Driver";
        } else if (nameContainsProductInfo.contains("sqlite")) {
            driver = "org.sqlite.JDBC";
        }
        return driver;
    }

    public static String identifyDriver(DataSource ds) {
        Connection conn = null;
        String driver = null;
        try {
            conn = ds.getConnection();
            driver = DbUtil.identifyDriver(conn);
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Identify driver error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return driver;
    }

    public static String identifyDriver(Connection conn) {
        String driver = null;
        try {
            DatabaseMetaData meta = conn.getMetaData();
            driver = DbUtil.identifyDriver(meta.getDatabaseProductName());
            if (StrUtil.isBlank(driver)) {
                driver = DbUtil.identifyDriver(meta.getDriverName());
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException("Identify driver error!", e);
        }
        return driver;
    }

    public static void validateEntity(Entity entity) {
        if (null == entity) {
            throw new DbRuntimeException("Entity is null !");
        }
        if (StrUtil.isBlank(entity.getTableName())) {
            throw new DbRuntimeException("Entity`s table name is null !");
        }
        if (entity.isEmpty()) {
            throw new DbRuntimeException("No filed and value in this entity !");
        }
    }

    public static String rowIdToString(RowId rowId) {
        return StrUtil.str(rowId.getBytes(), CharsetUtil.CHARSET_ISO_8859_1);
    }

    public static String formatSql(String sql) {
        return SqlFormatter.format(sql);
    }
}

