/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.PageResult;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.dialect.DialectFactory;
import com.xiaoleilu.hutool.db.handler.EntityListHandler;
import com.xiaoleilu.hutool.db.handler.NumberHandler;
import com.xiaoleilu.hutool.db.handler.PageResultHandler;
import com.xiaoleilu.hutool.db.handler.RsHandler;
import com.xiaoleilu.hutool.db.sql.Query;
import com.xiaoleilu.hutool.db.sql.SqlExecutor;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class SqlConnRunner {
    private Dialect dialect;

    public static SqlConnRunner create(Dialect dialect) {
        return new SqlConnRunner(dialect);
    }

    public static SqlConnRunner create(DataSource ds) {
        return new SqlConnRunner(DialectFactory.newDialect(ds));
    }

    public static SqlConnRunner create(String driverClassName) {
        return new SqlConnRunner(driverClassName);
    }

    public SqlConnRunner(Dialect dialect) {
        StaticLog.info("Use Dialect: [{}].", dialect.getClass().getSimpleName());
        this.dialect = dialect;
    }

    public SqlConnRunner(String driverClassName) {
        this(DialectFactory.newDialect(driverClassName));
    }

    public int insert(Connection conn, Entity record) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public int[] insert(Connection conn, Collection<Entity> records) throws SQLException {
        Object i$;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(records)) {
            return new int[]{0};
        }
        Entity template = records.iterator().next();
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, template);
            ps.clearBatch();
            for (Entity entity : records) {
                DbUtil.fillParams(ps, entity.values().toArray(new Object[entity.size()]));
                ps.addBatch();
            }
            i$ = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return i$;
    }

    public List<Object> insertForGeneratedKeys(Connection conn, Entity record) throws SQLException {
        List<Object> list;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            ps.executeUpdate();
            list = DbUtil.getGeneratedKeys(ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return list;
    }

    public Long insertForGeneratedKey(Connection conn, Entity record) throws SQLException {
        Long l;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            ps.executeUpdate();
            l = DbUtil.getGeneratedKeyOfLong(ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return l;
    }

    public int del(Connection conn, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(where)) {
            throw new SQLException("Empty entity provided!");
        }
        Query query = new Query(DbUtil.buildConditions(where), where.getTableName());
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForDelete(conn, query);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public int update(Connection conn, Entity record, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollectionUtil.isEmpty(record)) {
            throw new SQLException("Empty entity provided!");
        }
        if (CollectionUtil.isEmpty(where)) {
            throw new SQLException("Empty where provided!");
        }
        Query query = new Query(DbUtil.buildConditions(where), where.getTableName());
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForUpdate(conn, record, query);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public <T> T find(Connection conn, Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        T t;
        this.checkConn(conn);
        Query query = new Query(DbUtil.buildConditions(where), where.getTableName());
        query.setFields(fields);
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForFind(conn, query);
            t = SqlExecutor.query(ps, rsh, new Object[0]);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return t;
    }

    public <T> T find(Connection conn, Entity where, RsHandler<T> rsh) throws SQLException {
        return this.find(conn, null, where, rsh);
    }

    public int count(Connection conn, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        Query query = new Query(DbUtil.buildConditions(where), where.getTableName());
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForCount(conn, query);
            n = SqlExecutor.query(ps, new NumberHandler(), new Object[0]).intValue();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public <T> T page(Connection conn, Collection<String> fields, Entity where, int pageNumber, int numPerPage, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        return this.page(conn, fields, where, new Page(pageNumber, numPerPage), rsh);
    }

    public <T> T page(Connection conn, Collection<String> fields, Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        if (null == page) {
            return this.find(conn, fields, where, rsh);
        }
        Query query = new Query(DbUtil.buildConditions(where), where.getTableName());
        query.setFields(fields);
        query.setPage(page);
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage(conn, query), rsh, new Object[0]);
    }

    public PageResult<Entity> page(Connection conn, Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        this.checkConn(conn);
        int count = this.count(conn, where);
        PageResultHandler pageResultHandler = PageResultHandler.create(new PageResult<Entity>(page, numPerPage, count));
        return this.page(conn, fields, where, page, numPerPage, pageResultHandler);
    }

    public PageResult<Entity> page(Connection conn, Collection<String> fields, Entity where, Page page) throws SQLException {
        this.checkConn(conn);
        if (null == page) {
            List<Entity> entityList = this.find(conn, fields, where, new EntityListHandler());
            PageResult<Entity> pageResult = new PageResult<Entity>(0, entityList.size(), entityList.size());
            pageResult.addAll(entityList);
            return pageResult;
        }
        int count = this.count(conn, where);
        PageResultHandler pageResultHandler = PageResultHandler.create(new PageResult<Entity>(page.getPageNumber(), page.getNumPerPage(), count));
        return this.page(conn, fields, where, page, pageResultHandler);
    }

    public PageResult<Entity> page(Connection conn, Entity where, Page page) throws SQLException {
        return this.page(conn, null, where, page);
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    private void checkConn(Connection conn) {
        if (null == conn) {
            throw new NullPointerException("Connection object is null!");
        }
    }
}

