/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DruidDSFactory
extends DSFactory {
    private Setting setting;
    private Map<String, DruidDataSource> dsMap;

    public DruidDSFactory() {
        this((Setting)null);
    }

    public DruidDSFactory(Setting setting) {
        super("Druid");
        this.checkCPExist(DruidDataSource.class);
        if (null == setting) {
            setting = new Setting("config/db.setting", true);
        }
        this.setting = setting;
        this.dsMap = new ConcurrentHashMap<String, DruidDataSource>();
    }

    @Override
    public DataSource getDataSource(String group) {
        DruidDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DruidDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        DruidDataSource dds;
        if (group == null) {
            group = "";
        }
        if ((dds = this.dsMap.get(group)) != null) {
            IoUtil.close((Closeable)dds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<DruidDataSource> values = this.dsMap.values();
            for (DruidDataSource dds : values) {
                IoUtil.close((Closeable)dds);
            }
            this.dsMap.clear();
            this.dsMap = null;
        }
    }

    private DruidDataSource createDataSource(String group) {
        Properties config = this.setting.getProperties(group);
        if (CollectionUtil.isEmpty(config)) {
            throw new DbRuntimeException("No Druid config for group: [{}]", group);
        }
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(config.getProperty("url"));
        config.remove("url");
        ds.setUsername(config.getProperty("username", config.getProperty("user")));
        config.remove("username");
        config.remove("user");
        ds.setPassword(config.getProperty("password", config.getProperty("pass")));
        config.remove("password");
        config.remove("pass");
        String driver = config.getProperty("driver");
        if (StrUtil.isNotBlank(driver)) {
            config.remove("driver");
            ds.setDriverClassName(config.getProperty("driver"));
        }
        Properties config2 = new Properties();
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            String keyStr = StrUtil.addPrefixIfNot(Convert.toStr(entry.getKey()), "druid.");
            config2.put(keyStr, entry.getValue());
        }
        ds.configFromPropety(config2);
        return ds;
    }
}

