/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.sql;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.dialect.DialectName;
import com.xiaoleilu.hutool.db.sql.Condition;
import com.xiaoleilu.hutool.db.sql.Direction;
import com.xiaoleilu.hutool.db.sql.LogicalOperator;
import com.xiaoleilu.hutool.db.sql.Order;
import com.xiaoleilu.hutool.db.sql.SqlFormatter;
import com.xiaoleilu.hutool.db.sql.Wrapper;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SqlBuilder {
    private static final Log log = StaticLog.get();
    private static boolean showSql;
    private static boolean formatSql;
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> paramValues = new ArrayList<Object>();
    private Wrapper wrapper;

    public static SqlBuilder create() {
        return new SqlBuilder();
    }

    public static SqlBuilder create(Wrapper wrapper) {
        return new SqlBuilder(wrapper);
    }

    public static void setShowSql(boolean isShowSql, boolean isFormatSql) {
        showSql = isShowSql;
        formatSql = isFormatSql;
    }

    public SqlBuilder() {
    }

    public SqlBuilder(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public SqlBuilder insert(Entity entity) {
        return this.insert(entity, DialectName.ANSI);
    }

    public SqlBuilder insert(Entity entity, DialectName dialectName) {
        DbUtil.validateEntity(entity);
        if (null != this.wrapper) {
            entity = this.wrapper.wrap(entity);
        }
        boolean isOracle = ObjectUtil.equal((Object)dialectName, (Object)DialectName.ORACLE);
        StringBuilder fields = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry entry : entity.entrySet()) {
            String field = (String)entry.getKey();
            Object value = entry.getValue();
            if (!StrUtil.isNotBlank(field) || null == value) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                fields.append(", ");
                placeHolder.append(", ");
            }
            fields.append(field);
            if (isOracle && value instanceof String && StrUtil.endWithIgnoreCase((String)value, ".nextval")) {
                placeHolder.append(value);
                continue;
            }
            placeHolder.append("?");
            this.paramValues.add(value);
        }
        this.sql.append("INSERT INTO ").append(entity.getTableName()).append(" (").append((CharSequence)fields).append(") VALUES (").append(placeHolder.toString()).append(")");
        return this;
    }

    public SqlBuilder delete(String tableName) {
        if (StrUtil.isBlank(tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        this.sql.append("DELETE FROM ").append(tableName);
        return this;
    }

    public SqlBuilder update(Entity entity) {
        DbUtil.validateEntity(entity);
        if (null != this.wrapper) {
            entity = this.wrapper.wrap(entity);
        }
        this.sql.append("UPDATE ").append(entity.getTableName()).append(" SET ");
        for (Map.Entry entry : entity.entrySet()) {
            String key = (String)entry.getKey();
            if (!StrUtil.isNotBlank(key)) continue;
            if (this.paramValues.size() > 0) {
                this.sql.append(", ");
            }
            this.sql.append((String)entry.getKey()).append(" = ? ");
            this.paramValues.add(entry.getValue());
        }
        return this;
    }

    public SqlBuilder select(boolean isDistinct, String ... fields) {
        return this.select(isDistinct, Arrays.asList(fields));
    }

    public SqlBuilder select(boolean isDistinct, Collection<String> fields) {
        this.sql.append("SELECT ");
        if (isDistinct) {
            this.sql.append("DISTINCT ");
        }
        if (CollectionUtil.isEmpty(fields)) {
            this.sql.append("*");
        } else {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(CollectionUtil.join(fields, ","));
        }
        return this;
    }

    public SqlBuilder select(String ... fields) {
        return this.select(false, fields);
    }

    public SqlBuilder select(Collection<String> fields) {
        return this.select(false, fields);
    }

    public SqlBuilder from(String ... tableNames) {
        if (ArrayUtil.isEmpty(tableNames) || StrUtil.hasBlank(tableNames)) {
            throw new DbRuntimeException("Table name is blank in table names !");
        }
        if (null != this.wrapper) {
            tableNames = this.wrapper.wrap(tableNames);
        }
        this.sql.append(" FROM ").append(ArrayUtil.join(tableNames, ","));
        return this;
    }

    public SqlBuilder where(LogicalOperator logicalOperator, Condition ... conditions) {
        if (ArrayUtil.isNotEmpty(conditions)) {
            if (null != this.wrapper) {
                conditions = this.wrapper.wrap(conditions);
            }
            this.where(this.buildCondition(logicalOperator, conditions));
        }
        return this;
    }

    public SqlBuilder where(String where) {
        if (StrUtil.isNotBlank(where)) {
            this.sql.append(" WHERE ").append(where);
        }
        return this;
    }

    public <T> SqlBuilder in(String field, T ... values) {
        this.sql.append(this.wrapper.wrap(field)).append(" IN ").append("(").append(ArrayUtil.join(values, ",")).append(")");
        return this;
    }

    public SqlBuilder groupBy(String ... fields) {
        if (ArrayUtil.isNotEmpty(fields)) {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(" GROUP BY ").append(ArrayUtil.join(fields, ","));
        }
        return this;
    }

    public SqlBuilder having(LogicalOperator logicalOperator, Condition ... conditions) {
        if (ArrayUtil.isNotEmpty(conditions)) {
            if (null != this.wrapper) {
                conditions = this.wrapper.wrap(conditions);
            }
            this.having(this.buildCondition(logicalOperator, conditions));
        }
        return this;
    }

    public SqlBuilder having(String having) {
        if (StrUtil.isNotBlank(having)) {
            this.sql.append(" HAVING ").append(having);
        }
        return this;
    }

    public SqlBuilder orderBy(Order ... orders) {
        if (ArrayUtil.isEmpty(orders)) {
            return this;
        }
        this.sql.append(" ORDER BY ");
        String field = null;
        boolean isFirst = true;
        for (Order order : orders) {
            if (null != this.wrapper) {
                field = this.wrapper.wrap(order.getField());
            }
            if (StrUtil.isBlank(field)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                this.sql.append(",");
            }
            this.sql.append(field);
            Direction direction = order.getDirection();
            if (null == direction) continue;
            this.sql.append(" ").append((Object)direction);
        }
        return this;
    }

    public SqlBuilder join(String tableName, Join join) {
        if (StrUtil.isBlank(tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != join) {
            this.sql.append(" ").append((Object)join).append(" JOIN ");
            if (null != this.wrapper) {
                tableName = this.wrapper.wrap(tableName);
            }
            this.sql.append(tableName);
        }
        return this;
    }

    public SqlBuilder on(LogicalOperator logicalOperator, Condition ... conditions) {
        if (ArrayUtil.isNotEmpty(conditions)) {
            if (null != this.wrapper) {
                conditions = this.wrapper.wrap(conditions);
            }
            this.on(this.buildCondition(logicalOperator, conditions));
        }
        return this;
    }

    public SqlBuilder on(String on) {
        if (StrUtil.isNotBlank(on)) {
            this.sql.append(" ON ").append(on);
        }
        return this;
    }

    public SqlBuilder append(Object sqlPart) {
        if (null != sqlPart) {
            this.sql.append(sqlPart);
        }
        return this;
    }

    public List<Object> getParamValues() {
        return this.paramValues;
    }

    public Object[] getParamValueArray() {
        return this.paramValues.toArray(new Object[this.paramValues.size()]);
    }

    public String build() {
        return this.build(showSql);
    }

    public String build(boolean isShowDebugSql) {
        String sqlStr = this.sql.toString().trim();
        if (isShowDebugSql) {
            log.debug("\n{}", formatSql ? SqlFormatter.format(sqlStr) : sqlStr);
        }
        return sqlStr;
    }

    public String toString() {
        return this.build();
    }

    private String buildCondition(LogicalOperator logicalOperator, Condition ... conditions) {
        if (ArrayUtil.isEmpty(conditions)) {
            return "";
        }
        if (null == logicalOperator) {
            logicalOperator = LogicalOperator.AND;
        }
        StringBuilder conditionStr = new StringBuilder();
        boolean isFirst = true;
        for (Condition condition : conditions) {
            if (isFirst) {
                isFirst = false;
            } else {
                conditionStr.append(" ").append((Object)logicalOperator).append(" ");
            }
            conditionStr.append(condition.getField()).append(" ").append(condition.getOperator());
            if (condition.isPlaceHolder()) {
                conditionStr.append(" ?");
                this.paramValues.add(condition.getValue());
                continue;
            }
            conditionStr.append(condition.getValue());
        }
        return conditionStr.toString();
    }

    public static enum Join {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

