/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public class RandomUtil {
    private static final String BASE_NUMBER = "0123456789";
    private static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static int randomInt(int min, int max) {
        Random random = new Random();
        return random.nextInt(max - min) + min;
    }

    public static int randomInt() {
        Random random = new Random();
        return random.nextInt();
    }

    public static int randomInt(int limit) {
        Random random = new Random();
        return random.nextInt(limit);
    }

    public static byte[] randomBytes(int length) {
        Random random = new Random();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static <T> T randomEle(List<T> list) {
        return RandomUtil.randomEle(list, list.size());
    }

    public static <T> T randomEle(List<T> list, int limit) {
        return list.get(RandomUtil.randomInt(limit));
    }

    public static <T> List<T> randomEles(List<T> list, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (--count > 0) {
            result.add(RandomUtil.randomEle(list, limit));
        }
        return result;
    }

    public static <T> Set<T> randomEleSet(Collection<T> collection, int count) {
        ArrayList<T> source = new ArrayList<T>(new HashSet<T>(collection));
        if (count > source.size()) {
            throw new IllegalArgumentException("Count is larger than collection distinct size !");
        }
        HashSet<T> result = new HashSet<T>(count);
        int limit = collection.size();
        while (result.size() <= count) {
            result.add(RandomUtil.randomEle(source, limit));
        }
        return result;
    }

    public static String randomString(int length) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomNumbers(int length) {
        return RandomUtil.randomString(BASE_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }
}

