/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.model.FlowPackage;
import com.yunpian.sdk.model.FlowSend;
import com.yunpian.sdk.model.FlowStatus;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.util.JsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class FlowApi
extends YunpianApi {
    public static final String NAME = "flow";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(YunpianClient clnt) {
        super.init(clnt);
        this.host(clnt.getConf().getConf("yp.flow.host", "https://flow.yunpian.com"));
    }

    public Result<List<FlowPackage>> get_package(Map<String, String> param) {
        Result<List<FlowPackage>> r = new Result<List<FlowPackage>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<FlowPackage> h = new YunpianApiResult.SimpleListResultHandler<FlowPackage>(){

            @Override
            public List<FlowPackage> data(List<FlowPackage> rsp) {
                switch (FlowApi.this.version()) {
                    case "v1": {
                        if (this.rspMap != null) {
                            String flow = (String)this.rspMap.get("flow_package");
                            return (List)JsonUtil.fromJson(flow, new TypeToken<ArrayList<FlowPackage>>(){}.getType());
                        }
                    }
                    case "v2": {
                        return rsp;
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public Integer code(List<FlowPackage> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, FlowApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<FlowPackage>>(){}.getType();
            }
        };
        try {
            return this.path("get_package.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<FlowSend> recharge(Map<String, String> param) {
        Result<FlowSend> r = new Result<FlowSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "sn");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<FlowSend> h = new YunpianApiResult.MapResultHandler<FlowSend>(){

            @Override
            public FlowSend data(Map<String, String> rsp) {
                switch (FlowApi.this.version()) {
                    case "v1": {
                        return JsonUtil.fromJson(rsp.get("result"), FlowSend.class);
                    }
                    case "v2": {
                        return FlowApi.this.map2flowResult(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, FlowApi.this.version());
            }
        };
        try {
            return this.path("recharge.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<FlowStatus>> pull_status(Map<String, String> param) {
        Result<List<FlowStatus>> r = new Result<List<FlowStatus>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<FlowStatus> h = new YunpianApiResult.SimpleListResultHandler<FlowStatus>(){

            @Override
            public List<FlowStatus> data(List<FlowStatus> rsp) {
                switch (FlowApi.this.version()) {
                    case "v1": {
                        if (this.rspMap != null) {
                            String flow = (String)this.rspMap.get("flow_status");
                            return (List)JsonUtil.fromJson(flow, new TypeToken<ArrayList<FlowStatus>>(){}.getType());
                        }
                    }
                    case "v2": {
                        return rsp;
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public Integer code(List<FlowStatus> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, FlowApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<FlowStatus>>(){}.getType();
            }
        };
        try {
            return this.path("pull_status.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    protected FlowSend map2flowResult(Map<String, String> rsp) {
        if (rsp == null || rsp.isEmpty()) {
            return null;
        }
        try {
            FlowSend info = new FlowSend();
            info.setCount(rsp.get("count"));
            info.setFee(Double.parseDouble(rsp.get("fee")));
            info.setSid(rsp.get("sid"));
            return info;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e.fillInStackTrace());
            return null;
        }
    }
}

