/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.model.ShortUrl;
import com.yunpian.sdk.util.JsonUtil;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class ShortUrlApi
extends YunpianApi {
    public static final String NAME = "short_url";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(YunpianClient clnt) {
        super.init(clnt);
        this.host(clnt.getConf().getConf("yp.short_url.host", "https://sms.yunpian.com"));
    }

    public Result<ShortUrl> shorten(Map<String, String> param) {
        Result<ShortUrl> r = new Result<ShortUrl>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "long_url");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<ShortUrl> h = new YunpianApiResult.MapResultHandler<ShortUrl>(){

            @Override
            public ShortUrl data(Map<String, String> rsp) {
                switch (ShortUrlApi.this.version()) {
                    case "v2": {
                        return JsonUtil.fromJson(rsp.get(ShortUrlApi.NAME), ShortUrl.class);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, ShortUrlApi.this.version());
            }
        };
        try {
            return this.path("shorten.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Map<String, Long>> stat(Map<String, String> param) {
        Result<Map<String, Long>> r = new Result<Map<String, Long>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "sid");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Map<String, Long>> h = new YunpianApiResult.MapResultHandler<Map<String, Long>>(){

            @Override
            public Map<String, Long> data(Map<String, String> rsp) {
                switch (ShortUrlApi.this.version()) {
                    case "v2": {
                        TypeToken<Map<String, Long>> typeToken = new TypeToken<Map<String, Long>>(){};
                        return (Map)JsonUtil.fromJson(rsp.get("stat"), typeToken.getType());
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, ShortUrlApi.this.version());
            }
        };
        try {
            return this.path("stat.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }
}

