/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class JsonUtil {
    private static final Gson Gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();

    public static <T> T fromJson(String json, Class<T> clazz) {
        if (json == null || "".equals(json)) {
            return null;
        }
        return (T)Gson.fromJson(json, clazz);
    }

    public static String toJson(Object obj) {
        return Gson.toJson(obj);
    }

    public static Map<String, String> fromJsonToMap(String json) throws IOException {
        return JsonUtil.toMapStr(json);
    }

    public static <T> T fromJsonToMap(Reader json, Type type) {
        return (T)Gson.fromJson(json, type);
    }

    public static <T> T fromJson(String json, Type t) {
        return (T)Gson.fromJson(json, t);
    }

    public static <T> T fromJson(Reader json, Type t) {
        return (T)Gson.fromJson(json, t);
    }

    private static Map<String, String> toMapStr(String json) throws IOException {
        try (JsonReader in = new JsonReader((Reader)new StringReader(json));){
            JsonToken token = in.peek();
            if (token.equals((Object)JsonToken.BEGIN_OBJECT)) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                in.beginObject();
                while (in.hasNext()) {
                    map.put(in.nextName(), JsonUtil.read2Str(in, true).toString());
                }
                in.endObject();
                LinkedHashMap<String, String> linkedHashMap = map;
                return linkedHashMap;
            }
            Map<String, String> map = Collections.emptyMap();
            return map;
        }
    }

    private static Object read2Str(JsonReader in, boolean str) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                LinkedList<Object> list = new LinkedList<Object>();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(JsonUtil.read2Str(in, false));
                }
                in.endArray();
                return str ? JsonUtil.toJson(list) : list;
            }
            case BEGIN_OBJECT: {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                in.beginObject();
                while (in.hasNext()) {
                    map.put(in.nextName(), JsonUtil.read2Str(in, false));
                }
                in.endObject();
                return str ? JsonUtil.toJson(map) : map;
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                return in.nextString();
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return "";
            }
        }
        return in.nextString();
    }
}

