/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.UnsupportedPlatformException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ListBundlersMojo
extends AbstractMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Bundlers bundlers = Bundlers.createBundlersInstance();
        this.getLog().info((CharSequence)"Available bundlers:");
        this.getLog().info((CharSequence)"-------------------");
        HashMap dummyParams = new HashMap();
        bundlers.getBundlers().stream().forEach(bundler -> {
            try {
                bundler.validate(dummyParams);
            }
            catch (UnsupportedPlatformException ex) {
                return;
            }
            catch (ConfigException ex) {
                // empty catch block
            }
            this.getLog().info((CharSequence)("ID: " + bundler.getID()));
            this.getLog().info((CharSequence)("Name: " + bundler.getName()));
            this.getLog().info((CharSequence)("Description: " + bundler.getDescription()));
            Collection bundleParameters = bundler.getBundleParameters();
            Optional.ofNullable(bundleParameters).ifPresent(nonNullBundleArguments -> {
                this.getLog().info((CharSequence)"Available bundle arguments: ");
                nonNullBundleArguments.stream().forEach(bundleArgument -> {
                    this.getLog().info((CharSequence)("\t\tArgument ID: " + bundleArgument.getID()));
                    this.getLog().info((CharSequence)("\t\tArgument Type: " + bundleArgument.getValueType().getName()));
                    this.getLog().info((CharSequence)("\t\tArgument Name: " + bundleArgument.getName()));
                    this.getLog().info((CharSequence)("\t\tArgument Description: " + bundleArgument.getDescription()));
                    this.getLog().info((CharSequence)"");
                });
            });
            this.getLog().info((CharSequence)"-------------------");
        });
    }
}

