package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceReferenceBuilder extends io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference,io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceBuilder>{
  public ServiceReferenceBuilder() {
    this(false);
  }
  public ServiceReferenceBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceReference(), validationEnabled);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceReference(), validationEnabled);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference instance) {
    this(fluent, instance, false);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference instance) {
    this(instance,false);
  }
  public ServiceReferenceBuilder(io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference build() {
    ServiceReference buildable = new ServiceReference(fluent.getName(),fluent.getNamespace(),fluent.getPath(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceReferenceBuilder that = (ServiceReferenceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}