package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;

public class ConversionRequestFluentImpl<A extends io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent<A> {

    private java.lang.String desiredAPIVersion;
    private java.util.List<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> objects =  new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();
    private java.lang.String uid;

    public ConversionRequestFluentImpl() {
    }

    public ConversionRequestFluentImpl(io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequest instance) {
        this.withDesiredAPIVersion(instance.getDesiredAPIVersion()); 
        this.withObjects(instance.getObjects()); 
        this.withUid(instance.getUid()); 
    }

    public java.lang.String getDesiredAPIVersion() {
        return this.desiredAPIVersion;
    }

    public A withDesiredAPIVersion(java.lang.String desiredAPIVersion) {
        this.desiredAPIVersion=desiredAPIVersion; return (A) this;
    }

    public java.lang.Boolean hasDesiredAPIVersion() {
        return this.desiredAPIVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDesiredAPIVersion instead.
     */
        public A withNewDesiredAPIVersion(java.lang.String arg0) {
        return (A)withDesiredAPIVersion(new String(arg0));
    }

    public A addToObjects(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        _visitables.get("objects").add(builder);this.objects.add(builder); return (A)this;
    }

    public A addToObjects(int index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        _visitables.get("objects").add(index, builder);this.objects.add(index, builder); return (A)this;
    }

    public A addToObjects(int index,io.fabric8.kubernetes.api.model.HasMetadata item) {
        if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){addToPersistentVolumeClaimObjects(index, (io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition){addToCustomResourceDefinitionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){addToCustomResourceDefinitionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
        
        return (A)this;
    }

    public A setToObjects(int index,io.fabric8.kubernetes.api.model.HasMetadata item) {
        if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){setToPersistentVolumeClaimObjects(index, (io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition){setToCustomResourceDefinitionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){setToCustomResourceDefinitionObjects(index, (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
        
        return (A)this;
    }

    public A addToObjects(io.fabric8.kubernetes.api.model.HasMetadata... items) {
         if (items != null && items.length > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        for (io.fabric8.kubernetes.api.model.HasMetadata item : items) { 
        if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){addToPersistentVolumeClaimObjects((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition){addToCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){addToCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
        
        else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
        } return (A)this;
    }

    public A addAllToObjects(java.util.Collection<io.fabric8.kubernetes.api.model.HasMetadata> items) {
         if (items != null && items.size() > 0 && this.objects== null) {this.objects = new ArrayList<VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        for (io.fabric8.kubernetes.api.model.HasMetadata item : items) { 
        if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){addToPersistentVolumeClaimObjects((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition){addToCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){addToCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
        
        else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("objects").add(builder);this.objects.add(builder); }
        } return (A)this;
    }

    public A removeFromObjects(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        _visitables.get("objects").remove(builder);this.objects.remove(builder); return (A)this;
    }

    public A removeFromObjects(io.fabric8.kubernetes.api.model.HasMetadata... items) {
        for (io.fabric8.kubernetes.api.model.HasMetadata item : items) {if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition){removeFromCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){removeFromCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
        
        else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
        } return (A)this;
    }

    public A removeAllFromObjects(java.util.Collection<io.fabric8.kubernetes.api.model.HasMetadata> items) {
        for (io.fabric8.kubernetes.api.model.HasMetadata item : items) {if (item instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){removeFromPersistentVolumeClaimObjects((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition){removeFromCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)item);}
         else if (item instanceof io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition){removeFromCustomResourceDefinitionObjects((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition)item);}
        
        else {  VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = builderOf(item); _visitables.get("objects").remove(builder);this.objects.remove(builder); }
        } return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildObjects instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> getObjects() {
        return build(objects);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> buildObjects() {
        return build(objects);
    }

    public io.fabric8.kubernetes.api.model.HasMetadata buildObject(int index) {
        return this.objects.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.HasMetadata buildFirstObject() {
        return this.objects.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.HasMetadata buildLastObject() {
        return this.objects.get(objects.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.HasMetadata buildMatchingObject(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
        for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> item: objects) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingObject(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
        for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> item: objects) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withObjects(java.util.List<io.fabric8.kubernetes.api.model.HasMetadata> objects) {
        if (this.objects != null) { _visitables.get("objects").removeAll(this.objects);}
        if (objects != null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>(); for (io.fabric8.kubernetes.api.model.HasMetadata item : objects){this.addToObjects(item);}} else { this.objects = null;} return (A) this;
    }

    public A withObjects(io.fabric8.kubernetes.api.model.HasMetadata... objects) {
        if (this.objects != null) {this.objects.clear();}
        if (objects != null) {for (io.fabric8.kubernetes.api.model.HasMetadata item :objects){ this.addToObjects(item);}} return (A) this;
    }

    public java.lang.Boolean hasObjects() {
        return objects != null && !objects.isEmpty();
    }

    public A addToPersistentVolumeClaimObjects(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToPersistentVolumeClaimObjects(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);
        if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
        if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
         return (A)this;
    }

    public A addToPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToPersistentVolumeClaimObjects(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
        for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromPersistentVolumeClaimObjects(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items) {
        for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPersistentVolumeClaimObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
        if (objects == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
        final List visitables = _visitables.get("objects");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject() {
        return new io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl.PersistentVolumeClaimObjectsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
        return new io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl.PersistentVolumeClaimObjectsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.PersistentVolumeClaimObjectsNested<A> setNewPersistentVolumeClaimObjectLike(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
        return new io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl.PersistentVolumeClaimObjectsNestedImpl(index, item);
    }

    public A addToCustomResourceDefinitionObjects(int index,io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition item) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToCustomResourceDefinitionObjects(int index,io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition item) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder(item);
        if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
        if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
         return (A)this;
    }

    public A addToCustomResourceDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition... items) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToCustomResourceDefinitionObjects(java.util.Collection<io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition> items) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromCustomResourceDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition... items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromCustomResourceDefinitionObjects(java.util.Collection<io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition> items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromCustomResourceDefinitionObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
        if (objects == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
        final List visitables = _visitables.get("objects");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.CustomResourceDefinitionObjectsNested<A> addNewCustomResourceDefinitionObject() {
        return new io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl.CustomResourceDefinitionObjectsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.CustomResourceDefinitionObjectsNested<A> addNewCustomResourceDefinitionObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition item) {
        return new io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl.CustomResourceDefinitionObjectsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.CustomResourceDefinitionObjectsNested<A> setNewCustomResourceDefinitionObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition item) {
        return new io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl.CustomResourceDefinitionObjectsNestedImpl(index, item);
    }

    public A addToCustomResourceDefinitionObjects(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(index >= 0 ? index : _visitables.get("objects").size(), builder);this.objects.add(index >= 0 ? index : objects.size(), builder); return (A)this;
    }

    public A setToCustomResourceDefinitionObjects(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);
        if (index < 0 || index >= _visitables.get("objects").size()) { _visitables.get("objects").add(builder); } else { _visitables.get("objects").set(index, builder);}
        if (index < 0 || index >= objects.size()) { objects.add(builder); } else { objects.set(index, builder);}
         return (A)this;
    }

    public A addToCustomResourceDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition... items) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A addAllToV1beta1CustomResourceDefinitionObjects(java.util.Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition> items) {
        if (this.objects == null) {this.objects = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").add(builder);this.objects.add(builder);} return (A)this;
    }

    public A removeFromCustomResourceDefinitionObjects(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition... items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeAllFromV1beta1CustomResourceDefinitionObjects(java.util.Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition> items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(item);_visitables.get("objects").remove(builder);if (this.objects != null) {this.objects.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromV1beta1CustomResourceDefinitionObjects(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> predicate) {
        if (objects == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?>> each = objects.iterator();
        final List visitables = _visitables.get("objects");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<A> addNewV1beta1CustomResourceDefinitionObject() {
        return new io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionObjectsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<A> addNewCustomResourceDefinitionObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
        return new io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionObjectsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<A> setNewCustomResourceDefinitionObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
        return new io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl.V1beta1CustomResourceDefinitionObjectsNestedImpl(index, item);
    }

    public java.lang.String getUid() {
        return this.uid;
    }

    public A withUid(java.lang.String uid) {
        this.uid=uid; return (A) this;
    }

    public java.lang.Boolean hasUid() {
        return this.uid != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUid instead.
     */
        public A withNewUid(java.lang.String arg0) {
        return (A)withUid(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConversionRequestFluentImpl that = (ConversionRequestFluentImpl) o;
        if (desiredAPIVersion != null ? !desiredAPIVersion.equals(that.desiredAPIVersion) :that.desiredAPIVersion != null) return false;
        if (objects != null ? !objects.equals(that.objects) :that.objects != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(desiredAPIVersion,  objects,  uid,  super.hashCode());
    }

    public class PersistentVolumeClaimObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.PersistentVolumeClaimObjectsNested<N>> implements io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.PersistentVolumeClaimObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
        private final int index;

            PersistentVolumeClaimObjectsNestedImpl(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimObjectsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
            }

            public N endPersistentVolumeClaimObject() {
                return and();
            }
    }


    public class CustomResourceDefinitionObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.CustomResourceDefinitionObjectsNested<N>> implements io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.CustomResourceDefinitionObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder builder;
        private final int index;

            CustomResourceDefinitionObjectsNestedImpl(int index,io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder(this, item);
                        
            }

            CustomResourceDefinitionObjectsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder(this);
                        
            }

            public N and() {
                return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
            }

            public N endCustomResourceDefinitionObject() {
                return and();
            }
    }


    public class V1beta1CustomResourceDefinitionObjectsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<N>> implements io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent.V1beta1CustomResourceDefinitionObjectsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder;
        private final int index;

            V1beta1CustomResourceDefinitionObjectsNestedImpl(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(this, item);
                        
            }

            V1beta1CustomResourceDefinitionObjectsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(this);
                        
            }

            public N and() {
                return (N) ConversionRequestFluentImpl.this.setToObjects(index,builder.build());
            }

            public N endV1beta1CustomResourceDefinitionObject() {
                return and();
            }
    }


}
