package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class HTTPIngressPathBuilder extends io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath,io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathBuilder>{
  public HTTPIngressPathBuilder() {
    this(false);
  }
  public HTTPIngressPathBuilder(java.lang.Boolean validationEnabled) {
    this(new HTTPIngressPath(), validationEnabled);
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HTTPIngressPath(), validationEnabled);
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath instance) {
    this(fluent, instance, false);
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBackend(instance.getBackend()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPathType(instance.getPathType()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath instance) {
    this(instance,false);
  }
  public HTTPIngressPathBuilder(io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBackend(instance.getBackend()); 
    this.withPath(instance.getPath()); 
    this.withPathType(instance.getPathType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath build() {
    HTTPIngressPath buildable = new HTTPIngressPath(fluent.getBackend(),fluent.getPath(),fluent.getPathType());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPIngressPathBuilder that = (HTTPIngressPathBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}