package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NetworkPolicyPeerBuilder extends io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder>{
  public NetworkPolicyPeerBuilder() {
    this(false);
  }
  public NetworkPolicyPeerBuilder(java.lang.Boolean validationEnabled) {
    this(new NetworkPolicyPeer(), validationEnabled);
  }
  public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicyPeer(), validationEnabled);
  }
  public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIpBlock(instance.getIpBlock()); 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withPodSelector(instance.getPodSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer instance) {
    this(instance,false);
  }
  public NetworkPolicyPeerBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIpBlock(instance.getIpBlock()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withPodSelector(instance.getPodSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer build() {
    NetworkPolicyPeer buildable = new NetworkPolicyPeer(fluent.getIpBlock(),fluent.getNamespaceSelector(),fluent.getPodSelector());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkPolicyPeerBuilder that = (NetworkPolicyPeerBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}