package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

public interface TemplateFluent<A extends TemplateFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public TemplateFluent.MetadataNested<A> withNewMetadata();
    public TemplateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public TemplateFluent.MetadataNested<A> editMetadata();
    public TemplateFluent.MetadataNested<A> editOrNewMetadata();
    public TemplateFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToObjects(VisitableBuilder<? extends HasMetadata,?> builder);
    public A addToObjects(int index,VisitableBuilder<? extends HasMetadata,?> builder);
    public A addToObjects(int index,HasMetadata item);
    public A setToObjects(int index,HasMetadata item);
    public A addToObjects(HasMetadata... items);
    public A addAllToObjects(Collection<HasMetadata> items);
    public A removeFromObjects(VisitableBuilder<? extends HasMetadata,?> builder);
    public A removeFromObjects(HasMetadata... items);
    public A removeAllFromObjects(Collection<HasMetadata> items);
    
/**
 * This method has been deprecated, please use method buildObjects instead.
 * @return The buildable object.
 */
@Deprecated public List<HasMetadata> getObjects();
    public List<HasMetadata> buildObjects();
    public HasMetadata buildObject(int index);
    public HasMetadata buildFirstObject();
    public HasMetadata buildLastObject();
    public HasMetadata buildMatchingObject(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public Boolean hasMatchingObject(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public A withObjects(List<HasMetadata> objects);
    public A withObjects(HasMetadata... objects);
    public Boolean hasObjects();
    public A addToClusterVersionObjects(int index,ClusterVersion item);
    public A setToClusterVersionObjects(int index,ClusterVersion item);
    public A addToClusterVersionObjects(ClusterVersion... items);
    public A addAllToClusterVersionObjects(Collection<ClusterVersion> items);
    public A removeFromClusterVersionObjects(ClusterVersion... items);
    public A removeAllFromClusterVersionObjects(Collection<ClusterVersion> items);
    public A removeMatchingFromClusterVersionObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ClusterVersionObjectsNested<A> setNewClusterVersionObjectLike(int index,ClusterVersion item);
    public TemplateFluent.ClusterVersionObjectsNested<A> addNewClusterVersionObject();
    public TemplateFluent.ClusterVersionObjectsNested<A> addNewClusterVersionObjectLike(ClusterVersion item);
    public A addToImageStreamImportObjects(int index,ImageStreamImport item);
    public A setToImageStreamImportObjects(int index,ImageStreamImport item);
    public A addToImageStreamImportObjects(ImageStreamImport... items);
    public A addAllToImageStreamImportObjects(Collection<ImageStreamImport> items);
    public A removeFromImageStreamImportObjects(ImageStreamImport... items);
    public A removeAllFromImageStreamImportObjects(Collection<ImageStreamImport> items);
    public A removeMatchingFromImageStreamImportObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ImageStreamImportObjectsNested<A> setNewImageStreamImportObjectLike(int index,ImageStreamImport item);
    public TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObject();
    public TemplateFluent.ImageStreamImportObjectsNested<A> addNewImageStreamImportObjectLike(ImageStreamImport item);
    public A addToOAuthAccessTokenObjects(int index,OAuthAccessToken item);
    public A setToOAuthAccessTokenObjects(int index,OAuthAccessToken item);
    public A addToOAuthAccessTokenObjects(OAuthAccessToken... items);
    public A addAllToOAuthAccessTokenObjects(Collection<OAuthAccessToken> items);
    public A removeFromOAuthAccessTokenObjects(OAuthAccessToken... items);
    public A removeAllFromOAuthAccessTokenObjects(Collection<OAuthAccessToken> items);
    public A removeMatchingFromOAuthAccessTokenObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.OAuthAccessTokenObjectsNested<A> setNewOAuthAccessTokenObjectLike(int index,OAuthAccessToken item);
    public TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObject();
    public TemplateFluent.OAuthAccessTokenObjectsNested<A> addNewOAuthAccessTokenObjectLike(OAuthAccessToken item);
    public A addToDeploymentConfigObjects(int index,DeploymentConfig item);
    public A setToDeploymentConfigObjects(int index,DeploymentConfig item);
    public A addToDeploymentConfigObjects(DeploymentConfig... items);
    public A addAllToDeploymentConfigObjects(Collection<DeploymentConfig> items);
    public A removeFromDeploymentConfigObjects(DeploymentConfig... items);
    public A removeAllFromDeploymentConfigObjects(Collection<DeploymentConfig> items);
    public A removeMatchingFromDeploymentConfigObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.DeploymentConfigObjectsNested<A> setNewDeploymentConfigObjectLike(int index,DeploymentConfig item);
    public TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObject();
    public TemplateFluent.DeploymentConfigObjectsNested<A> addNewDeploymentConfigObjectLike(DeploymentConfig item);
    public A addToRoleBindingObjects(int index,RoleBinding item);
    public A setToRoleBindingObjects(int index,RoleBinding item);
    public A addToRoleBindingObjects(RoleBinding... items);
    public A addAllToRoleBindingObjects(Collection<RoleBinding> items);
    public A removeFromRoleBindingObjects(RoleBinding... items);
    public A removeAllFromRoleBindingObjects(Collection<RoleBinding> items);
    public A removeMatchingFromRoleBindingObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.RoleBindingObjectsNested<A> setNewRoleBindingObjectLike(int index,RoleBinding item);
    public TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObject();
    public TemplateFluent.RoleBindingObjectsNested<A> addNewRoleBindingObjectLike(RoleBinding item);
    public A addToImageObjects(int index,Image item);
    public A setToImageObjects(int index,Image item);
    public A addToImageObjects(Image... items);
    public A addAllToImageObjects(Collection<Image> items);
    public A removeFromImageObjects(Image... items);
    public A removeAllFromImageObjects(Collection<Image> items);
    public A removeMatchingFromImageObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ImageObjectsNested<A> setNewImageObjectLike(int index,Image item);
    public TemplateFluent.ImageObjectsNested<A> addNewImageObject();
    public TemplateFluent.ImageObjectsNested<A> addNewImageObjectLike(Image item);
    public A addToPersistentVolumeClaimObjects(int index,PersistentVolumeClaim item);
    public A setToPersistentVolumeClaimObjects(int index,PersistentVolumeClaim item);
    public A addToPersistentVolumeClaimObjects(PersistentVolumeClaim... items);
    public A addAllToPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items);
    public A removeFromPersistentVolumeClaimObjects(PersistentVolumeClaim... items);
    public A removeAllFromPersistentVolumeClaimObjects(Collection<PersistentVolumeClaim> items);
    public A removeMatchingFromPersistentVolumeClaimObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.PersistentVolumeClaimObjectsNested<A> setNewPersistentVolumeClaimObjectLike(int index,PersistentVolumeClaim item);
    public TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObject();
    public TemplateFluent.PersistentVolumeClaimObjectsNested<A> addNewPersistentVolumeClaimObjectLike(PersistentVolumeClaim item);
    public A addToRoleObjects(int index,Role item);
    public A setToRoleObjects(int index,Role item);
    public A addToRoleObjects(Role... items);
    public A addAllToRoleObjects(Collection<Role> items);
    public A removeFromRoleObjects(Role... items);
    public A removeAllFromRoleObjects(Collection<Role> items);
    public A removeMatchingFromRoleObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.RoleObjectsNested<A> setNewRoleObjectLike(int index,Role item);
    public TemplateFluent.RoleObjectsNested<A> addNewRoleObject();
    public TemplateFluent.RoleObjectsNested<A> addNewRoleObjectLike(Role item);
    public A addToProjectObjects(int index,Project item);
    public A setToProjectObjects(int index,Project item);
    public A addToProjectObjects(Project... items);
    public A addAllToProjectObjects(Collection<Project> items);
    public A removeFromProjectObjects(Project... items);
    public A removeAllFromProjectObjects(Collection<Project> items);
    public A removeMatchingFromProjectObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ProjectObjectsNested<A> setNewProjectObjectLike(int index,Project item);
    public TemplateFluent.ProjectObjectsNested<A> addNewProjectObject();
    public TemplateFluent.ProjectObjectsNested<A> addNewProjectObjectLike(Project item);
    public A addToBuildConfigObjects(int index,BuildConfig item);
    public A setToBuildConfigObjects(int index,BuildConfig item);
    public A addToBuildConfigObjects(BuildConfig... items);
    public A addAllToBuildConfigObjects(Collection<BuildConfig> items);
    public A removeFromBuildConfigObjects(BuildConfig... items);
    public A removeAllFromBuildConfigObjects(Collection<BuildConfig> items);
    public A removeMatchingFromBuildConfigObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.BuildConfigObjectsNested<A> setNewBuildConfigObjectLike(int index,BuildConfig item);
    public TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObject();
    public TemplateFluent.BuildConfigObjectsNested<A> addNewBuildConfigObjectLike(BuildConfig item);
    public A addToUserObjects(int index,User item);
    public A setToUserObjects(int index,User item);
    public A addToUserObjects(User... items);
    public A addAllToUserObjects(Collection<User> items);
    public A removeFromUserObjects(User... items);
    public A removeAllFromUserObjects(Collection<User> items);
    public A removeMatchingFromUserObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.UserObjectsNested<A> setNewUserObjectLike(int index,User item);
    public TemplateFluent.UserObjectsNested<A> addNewUserObject();
    public TemplateFluent.UserObjectsNested<A> addNewUserObjectLike(User item);
    public A addToRouteObjects(int index,Route item);
    public A setToRouteObjects(int index,Route item);
    public A addToRouteObjects(Route... items);
    public A addAllToRouteObjects(Collection<Route> items);
    public A removeFromRouteObjects(Route... items);
    public A removeAllFromRouteObjects(Collection<Route> items);
    public A removeMatchingFromRouteObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.RouteObjectsNested<A> setNewRouteObjectLike(int index,Route item);
    public TemplateFluent.RouteObjectsNested<A> addNewRouteObject();
    public TemplateFluent.RouteObjectsNested<A> addNewRouteObjectLike(Route item);
    public A addToBuildObjects(int index,Build item);
    public A setToBuildObjects(int index,Build item);
    public A addToBuildObjects(Build... items);
    public A addAllToBuildObjects(Collection<Build> items);
    public A removeFromBuildObjects(Build... items);
    public A removeAllFromBuildObjects(Collection<Build> items);
    public A removeMatchingFromBuildObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.BuildObjectsNested<A> setNewBuildObjectLike(int index,Build item);
    public TemplateFluent.BuildObjectsNested<A> addNewBuildObject();
    public TemplateFluent.BuildObjectsNested<A> addNewBuildObjectLike(Build item);
    public A addToOAuthAuthorizeTokenObjects(int index,OAuthAuthorizeToken item);
    public A setToOAuthAuthorizeTokenObjects(int index,OAuthAuthorizeToken item);
    public A addToOAuthAuthorizeTokenObjects(OAuthAuthorizeToken... items);
    public A addAllToOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items);
    public A removeFromOAuthAuthorizeTokenObjects(OAuthAuthorizeToken... items);
    public A removeAllFromOAuthAuthorizeTokenObjects(Collection<OAuthAuthorizeToken> items);
    public A removeMatchingFromOAuthAuthorizeTokenObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> setNewOAuthAuthorizeTokenObjectLike(int index,OAuthAuthorizeToken item);
    public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObject();
    public TemplateFluent.OAuthAuthorizeTokenObjectsNested<A> addNewOAuthAuthorizeTokenObjectLike(OAuthAuthorizeToken item);
    public A addToRoleBindingRestrictionObjects(int index,RoleBindingRestriction item);
    public A setToRoleBindingRestrictionObjects(int index,RoleBindingRestriction item);
    public A addToRoleBindingRestrictionObjects(RoleBindingRestriction... items);
    public A addAllToRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items);
    public A removeFromRoleBindingRestrictionObjects(RoleBindingRestriction... items);
    public A removeAllFromRoleBindingRestrictionObjects(Collection<RoleBindingRestriction> items);
    public A removeMatchingFromRoleBindingRestrictionObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.RoleBindingRestrictionObjectsNested<A> setNewRoleBindingRestrictionObjectLike(int index,RoleBindingRestriction item);
    public TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObject();
    public TemplateFluent.RoleBindingRestrictionObjectsNested<A> addNewRoleBindingRestrictionObjectLike(RoleBindingRestriction item);
    public A addToImageStreamTagObjects(int index,ImageStreamTag item);
    public A setToImageStreamTagObjects(int index,ImageStreamTag item);
    public A addToImageStreamTagObjects(ImageStreamTag... items);
    public A addAllToImageStreamTagObjects(Collection<ImageStreamTag> items);
    public A removeFromImageStreamTagObjects(ImageStreamTag... items);
    public A removeAllFromImageStreamTagObjects(Collection<ImageStreamTag> items);
    public A removeMatchingFromImageStreamTagObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ImageStreamTagObjectsNested<A> setNewImageStreamTagObjectLike(int index,ImageStreamTag item);
    public TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObject();
    public TemplateFluent.ImageStreamTagObjectsNested<A> addNewImageStreamTagObjectLike(ImageStreamTag item);
    public A addToGroupObjects(int index,Group item);
    public A setToGroupObjects(int index,Group item);
    public A addToGroupObjects(Group... items);
    public A addAllToGroupObjects(Collection<Group> items);
    public A removeFromGroupObjects(Group... items);
    public A removeAllFromGroupObjects(Collection<Group> items);
    public A removeMatchingFromGroupObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.GroupObjectsNested<A> setNewGroupObjectLike(int index,Group item);
    public TemplateFluent.GroupObjectsNested<A> addNewGroupObject();
    public TemplateFluent.GroupObjectsNested<A> addNewGroupObjectLike(Group item);
    public A addToTokenReviewObjects(int index,TokenReview item);
    public A setToTokenReviewObjects(int index,TokenReview item);
    public A addToTokenReviewObjects(TokenReview... items);
    public A addAllToTokenReviewObjects(Collection<TokenReview> items);
    public A removeFromTokenReviewObjects(TokenReview... items);
    public A removeAllFromTokenReviewObjects(Collection<TokenReview> items);
    public A removeMatchingFromTokenReviewObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.TokenReviewObjectsNested<A> setNewTokenReviewObjectLike(int index,TokenReview item);
    public TemplateFluent.TokenReviewObjectsNested<A> addNewTokenReviewObject();
    public TemplateFluent.TokenReviewObjectsNested<A> addNewTokenReviewObjectLike(TokenReview item);
    public A addToImageSignatureObjects(int index,ImageSignature item);
    public A setToImageSignatureObjects(int index,ImageSignature item);
    public A addToImageSignatureObjects(ImageSignature... items);
    public A addAllToImageSignatureObjects(Collection<ImageSignature> items);
    public A removeFromImageSignatureObjects(ImageSignature... items);
    public A removeAllFromImageSignatureObjects(Collection<ImageSignature> items);
    public A removeMatchingFromImageSignatureObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ImageSignatureObjectsNested<A> setNewImageSignatureObjectLike(int index,ImageSignature item);
    public TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObject();
    public TemplateFluent.ImageSignatureObjectsNested<A> addNewImageSignatureObjectLike(ImageSignature item);
    public A addToSecurityContextConstraintsObjects(int index,SecurityContextConstraints item);
    public A setToSecurityContextConstraintsObjects(int index,SecurityContextConstraints item);
    public A addToSecurityContextConstraintsObjects(SecurityContextConstraints... items);
    public A addAllToSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items);
    public A removeFromSecurityContextConstraintsObjects(SecurityContextConstraints... items);
    public A removeAllFromSecurityContextConstraintsObjects(Collection<SecurityContextConstraints> items);
    public A removeMatchingFromSecurityContextConstraintsObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.SecurityContextConstraintsObjectsNested<A> setNewSecurityContextConstraintsObjectLike(int index,SecurityContextConstraints item);
    public TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObject();
    public TemplateFluent.SecurityContextConstraintsObjectsNested<A> addNewSecurityContextConstraintsObjectLike(SecurityContextConstraints item);
    public A addToClusterRoleBindingObjects(int index,ClusterRoleBinding item);
    public A setToClusterRoleBindingObjects(int index,ClusterRoleBinding item);
    public A addToClusterRoleBindingObjects(ClusterRoleBinding... items);
    public A addAllToClusterRoleBindingObjects(Collection<ClusterRoleBinding> items);
    public A removeFromClusterRoleBindingObjects(ClusterRoleBinding... items);
    public A removeAllFromClusterRoleBindingObjects(Collection<ClusterRoleBinding> items);
    public A removeMatchingFromClusterRoleBindingObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ClusterRoleBindingObjectsNested<A> setNewClusterRoleBindingObjectLike(int index,ClusterRoleBinding item);
    public TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObject();
    public TemplateFluent.ClusterRoleBindingObjectsNested<A> addNewClusterRoleBindingObjectLike(ClusterRoleBinding item);
    public A addToBuildRequestObjects(int index,BuildRequest item);
    public A setToBuildRequestObjects(int index,BuildRequest item);
    public A addToBuildRequestObjects(BuildRequest... items);
    public A addAllToBuildRequestObjects(Collection<BuildRequest> items);
    public A removeFromBuildRequestObjects(BuildRequest... items);
    public A removeAllFromBuildRequestObjects(Collection<BuildRequest> items);
    public A removeMatchingFromBuildRequestObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.BuildRequestObjectsNested<A> setNewBuildRequestObjectLike(int index,BuildRequest item);
    public TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObject();
    public TemplateFluent.BuildRequestObjectsNested<A> addNewBuildRequestObjectLike(BuildRequest item);
    public A addToNetNamespaceObjects(int index,NetNamespace item);
    public A setToNetNamespaceObjects(int index,NetNamespace item);
    public A addToNetNamespaceObjects(NetNamespace... items);
    public A addAllToNetNamespaceObjects(Collection<NetNamespace> items);
    public A removeFromNetNamespaceObjects(NetNamespace... items);
    public A removeAllFromNetNamespaceObjects(Collection<NetNamespace> items);
    public A removeMatchingFromNetNamespaceObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.NetNamespaceObjectsNested<A> setNewNetNamespaceObjectLike(int index,NetNamespace item);
    public TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObject();
    public TemplateFluent.NetNamespaceObjectsNested<A> addNewNetNamespaceObjectLike(NetNamespace item);
    public A addToImageStreamObjects(int index,ImageStream item);
    public A setToImageStreamObjects(int index,ImageStream item);
    public A addToImageStreamObjects(ImageStream... items);
    public A addAllToImageStreamObjects(Collection<ImageStream> items);
    public A removeFromImageStreamObjects(ImageStream... items);
    public A removeAllFromImageStreamObjects(Collection<ImageStream> items);
    public A removeMatchingFromImageStreamObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ImageStreamObjectsNested<A> setNewImageStreamObjectLike(int index,ImageStream item);
    public TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObject();
    public TemplateFluent.ImageStreamObjectsNested<A> addNewImageStreamObjectLike(ImageStream item);
    public A addToProjectRequestObjects(int index,ProjectRequest item);
    public A setToProjectRequestObjects(int index,ProjectRequest item);
    public A addToProjectRequestObjects(ProjectRequest... items);
    public A addAllToProjectRequestObjects(Collection<ProjectRequest> items);
    public A removeFromProjectRequestObjects(ProjectRequest... items);
    public A removeAllFromProjectRequestObjects(Collection<ProjectRequest> items);
    public A removeMatchingFromProjectRequestObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ProjectRequestObjectsNested<A> setNewProjectRequestObjectLike(int index,ProjectRequest item);
    public TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObject();
    public TemplateFluent.ProjectRequestObjectsNested<A> addNewProjectRequestObjectLike(ProjectRequest item);
    public A addToTemplateObjects(int index,Template item);
    public A setToTemplateObjects(int index,Template item);
    public A addToTemplateObjects(Template... items);
    public A addAllToTemplateObjects(Collection<Template> items);
    public A removeFromTemplateObjects(Template... items);
    public A removeAllFromTemplateObjects(Collection<Template> items);
    public A removeMatchingFromTemplateObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.TemplateObjectsNested<A> setNewTemplateObjectLike(int index,Template item);
    public TemplateFluent.TemplateObjectsNested<A> addNewTemplateObject();
    public TemplateFluent.TemplateObjectsNested<A> addNewTemplateObjectLike(Template item);
    public A addToOAuthClientAuthorizationObjects(int index,OAuthClientAuthorization item);
    public A setToOAuthClientAuthorizationObjects(int index,OAuthClientAuthorization item);
    public A addToOAuthClientAuthorizationObjects(OAuthClientAuthorization... items);
    public A addAllToOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items);
    public A removeFromOAuthClientAuthorizationObjects(OAuthClientAuthorization... items);
    public A removeAllFromOAuthClientAuthorizationObjects(Collection<OAuthClientAuthorization> items);
    public A removeMatchingFromOAuthClientAuthorizationObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> setNewOAuthClientAuthorizationObjectLike(int index,OAuthClientAuthorization item);
    public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObject();
    public TemplateFluent.OAuthClientAuthorizationObjectsNested<A> addNewOAuthClientAuthorizationObjectLike(OAuthClientAuthorization item);
    public A addToOAuthClientObjects(int index,OAuthClient item);
    public A setToOAuthClientObjects(int index,OAuthClient item);
    public A addToOAuthClientObjects(OAuthClient... items);
    public A addAllToOAuthClientObjects(Collection<OAuthClient> items);
    public A removeFromOAuthClientObjects(OAuthClient... items);
    public A removeAllFromOAuthClientObjects(Collection<OAuthClient> items);
    public A removeMatchingFromOAuthClientObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.OAuthClientObjectsNested<A> setNewOAuthClientObjectLike(int index,OAuthClient item);
    public TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObject();
    public TemplateFluent.OAuthClientObjectsNested<A> addNewOAuthClientObjectLike(OAuthClient item);
    public A addToIdentityObjects(int index,Identity item);
    public A setToIdentityObjects(int index,Identity item);
    public A addToIdentityObjects(Identity... items);
    public A addAllToIdentityObjects(Collection<Identity> items);
    public A removeFromIdentityObjects(Identity... items);
    public A removeAllFromIdentityObjects(Collection<Identity> items);
    public A removeMatchingFromIdentityObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.IdentityObjectsNested<A> setNewIdentityObjectLike(int index,Identity item);
    public TemplateFluent.IdentityObjectsNested<A> addNewIdentityObject();
    public TemplateFluent.IdentityObjectsNested<A> addNewIdentityObjectLike(Identity item);
    public A addToClusterRoleObjects(int index,ClusterRole item);
    public A setToClusterRoleObjects(int index,ClusterRole item);
    public A addToClusterRoleObjects(ClusterRole... items);
    public A addAllToClusterRoleObjects(Collection<ClusterRole> items);
    public A removeFromClusterRoleObjects(ClusterRole... items);
    public A removeAllFromClusterRoleObjects(Collection<ClusterRole> items);
    public A removeMatchingFromClusterRoleObjects(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
    public TemplateFluent.ClusterRoleObjectsNested<A> setNewClusterRoleObjectLike(int index,ClusterRole item);
    public TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObject();
    public TemplateFluent.ClusterRoleObjectsNested<A> addNewClusterRoleObjectLike(ClusterRole item);
    public A addToParameters(int index,Parameter item);
    public A setToParameters(int index,Parameter item);
    public A addToParameters(Parameter... items);
    public A addAllToParameters(Collection<Parameter> items);
    public A removeFromParameters(Parameter... items);
    public A removeAllFromParameters(Collection<Parameter> items);
    public A removeMatchingFromParameters(io.fabric8.kubernetes.api.builder.Predicate<ParameterBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildParameters instead.
 * @return The buildable object.
 */
@Deprecated public List<Parameter> getParameters();
    public List<Parameter> buildParameters();
    public Parameter buildParameter(int index);
    public Parameter buildFirstParameter();
    public Parameter buildLastParameter();
    public Parameter buildMatchingParameter(io.fabric8.kubernetes.api.builder.Predicate<ParameterBuilder> predicate);
    public Boolean hasMatchingParameter(io.fabric8.kubernetes.api.builder.Predicate<ParameterBuilder> predicate);
    public A withParameters(List<Parameter> parameters);
    public A withParameters(Parameter... parameters);
    public Boolean hasParameters();
    public TemplateFluent.ParametersNested<A> addNewParameter();
    public TemplateFluent.ParametersNested<A> addNewParameterLike(Parameter item);
    public TemplateFluent.ParametersNested<A> setNewParameterLike(int index,Parameter item);
    public TemplateFluent.ParametersNested<A> editParameter(int index);
    public TemplateFluent.ParametersNested<A> editFirstParameter();
    public TemplateFluent.ParametersNested<A> editLastParameter();
    public TemplateFluent.ParametersNested<A> editMatchingParameter(io.fabric8.kubernetes.api.builder.Predicate<ParameterBuilder> predicate);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<TemplateFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface ClusterVersionObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionFluent<TemplateFluent.ClusterVersionObjectsNested<N>>{

        
    public N and();    public N endClusterVersionObject();
}
    public interface ImageStreamImportObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImportFluent<TemplateFluent.ImageStreamImportObjectsNested<N>>{

        
    public N and();    public N endImageStreamImportObject();
}
    public interface OAuthAccessTokenObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAccessTokenFluent<TemplateFluent.OAuthAccessTokenObjectsNested<N>>{

        
    public N and();    public N endOAuthAccessTokenObject();
}
    public interface DeploymentConfigObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigFluent<TemplateFluent.DeploymentConfigObjectsNested<N>>{

        
    public N and();    public N endDeploymentConfigObject();
}
    public interface RoleBindingObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<TemplateFluent.RoleBindingObjectsNested<N>>{

        
    public N and();    public N endRoleBindingObject();
}
    public interface ImageObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<TemplateFluent.ImageObjectsNested<N>>{

        
    public N and();    public N endImageObject();
}
    public interface PersistentVolumeClaimObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<TemplateFluent.PersistentVolumeClaimObjectsNested<N>>{

        
    public N and();    public N endPersistentVolumeClaimObject();
}
    public interface RoleObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleFluent<TemplateFluent.RoleObjectsNested<N>>{

        
    public N and();    public N endRoleObject();
}
    public interface ProjectObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectFluent<TemplateFluent.ProjectObjectsNested<N>>{

        
    public N and();    public N endProjectObject();
}
    public interface BuildConfigObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigFluent<TemplateFluent.BuildConfigObjectsNested<N>>{

        
    public N and();    public N endBuildConfigObject();
}
    public interface UserObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserFluent<TemplateFluent.UserObjectsNested<N>>{

        
    public N and();    public N endUserObject();
}
    public interface RouteObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteFluent<TemplateFluent.RouteObjectsNested<N>>{

        
    public N and();    public N endRouteObject();
}
    public interface BuildObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildFluent<TemplateFluent.BuildObjectsNested<N>>{

        
    public N and();    public N endBuildObject();
}
    public interface OAuthAuthorizeTokenObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAuthorizeTokenFluent<TemplateFluent.OAuthAuthorizeTokenObjectsNested<N>>{

        
    public N and();    public N endOAuthAuthorizeTokenObject();
}
    public interface RoleBindingRestrictionObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingRestrictionFluent<TemplateFluent.RoleBindingRestrictionObjectsNested<N>>{

        
    public N and();    public N endRoleBindingRestrictionObject();
}
    public interface ImageStreamTagObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamTagFluent<TemplateFluent.ImageStreamTagObjectsNested<N>>{

        
    public N and();    public N endImageStreamTagObject();
}
    public interface GroupObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupFluent<TemplateFluent.GroupObjectsNested<N>>{

        
    public N and();    public N endGroupObject();
}
    public interface TokenReviewObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TokenReviewFluent<TemplateFluent.TokenReviewObjectsNested<N>>{

        
    public N and();    public N endTokenReviewObject();
}
    public interface ImageSignatureObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<TemplateFluent.ImageSignatureObjectsNested<N>>{

        
    public N and();    public N endImageSignatureObject();
}
    public interface SecurityContextConstraintsObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextConstraintsFluent<TemplateFluent.SecurityContextConstraintsObjectsNested<N>>{

        
    public N and();    public N endSecurityContextConstraintsObject();
}
    public interface ClusterRoleBindingObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<TemplateFluent.ClusterRoleBindingObjectsNested<N>>{

        
    public N and();    public N endClusterRoleBindingObject();
}
    public interface BuildRequestObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildRequestFluent<TemplateFluent.BuildRequestObjectsNested<N>>{

        
    public N and();    public N endBuildRequestObject();
}
    public interface NetNamespaceObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetNamespaceFluent<TemplateFluent.NetNamespaceObjectsNested<N>>{

        
    public N and();    public N endNetNamespaceObject();
}
    public interface ImageStreamObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<TemplateFluent.ImageStreamObjectsNested<N>>{

        
    public N and();    public N endImageStreamObject();
}
    public interface ProjectRequestObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectRequestFluent<TemplateFluent.ProjectRequestObjectsNested<N>>{

        
    public N and();    public N endProjectRequestObject();
}
    public interface TemplateObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TemplateFluent<TemplateFluent.TemplateObjectsNested<N>>{

        
    public N and();    public N endTemplateObject();
}
    public interface OAuthClientAuthorizationObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientAuthorizationFluent<TemplateFluent.OAuthClientAuthorizationObjectsNested<N>>{

        
    public N and();    public N endOAuthClientAuthorizationObject();
}
    public interface OAuthClientObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientFluent<TemplateFluent.OAuthClientObjectsNested<N>>{

        
    public N and();    public N endOAuthClientObject();
}
    public interface IdentityObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IdentityFluent<TemplateFluent.IdentityObjectsNested<N>>{

        
    public N and();    public N endIdentityObject();
}
    public interface ClusterRoleObjectsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleFluent<TemplateFluent.ClusterRoleObjectsNested<N>>{

        
    public N and();    public N endClusterRoleObject();
}
    public interface ParametersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ParameterFluent<TemplateFluent.ParametersNested<N>>{

        
    public N and();    public N endParameter();
}


}
