/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok;

import io.freefair.gradle.plugins.lombok.LombokBasePlugin;
import io.freefair.gradle.plugins.lombok.tasks.Delombok;
import io.freefair.gradle.plugins.lombok.tasks.GenerateLombokConfig;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.FindBugsExtension;
import org.gradle.api.plugins.quality.FindBugsPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;

public class LombokPlugin
implements Plugin<Project> {
    private LombokBasePlugin lombokBasePlugin;
    private Project project;
    private TaskProvider<GenerateLombokConfig> generateLombokConfig;

    public void apply(Project project) {
        this.project = project;
        this.lombokBasePlugin = (LombokBasePlugin)project.getPlugins().apply(LombokBasePlugin.class);
        this.lombokBasePlugin.getLombokExtension().getConfig().put((Object)"config.stopBubbling", (Object)"true");
        this.generateLombokConfig = project.getTasks().register("generateLombokConfig", GenerateLombokConfig.class, genConfig -> {
            genConfig.getProperties().convention(this.lombokBasePlugin.getLombokExtension().getConfig());
            genConfig.setGroup("lombok");
        });
        project.getTasks().withType(Delombok.class).configureEach(this::configureDelombokDefaults);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> this.configureJavaPluginDefaults());
    }

    private void configureJavaPluginDefaults() {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
        javaPluginConvention.getSourceSets().all(sourceSet -> {
            this.project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{this.lombokBasePlugin.getLombokConfiguration()});
            this.project.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName()).extendsFrom(new Configuration[]{this.lombokBasePlugin.getLombokConfiguration()});
            TaskProvider delombokTaskProvider = this.project.getTasks().register(sourceSet.getTaskName("delombok", ""), Delombok.class, delombok -> {
                delombok.setDescription("Runs delombok on the " + sourceSet.getName() + " source-set");
                delombok.getTarget().set(this.project.getLayout().getBuildDirectory().dir("delombok/" + sourceSet.getName()));
            });
            sourceSet.getExtensions().add("delombokTask", (Object)delombokTaskProvider);
            TaskProvider compileTaskProvider = this.project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class, compileJava -> {
                compileJava.dependsOn(new Object[]{this.generateLombokConfig});
                compileJava.getOptions().getCompilerArgs().add("-Xlint:-processing");
                compileJava.getInputs().file(() -> {
                    GenerateLombokConfig generateLombokConfig = (GenerateLombokConfig)((Object)((Object)((Object)((Object)this.generateLombokConfig.get()))));
                    if (generateLombokConfig.isEnabled()) {
                        return generateLombokConfig.getOutputFile();
                    }
                    return null;
                }).withPropertyName("lombok.config").optional();
            });
            this.project.afterEvaluate(p -> delombokTaskProvider.configure(delombok -> {
                delombok.getEncoding().set((Object)((JavaCompile)compileTaskProvider.get()).getOptions().getEncoding());
                delombok.getClasspath().from(new Object[]{sourceSet.getCompileClasspath()});
                delombok.getInput().from(new Object[]{sourceSet.getAllJava().getSourceDirectories()});
            }));
        });
        this.project.getTasks().named("javadoc", Javadoc.class, javadoc -> {
            SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName("main");
            javadoc.setSource(mainSourceSet.getExtensions().getByName("delombokTask"));
        });
        this.project.getPlugins().withType(JacocoPlugin.class, jacocoPlugin -> this.configureForJacoco());
        this.project.getPlugins().withType(FindBugsPlugin.class, findBugsPlugin -> this.configureForFindbugs(javaPluginConvention));
        this.project.getPlugins().withId("com.github.spotbugs", spotBugsPlugin -> this.configureForSpotbugs(javaPluginConvention));
    }

    private void configureForSpotbugs(JavaPluginConvention javaPluginConvention) {
        this.lombokBasePlugin.getLombokExtension().getConfig().put((Object)"lombok.extern.findbugs.addSuppressFBWarnings", (Object)"true");
        CodeQualityExtension spotbugsExtension = (CodeQualityExtension)this.project.getExtensions().getByName("spotbugs");
        javaPluginConvention.getSourceSets().all(sourceSet -> this.project.getDependencies().add(sourceSet.getCompileOnlyConfigurationName(), (Object)("com.github.spotbugs:spotbugs-annotations:" + spotbugsExtension.getToolVersion())));
    }

    @Deprecated
    private void configureForFindbugs(JavaPluginConvention javaPluginConvention) {
        this.lombokBasePlugin.getLombokExtension().getConfig().put((Object)"lombok.extern.findbugs.addSuppressFBWarnings", (Object)"true");
        FindBugsExtension findBugsExtension = (FindBugsExtension)this.project.getExtensions().getByType(FindBugsExtension.class);
        javaPluginConvention.getSourceSets().all(sourceSet -> this.project.getDependencies().add(sourceSet.getCompileOnlyConfigurationName(), (Object)("com.google.code.findbugs:findbugs:" + findBugsExtension.getToolVersion())));
    }

    private void configureForJacoco() {
        this.lombokBasePlugin.getLombokExtension().getConfig().put((Object)"lombok.addLombokGeneratedAnnotation", (Object)"true");
    }

    private void configureDelombokDefaults(Delombok delombok) {
        delombok.setGroup("lombok");
        delombok.getFormat().put("pretty", null);
    }

    @Generated
    public LombokBasePlugin getLombokBasePlugin() {
        return this.lombokBasePlugin;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public TaskProvider<GenerateLombokConfig> getGenerateLombokConfig() {
        return this.generateLombokConfig;
    }
}

