/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks;

import java.io.File;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Map;
import lombok.Generated;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GenerateLombokConfig
extends DefaultTask {
    @OutputFile
    private final RegularFileProperty outputFile = this.getProject().getObjects().fileProperty();
    @Input
    private final MapProperty<String, String> properties = this.getProject().getObjects().mapProperty(String.class, String.class);

    public GenerateLombokConfig() {
        this.outputFile.set(this.getProject().file((Object)"lombok.config"));
        this.onlyIf(t -> this.getProperties().isPresent() && !((Map)this.getProperties().get()).isEmpty());
    }

    @TaskAction
    public void generateLombokConfig() {
        try (PrintWriter writer = ResourceGroovyMethods.newPrintWriter((File)((File)this.outputFile.getAsFile().get()), (String)"ISO-8859-1");){
            writer.println("# This file is generated by the 'io.freefair.lombok' Gradle plugin");
            ((Map)this.properties.get()).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey, String.CASE_INSENSITIVE_ORDER)).forEach(entry -> writer.println((String)entry.getKey() + " = " + (String)entry.getValue()));
        }
    }

    @Generated
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Generated
    public MapProperty<String, String> getProperties() {
        return this.properties;
    }
}

