/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1Event;
import io.kubernetes.client.models.V1EventFluent;
import io.kubernetes.client.models.V1EventSeries;
import io.kubernetes.client.models.V1EventSeriesBuilder;
import io.kubernetes.client.models.V1EventSeriesFluentImpl;
import io.kubernetes.client.models.V1EventSource;
import io.kubernetes.client.models.V1EventSourceBuilder;
import io.kubernetes.client.models.V1EventSourceFluentImpl;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1ObjectReference;
import io.kubernetes.client.models.V1ObjectReferenceBuilder;
import io.kubernetes.client.models.V1ObjectReferenceFluentImpl;
import org.joda.time.DateTime;

public class V1EventFluentImpl<A extends V1EventFluent<A>>
extends BaseFluent<A>
implements V1EventFluent<A> {
    private String action;
    private String apiVersion;
    private Integer count;
    private DateTime eventTime;
    private DateTime firstTimestamp;
    private V1ObjectReferenceBuilder involvedObject;
    private String kind;
    private DateTime lastTimestamp;
    private String message;
    private V1ObjectMetaBuilder metadata;
    private String reason;
    private V1ObjectReferenceBuilder related;
    private String reportingComponent;
    private String reportingInstance;
    private V1EventSeriesBuilder series;
    private V1EventSourceBuilder source;
    private String type;

    public V1EventFluentImpl() {
    }

    public V1EventFluentImpl(V1Event instance) {
        this.withAction(instance.getAction());
        this.withApiVersion(instance.getApiVersion());
        this.withCount(instance.getCount());
        this.withEventTime(instance.getEventTime());
        this.withFirstTimestamp(instance.getFirstTimestamp());
        this.withInvolvedObject(instance.getInvolvedObject());
        this.withKind(instance.getKind());
        this.withLastTimestamp(instance.getLastTimestamp());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withRelated(instance.getRelated());
        this.withReportingComponent(instance.getReportingComponent());
        this.withReportingInstance(instance.getReportingInstance());
        this.withSeries(instance.getSeries());
        this.withSource(instance.getSource());
        this.withType(instance.getType());
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    @Override
    public Boolean hasAction() {
        return this.action != null;
    }

    @Override
    public A withNewAction(String arg1) {
        return this.withAction(new String(arg1));
    }

    @Override
    public A withNewAction(StringBuilder arg1) {
        return this.withAction(new String(arg1));
    }

    @Override
    public A withNewAction(StringBuffer arg1) {
        return this.withAction(new String(arg1));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    @Override
    public Boolean hasCount() {
        return this.count != null;
    }

    @Override
    public DateTime getEventTime() {
        return this.eventTime;
    }

    @Override
    public A withEventTime(DateTime eventTime) {
        this.eventTime = eventTime;
        return (A)this;
    }

    @Override
    public Boolean hasEventTime() {
        return this.eventTime != null;
    }

    @Override
    public A withNewEventTime(int arg0, int arg1, int arg2, int arg3, int arg4) {
        return this.withEventTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewEventTime(Object arg0) {
        return this.withEventTime(new DateTime(arg0));
    }

    @Override
    public A withNewEventTime(long arg0) {
        return this.withEventTime(new DateTime(arg0));
    }

    @Override
    public DateTime getFirstTimestamp() {
        return this.firstTimestamp;
    }

    @Override
    public A withFirstTimestamp(DateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasFirstTimestamp() {
        return this.firstTimestamp != null;
    }

    @Override
    public A withNewFirstTimestamp(int arg0, int arg1, int arg2, int arg3, int arg4) {
        return this.withFirstTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewFirstTimestamp(Object arg0) {
        return this.withFirstTimestamp(new DateTime(arg0));
    }

    @Override
    public A withNewFirstTimestamp(long arg0) {
        return this.withFirstTimestamp(new DateTime(arg0));
    }

    @Override
    @Deprecated
    public V1ObjectReference getInvolvedObject() {
        return this.involvedObject != null ? this.involvedObject.build() : null;
    }

    @Override
    public V1ObjectReference buildInvolvedObject() {
        return this.involvedObject != null ? this.involvedObject.build() : null;
    }

    @Override
    public A withInvolvedObject(V1ObjectReference involvedObject) {
        this._visitables.get("involvedObject").remove(this.involvedObject);
        if (involvedObject != null) {
            this.involvedObject = new V1ObjectReferenceBuilder(involvedObject);
            this._visitables.get("involvedObject").add(this.involvedObject);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInvolvedObject() {
        return this.involvedObject != null;
    }

    @Override
    public V1EventFluent.InvolvedObjectNested<A> withNewInvolvedObject() {
        return new InvolvedObjectNestedImpl();
    }

    @Override
    public V1EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(V1ObjectReference item) {
        return new InvolvedObjectNestedImpl(item);
    }

    @Override
    public V1EventFluent.InvolvedObjectNested<A> editInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject());
    }

    @Override
    public V1EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject() != null ? this.getInvolvedObject() : new V1ObjectReferenceBuilder().build());
    }

    @Override
    public V1EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(V1ObjectReference item) {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject() != null ? this.getInvolvedObject() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public DateTime getLastTimestamp() {
        return this.lastTimestamp;
    }

    @Override
    public A withLastTimestamp(DateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasLastTimestamp() {
        return this.lastTimestamp != null;
    }

    @Override
    public A withNewLastTimestamp(int arg0, int arg1, int arg2, int arg3, int arg4) {
        return this.withLastTimestamp(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewLastTimestamp(Object arg0) {
        return this.withLastTimestamp(new DateTime(arg0));
    }

    @Override
    public A withNewLastTimestamp(long arg0) {
        return this.withLastTimestamp(new DateTime(arg0));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public A withNewMessage(String arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuilder arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuffer arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1EventFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1EventFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1EventFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1EventFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1EventFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public A withNewReason(String arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuilder arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuffer arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectReference getRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public V1ObjectReference buildRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public A withRelated(V1ObjectReference related) {
        this._visitables.get("related").remove(this.related);
        if (related != null) {
            this.related = new V1ObjectReferenceBuilder(related);
            this._visitables.get("related").add(this.related);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelated() {
        return this.related != null;
    }

    @Override
    public V1EventFluent.RelatedNested<A> withNewRelated() {
        return new RelatedNestedImpl();
    }

    @Override
    public V1EventFluent.RelatedNested<A> withNewRelatedLike(V1ObjectReference item) {
        return new RelatedNestedImpl(item);
    }

    @Override
    public V1EventFluent.RelatedNested<A> editRelated() {
        return this.withNewRelatedLike(this.getRelated());
    }

    @Override
    public V1EventFluent.RelatedNested<A> editOrNewRelated() {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : new V1ObjectReferenceBuilder().build());
    }

    @Override
    public V1EventFluent.RelatedNested<A> editOrNewRelatedLike(V1ObjectReference item) {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : item);
    }

    @Override
    public String getReportingComponent() {
        return this.reportingComponent;
    }

    @Override
    public A withReportingComponent(String reportingComponent) {
        this.reportingComponent = reportingComponent;
        return (A)this;
    }

    @Override
    public Boolean hasReportingComponent() {
        return this.reportingComponent != null;
    }

    @Override
    public A withNewReportingComponent(String arg1) {
        return this.withReportingComponent(new String(arg1));
    }

    @Override
    public A withNewReportingComponent(StringBuilder arg1) {
        return this.withReportingComponent(new String(arg1));
    }

    @Override
    public A withNewReportingComponent(StringBuffer arg1) {
        return this.withReportingComponent(new String(arg1));
    }

    @Override
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    @Override
    public A withReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return (A)this;
    }

    @Override
    public Boolean hasReportingInstance() {
        return this.reportingInstance != null;
    }

    @Override
    public A withNewReportingInstance(String arg1) {
        return this.withReportingInstance(new String(arg1));
    }

    @Override
    public A withNewReportingInstance(StringBuilder arg1) {
        return this.withReportingInstance(new String(arg1));
    }

    @Override
    public A withNewReportingInstance(StringBuffer arg1) {
        return this.withReportingInstance(new String(arg1));
    }

    @Override
    @Deprecated
    public V1EventSeries getSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public V1EventSeries buildSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public A withSeries(V1EventSeries series) {
        this._visitables.get("series").remove(this.series);
        if (series != null) {
            this.series = new V1EventSeriesBuilder(series);
            this._visitables.get("series").add(this.series);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeries() {
        return this.series != null;
    }

    @Override
    public V1EventFluent.SeriesNested<A> withNewSeries() {
        return new SeriesNestedImpl();
    }

    @Override
    public V1EventFluent.SeriesNested<A> withNewSeriesLike(V1EventSeries item) {
        return new SeriesNestedImpl(item);
    }

    @Override
    public V1EventFluent.SeriesNested<A> editSeries() {
        return this.withNewSeriesLike(this.getSeries());
    }

    @Override
    public V1EventFluent.SeriesNested<A> editOrNewSeries() {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : new V1EventSeriesBuilder().build());
    }

    @Override
    public V1EventFluent.SeriesNested<A> editOrNewSeriesLike(V1EventSeries item) {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : item);
    }

    @Override
    @Deprecated
    public V1EventSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public V1EventSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(V1EventSource source) {
        this._visitables.get("source").remove(this.source);
        if (source != null) {
            this.source = new V1EventSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public V1EventFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public V1EventFluent.SourceNested<A> withNewSourceLike(V1EventSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public V1EventFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public V1EventFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new V1EventSourceBuilder().build());
    }

    @Override
    public V1EventFluent.SourceNested<A> editOrNewSourceLike(V1EventSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public A withNewType(String arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuilder arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuffer arg1) {
        return this.withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1EventFluentImpl that = (V1EventFluentImpl)o;
        if (this.action != null ? !this.action.equals(that.action) : that.action != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.eventTime != null ? !this.eventTime.equals((Object)that.eventTime) : that.eventTime != null) {
            return false;
        }
        if (this.firstTimestamp != null ? !this.firstTimestamp.equals((Object)that.firstTimestamp) : that.firstTimestamp != null) {
            return false;
        }
        if (this.involvedObject != null ? !this.involvedObject.equals(that.involvedObject) : that.involvedObject != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastTimestamp != null ? !this.lastTimestamp.equals((Object)that.lastTimestamp) : that.lastTimestamp != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.related != null ? !this.related.equals(that.related) : that.related != null) {
            return false;
        }
        if (this.reportingComponent != null ? !this.reportingComponent.equals(that.reportingComponent) : that.reportingComponent != null) {
            return false;
        }
        if (this.reportingInstance != null ? !this.reportingInstance.equals(that.reportingInstance) : that.reportingInstance != null) {
            return false;
        }
        if (this.series != null ? !this.series.equals(that.series) : that.series != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class SourceNestedImpl<N>
    extends V1EventSourceFluentImpl<V1EventFluent.SourceNested<N>>
    implements V1EventFluent.SourceNested<N>,
    Nested<N> {
        private final V1EventSourceBuilder builder;

        SourceNestedImpl(V1EventSource item) {
            this.builder = new V1EventSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new V1EventSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EventFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class SeriesNestedImpl<N>
    extends V1EventSeriesFluentImpl<V1EventFluent.SeriesNested<N>>
    implements V1EventFluent.SeriesNested<N>,
    Nested<N> {
        private final V1EventSeriesBuilder builder;

        SeriesNestedImpl(V1EventSeries item) {
            this.builder = new V1EventSeriesBuilder(this, item);
        }

        SeriesNestedImpl() {
            this.builder = new V1EventSeriesBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EventFluentImpl.this.withSeries(this.builder.build());
        }

        @Override
        public N endSeries() {
            return this.and();
        }
    }

    public class RelatedNestedImpl<N>
    extends V1ObjectReferenceFluentImpl<V1EventFluent.RelatedNested<N>>
    implements V1EventFluent.RelatedNested<N>,
    Nested<N> {
        private final V1ObjectReferenceBuilder builder;

        RelatedNestedImpl(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        RelatedNestedImpl() {
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EventFluentImpl.this.withRelated(this.builder.build());
        }

        @Override
        public N endRelated() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1EventFluent.MetadataNested<N>>
    implements V1EventFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EventFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class InvolvedObjectNestedImpl<N>
    extends V1ObjectReferenceFluentImpl<V1EventFluent.InvolvedObjectNested<N>>
    implements V1EventFluent.InvolvedObjectNested<N>,
    Nested<N> {
        private final V1ObjectReferenceBuilder builder;

        InvolvedObjectNestedImpl(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        InvolvedObjectNestedImpl() {
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EventFluentImpl.this.withInvolvedObject(this.builder.build());
        }

        @Override
        public N endInvolvedObject() {
            return this.and();
        }
    }
}

