/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.informer.cache.ProcessorListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;

public class SharedProcessor<ApiType> {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<ProcessorListener<ApiType>> listeners = new ArrayList<ProcessorListener<ApiType>>();
    private List<ProcessorListener<ApiType>> syncingListeners = new ArrayList<ProcessorListener<ApiType>>();
    private ExecutorService executorService;

    public SharedProcessor() {
        this(Executors.newCachedThreadPool());
    }

    public SharedProcessor(ExecutorService threadPool) {
        this.executorService = threadPool;
    }

    public void addAndStartListener(ProcessorListener<ApiType> processorListener) {
        this.lock.writeLock().lock();
        try {
            this.addListenerLocked(processorListener);
            this.executorService.execute(processorListener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addListener(ProcessorListener<ApiType> processorListener) {
        this.lock.writeLock().lock();
        try {
            this.addListenerLocked(processorListener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void addListenerLocked(ProcessorListener<ApiType> processorListener) {
        this.listeners.add(processorListener);
        this.syncingListeners.add(processorListener);
    }

    public void run() {
        this.lock.readLock().lock();
        try {
            if (CollectionUtils.isEmpty(this.listeners)) {
                return;
            }
            for (ProcessorListener<ApiType> listener : this.listeners) {
                this.executorService.execute(listener);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distribute(ProcessorListener.Notification<ApiType> obj, boolean isSync) {
        this.lock.readLock().lock();
        try {
            if (isSync) {
                for (ProcessorListener<ApiType> listener : this.syncingListeners) {
                    listener.add(obj);
                }
            } else {
                for (ProcessorListener<ApiType> listener : this.listeners) {
                    listener.add(obj);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldResync() {
        this.lock.writeLock().lock();
        boolean resyncNeeded = false;
        try {
            this.syncingListeners = new ArrayList<ProcessorListener<ApiType>>();
            DateTime now = DateTime.now();
            for (ProcessorListener<ApiType> listener : this.listeners) {
                if (!listener.shouldResync(now)) continue;
                resyncNeeded = true;
                this.syncingListeners.add(listener);
                listener.determineNextResync(now);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return resyncNeeded;
    }

    public void stop() {
        this.lock.writeLock().lock();
        try {
            this.listeners = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.executorService.shutdownNow();
    }
}

