/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.internal.Nullable;
import brave.messaging.ConsumerRequest;
import brave.propagation.Propagation;
import brave.spring.rabbit.SpringRabbitPropagation;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

final class MessageConsumerRequest
extends ConsumerRequest {
    static final Propagation.Getter<MessageConsumerRequest, String> GETTER = new Propagation.Getter<MessageConsumerRequest, String>(){

        public String get(MessageConsumerRequest request, String name) {
            return request.getHeader(name);
        }

        public String toString() {
            return "MessageConsumerRequest::getHeader";
        }
    };
    static final Propagation.Setter<MessageConsumerRequest, String> SETTER = new Propagation.Setter<MessageConsumerRequest, String>(){

        public void put(MessageConsumerRequest request, String name, String value) {
            request.setHeader(name, value);
        }

        public String toString() {
            return "MessageConsumerRequest::setHeader";
        }
    };
    final Message delegate;

    MessageConsumerRequest(Message delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public Span.Kind spanKind() {
        return Span.Kind.CONSUMER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "receive";
    }

    public String channelKind() {
        return "queue";
    }

    public String channelName() {
        MessageProperties properties = this.delegate.getMessageProperties();
        return properties != null ? properties.getConsumerQueue() : null;
    }

    @Nullable
    String getHeader(String name) {
        MessageProperties properties = this.delegate.getMessageProperties();
        return properties != null ? SpringRabbitPropagation.GETTER.get((Object)properties, (Object)name) : null;
    }

    void setHeader(String name, String value) {
        MessageProperties properties = this.delegate.getMessageProperties();
        if (properties == null) {
            return;
        }
        SpringRabbitPropagation.SETTER.put((Object)properties, (Object)name, value);
    }
}

