/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.buildscans;

import com.gradle.scan.plugin.BuildScanExtension;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.champeau.gradle.buildscans.Recipe;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.invocation.Gradle;

public class RecipeCompiler
extends CompilationCustomizer {
    private static final byte VERSION = 1;
    private static final ClassNode BUILDSCAN_TYPE = ClassHelper.make(BuildScanExtension.class);
    private static final ClassNode GRADLE_TYPE = ClassHelper.make(Gradle.class);
    private static final ClassNode MAP_TYPE = ClassHelper.make(Map.class);

    public RecipeCompiler() {
        super(CompilePhase.CONVERSION);
    }

    public void call(SourceUnit sourceUnit, GeneratorContext generatorContext, ClassNode classNode) throws CompilationFailedException {
        if (classNode.isScript()) {
            classNode.setName(RecipeCompiler.recipeClassName(classNode.getName()));
            classNode.addInterface(ClassHelper.make(Recipe.class));
            classNode.setSuperClass(ClassHelper.OBJECT_TYPE);
            MethodNode run = (MethodNode)classNode.getMethods("run").get(0);
            classNode.getMethods().remove(run);
            ClassNode mapType = MAP_TYPE.getPlainNodeReference();
            mapType.setGenericsTypes(new GenericsType[]{new GenericsType(ClassHelper.STRING_TYPE), new GenericsType(ClassHelper.STRING_TYPE)});
            MethodNode apply = new MethodNode("apply", 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(GRADLE_TYPE, "gradle"), new Parameter(BUILDSCAN_TYPE, "buildScan"), new Parameter(mapType, "params")}, ClassNode.EMPTY_ARRAY, run.getCode());
            classNode.addMethod(apply);
        }
    }

    public static String recipeClassName(String recipe) {
        return "me.champeau.gradle.buildscans.GeneratedRecipe_" + recipe.replaceAll("[^a-zA-Z0-9]", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<? extends Recipe> compileOrGetFromCache(Gradle gradle, String recipeName, URL url, boolean cache) throws NoSuchAlgorithmException, URISyntaxException, IOException, ClassNotFoundException {
        File recipeDir = RecipeCompiler.recipeDir(gradle, url);
        if (!cache && recipeDir.exists()) {
            ResourceGroovyMethods.deleteDir((File)recipeDir);
        }
        if (!cache || recipeDir.mkdir()) {
            long sd = System.nanoTime();
            try {
                Class<? extends Recipe> clazz = RecipeCompiler.compileToDir(recipeName, url, recipeDir, cache);
                return clazz;
            }
            finally {
                gradle.getRootProject().getLogger().debug("Compilation took " + TimeUnit.MILLISECONDS.convert(System.nanoTime() - sd, TimeUnit.NANOSECONDS) + "ms");
            }
        }
        return RecipeCompiler.loadFromDir(recipeName, recipeDir);
    }

    private static Class<? extends Recipe> loadFromDir(String recipeName, File recipeDir) throws MalformedURLException, ClassNotFoundException {
        URLClassLoader ucl = new URLClassLoader(new URL[]{recipeDir.toURI().toURL()}, RecipeCompiler.class.getClassLoader());
        return ucl.loadClass(RecipeCompiler.recipeClassName(recipeName));
    }

    private static Class<? extends Recipe> compileToDir(String recipeName, URL url, File recipeDir, boolean cache) throws IOException {
        System.out.println("Compiling recipe " + recipeName + "...");
        CompilerConfiguration config = new CompilerConfiguration();
        if (cache) {
            config.setTargetDirectory(recipeDir);
        }
        config.addCompilationCustomizers(new CompilationCustomizer[]{new RecipeCompiler()});
        GroovyClassLoader gcl = new GroovyClassLoader(RecipeCompiler.class.getClassLoader(), config);
        return gcl.parseClass(ResourceGroovyMethods.getText((URL)url, (String)"UTF-8"), recipeName + ".groovy");
    }

    private static File recipeDir(Gradle gradle, URL url) throws NoSuchAlgorithmException, UnsupportedEncodingException, URISyntaxException {
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        digest.update(url.toURI().toString().getBytes("utf-8"));
        digest.update((byte)1);
        File gradleUserHomeDir = gradle.getGradleUserHomeDir();
        File recipesHomeDir = new File(gradleUserHomeDir, "buildScanRecipes");
        if (!recipesHomeDir.exists()) {
            recipesHomeDir.mkdirs();
        }
        String hex = new BigInteger(1, digest.digest()).toString(16);
        return new File(recipesHomeDir, hex);
    }
}

