/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.error;

import com.google.common.html.HtmlEscapers;
import net.lightbody.bmp.l10n.MessagesUtil;
import net.lightbody.bmp.proxy.error.ErrorUtil;

public enum ProxyError {
    CONN_FAILURE("response.conn_failure.title", "response.conn_failure.short", "response.common_error.long"),
    DNS_NOT_FOUND("response.dns_not_found.title", "response.dns_not_found.short", "response.dns_not_found.long"),
    GENERIC("response.generic.title", "response.generic.short", "response.generic.long"),
    MALFORMED_URI("response.malformed_uri.title", "response.malformed_uri.short", "response.malformed_uri.long"),
    NET_INTERRUPT("response.net_interrupt.title", "response.net_interrupt.short", "response.common_error.long"),
    NET_RESET("response.net_reset.title", "response.net_reset.short", "response.common_error.long"),
    NET_TIMEOUT("response.net_timeout.title", "response.net_timeout.short", "response.common_error.long");

    private final String errorTitle;
    private final String shortDesc;
    private final String longDesc;

    private ProxyError(String titleMessageKey, String shortDescMessageKey, String longDescMessageKey) {
        this.errorTitle = MessagesUtil.getMessage(titleMessageKey, new Object[0]);
        this.shortDesc = MessagesUtil.getMessage(shortDescMessageKey, new Object[0]);
        this.longDesc = MessagesUtil.getMessage(longDescMessageKey, new Object[0]);
    }

    public String getHtml(String url) {
        String formattedShortDesc = String.format(this.shortDesc, HtmlEscapers.htmlEscaper().escape(url));
        String pageTitle = MessagesUtil.getMessage("response.common_error.pagetitle", new Object[0]);
        String errorHtml = ErrorUtil.getErrorHtml();
        return String.format(errorHtml, pageTitle, this.errorTitle, formattedShortDesc, this.longDesc);
    }
}

