/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarTimings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInfo {
    private static final Logger LOG = LoggerFactory.getLogger(RequestInfo.class);
    private static ThreadLocal<RequestInfo> instance = new ThreadLocal<RequestInfo>(){

        @Override
        protected RequestInfo initialValue() {
            return new RequestInfo();
        }
    };
    private long blockedNanos;
    private long dnsNanos;
    private long latencyNanos;
    private long connectNanos;
    private volatile long sslNanos;
    private long sendNanos;
    private long waitNanos;
    private long receiveNanos;
    private String resolvedAddress;
    private Date startDate;
    private long startNanos;
    private long endNanos;
    private String url;
    private HarEntry entry;

    public static RequestInfo get() {
        return instance.get();
    }

    public static void clear(String url, HarEntry entry) {
        RequestInfo.clear();
        RequestInfo info = RequestInfo.get();
        info.url = url;
        info.entry = entry;
    }

    private static void clear() {
        RequestInfo info = RequestInfo.get();
        info.blockedNanos = -1L;
        info.dnsNanos = -1L;
        info.connectNanos = -1L;
        info.sslNanos = -1L;
        info.sendNanos = 0L;
        info.waitNanos = 0L;
        info.receiveNanos = 0L;
        info.resolvedAddress = null;
        info.startDate = null;
        info.startNanos = 0L;
        info.endNanos = 0L;
    }

    private long ping(long start, long end) {
        if (this.startDate == null || this.startNanos == 0L) {
            LOG.error("Request start time was not set correctly; using current time");
            if (this.startDate == null) {
                this.startDate = new Date();
            }
            if (this.startNanos == 0L) {
                this.startNanos = System.nanoTime();
            }
        }
        return end - start;
    }

    public Long getBlocked() {
        return null;
    }

    public long getDns() {
        return this.dnsNanos;
    }

    public long getConnect() {
        return this.connectNanos;
    }

    public long getSsl() {
        return this.sslNanos;
    }

    public long getSend() {
        return this.sendNanos;
    }

    public long getWait() {
        return this.waitNanos;
    }

    public long getReceive() {
        return this.receiveNanos;
    }

    public String getResolvedAddress() {
        return this.resolvedAddress;
    }

    public void blocked(long start, long end) {
        this.blockedNanos = end - start;
    }

    public void dns(long start, long end, String resolvedAddress) {
        this.dnsNanos = this.ping(start, end);
        this.resolvedAddress = resolvedAddress;
    }

    public void connect(long start, long end) {
        this.connectNanos = this.ping(start, end);
    }

    public void latency(long start, long end) {
        this.latencyNanos = this.ping(start, end);
    }

    public void ssl(long start, long end) {
        this.sslNanos = this.ping(start, end);
    }

    public void send(long start, long end) {
        this.sendNanos = this.ping(start, end);
    }

    public void wait(long start, long end) {
        this.waitNanos = this.ping(start, end);
    }

    public void start() {
        this.startNanos = System.nanoTime();
        this.startDate = new Date();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void finish() {
        if (this.startDate == null) {
            this.startDate = new Date();
        }
        if (this.startNanos == 0L) {
            this.startNanos = System.nanoTime();
        }
        this.endNanos = System.nanoTime();
        this.receiveNanos = this.endNanos - this.startNanos - this.norm(this.waitNanos) - this.norm(this.sendNanos) - this.norm(this.sslNanos) - this.norm(this.connectNanos) - this.norm(this.dnsNanos);
        if (this.norm(this.sslNanos) > 0L) {
            this.connectNanos += this.sslNanos;
        }
        if (this.receiveNanos < 0L) {
            LOG.error("Got a negative receiving time ({}) for URL {}", (Object)this.receiveNanos, (Object)this.url);
            this.receiveNanos = 0L;
        }
    }

    private long norm(Long val) {
        if (val == null || val == -1L) {
            return 0L;
        }
        return val;
    }

    public long getTotalTime(TimeUnit timeUnit) {
        if (this.endNanos == 0L || this.startNanos == 0L) {
            return -1L;
        }
        return timeUnit.convert(this.endNanos - this.startNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        long totalTimeNanos = this.getTotalTime(TimeUnit.NANOSECONDS);
        return "RequestInfo{blocked=" + this.blockedNanos + "ns" + ", dns=" + this.dnsNanos + "ns" + ", connect=" + this.connectNanos + "ns" + ", ssl=" + this.sslNanos + "ns" + ", send=" + this.sendNanos + "ns" + ", wait=" + this.waitNanos + "ns" + ", receive=" + this.receiveNanos + "ns" + ", total=" + totalTimeNanos + "ns" + ", resolvedAddress='" + this.resolvedAddress + '\'' + '}';
    }

    public HarTimings getTimings() {
        HarTimings harTimings = new HarTimings();
        harTimings.setBlocked(this.blockedNanos, TimeUnit.NANOSECONDS);
        harTimings.setDns(this.dnsNanos, TimeUnit.NANOSECONDS);
        harTimings.setConnect(this.connectNanos, TimeUnit.NANOSECONDS);
        harTimings.setSend(this.sendNanos, TimeUnit.NANOSECONDS);
        harTimings.setWait(this.waitNanos, TimeUnit.NANOSECONDS);
        harTimings.setReceive(this.receiveNanos, TimeUnit.NANOSECONDS);
        harTimings.setSsl(this.sslNanos, TimeUnit.NANOSECONDS);
        return harTimings;
    }

    public HarEntry getEntry() {
        return this.entry;
    }

    public long getLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.latencyNanos, TimeUnit.NANOSECONDS);
    }
}

