/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.lightbody.bmp.proxy.jetty.http.Authenticator;
import net.lightbody.bmp.proxy.jetty.http.ContextLoader;
import net.lightbody.bmp.proxy.jetty.http.HttpConnection;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpHandler;
import net.lightbody.bmp.proxy.jetty.http.HttpListener;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.HttpServer;
import net.lightbody.bmp.proxy.jetty.http.PathMap;
import net.lightbody.bmp.proxy.jetty.http.RequestLog;
import net.lightbody.bmp.proxy.jetty.http.ResourceCache;
import net.lightbody.bmp.proxy.jetty.http.SecurityConstraint;
import net.lightbody.bmp.proxy.jetty.http.UserRealm;
import net.lightbody.bmp.proxy.jetty.http.handler.ErrorPageHandler;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.Container;
import net.lightbody.bmp.proxy.jetty.util.EventProvider;
import net.lightbody.bmp.proxy.jetty.util.IO;
import net.lightbody.bmp.proxy.jetty.util.LazyList;
import net.lightbody.bmp.proxy.jetty.util.LifeCycle;
import net.lightbody.bmp.proxy.jetty.util.LogSupport;
import net.lightbody.bmp.proxy.jetty.util.MultiException;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import net.lightbody.bmp.proxy.jetty.util.URI;
import org.apache.commons.logging.Log;

public class HttpContext
extends Container
implements LifeCycle,
HttpHandler,
EventProvider,
Serializable {
    private static Log log = LogFactory.getLog(HttpContext.class);
    public static final String __fileClassPathAttr = "HttpContext.FileClassPathAttribute";
    public static final String __ErrorHandler = "net.lightbody.bmp.proxy.jetty.http.ErrorHandler";
    private String _contextPath;
    private List _vhosts = new ArrayList(2);
    private List _hosts = new ArrayList(2);
    private List _handlers = new ArrayList(3);
    private Map _attributes = new HashMap(3);
    private boolean _redirectNullPath = true;
    private boolean _statsOn = false;
    private PermissionCollection _permissions;
    private boolean _classLoaderJava2Compliant = true;
    private ResourceCache _resources;
    private String[] _systemClasses = new String[]{"java.", "javax.servlet.", "javax.xml.", "net.lightbody.bmp.proxy.jetty.", "org.xml.", "org.w3c.", "org.apache.commons.logging."};
    private String[] _serverClasses = new String[]{"-PathMap", "-net.lightbody.bmp.proxy.jetty.jetty.servlet.Invoker", "-net.lightbody.bmp.proxy.jetty.jetty.servlet.JSR154Filter", "-net.lightbody.bmp.proxy.jetty.jetty.servlet.Default", "net.lightbody.bmp.proxy.jetty.jetty.Server", "net.lightbody.bmp.proxy.jetty.http.", "net.lightbody.bmp.proxy.jetty.start.", "net.lightbody.bmp.proxy.jetty.stop."};
    private String _contextName;
    private String _classPath;
    private Map _initParams = new HashMap(11);
    private UserRealm _userRealm;
    private String _realmName;
    private PathMap _constraintMap = new PathMap();
    private Authenticator _authenticator;
    private RequestLog _requestLog;
    private String[] _welcomes = new String[]{"welcome.html", "index.html", "index.htm", "index.jsp"};
    private transient boolean _gracefulStop;
    private transient ClassLoader _parent;
    private transient ClassLoader _loader;
    private transient HttpServer _httpServer;
    private transient File _tmpDir;
    private transient HttpHandler[] _handlersArray;
    private transient String[] _vhostsArray;
    transient Object _statsLock = new Object[0];
    transient long _statsStartedAt;
    transient int _requests;
    transient int _requestsActive;
    transient int _requestsActiveMax;
    transient int _responses1xx;
    transient int _responses2xx;
    transient int _responses3xx;
    transient int _responses4xx;
    transient int _responses5xx;

    public HttpContext() {
        this.setAttribute(__ErrorHandler, new ErrorPageHandler());
        this._resources = new ResourceCache();
        this.addComponent(this._resources);
    }

    public HttpContext(HttpServer httpServer, String contextPathSpec) {
        this();
        this.setHttpServer(httpServer);
        this.setContextPath(contextPathSpec);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._statsLock = new Object[0];
        this.getHandlers();
        int i = 0;
        while (i < this._handlersArray.length) {
            this._handlersArray[i].initialize(this);
            ++i;
        }
    }

    public HttpConnection getHttpConnection() {
        return HttpConnection.getHttpConnection();
    }

    void setHttpServer(HttpServer httpServer) {
        this._httpServer = httpServer;
        this._contextName = null;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public void setStopGracefully(boolean graceful) {
        this._gracefulStop = graceful;
    }

    public boolean getStopGracefully() {
        return this._gracefulStop;
    }

    public static String canonicalContextPathSpec(String contextPathSpec) {
        if (contextPathSpec == null || contextPathSpec.indexOf(44) >= 0 || contextPathSpec.startsWith("*")) {
            throw new IllegalArgumentException("Illegal context spec:" + contextPathSpec);
        }
        if (!contextPathSpec.startsWith("/")) {
            contextPathSpec = String.valueOf('/') + contextPathSpec;
        }
        if (contextPathSpec.length() > 1) {
            if (contextPathSpec.endsWith("/")) {
                contextPathSpec = String.valueOf(contextPathSpec) + "*";
            } else if (!contextPathSpec.endsWith("/*")) {
                contextPathSpec = String.valueOf(contextPathSpec) + "/*";
            }
        }
        return contextPathSpec;
    }

    public void setContextPath(String contextPathSpec) {
        if (this._httpServer != null) {
            this._httpServer.removeMappings(this);
        }
        this._contextPath = (contextPathSpec = HttpContext.canonicalContextPathSpec(contextPathSpec)).length() > 1 ? contextPathSpec.substring(0, contextPathSpec.length() - 2) : "/";
        this._contextName = null;
        if (this._httpServer != null) {
            this._httpServer.addMappings(this);
        }
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public void addVirtualHost(String hostname) {
        if (!this._vhosts.contains(hostname)) {
            this._vhosts.add(hostname);
            this._contextName = null;
            if (this._httpServer != null) {
                if (this._vhosts.size() == 1) {
                    this._httpServer.removeMapping(null, this);
                }
                this._httpServer.addMapping(hostname, this);
            }
            this._vhostsArray = null;
        }
    }

    public void removeVirtualHost(String hostname) {
        if (this._vhosts.remove(hostname)) {
            this._contextName = null;
            if (this._httpServer != null) {
                this._httpServer.removeMapping(hostname, this);
                if (this._vhosts.size() == 0) {
                    this._httpServer.addMapping(null, this);
                }
            }
            this._vhostsArray = null;
        }
    }

    public void setVirtualHosts(String[] hosts) {
        int i;
        ArrayList old = new ArrayList(this._vhosts);
        if (hosts != null) {
            i = 0;
            while (i < hosts.length) {
                boolean existing = old.remove(hosts[i]);
                if (!existing) {
                    this.addVirtualHost(hosts[i]);
                }
                ++i;
            }
        }
        i = 0;
        while (i < old.size()) {
            this.removeVirtualHost((String)old.get(i));
            ++i;
        }
    }

    public String[] getVirtualHosts() {
        if (this._vhostsArray != null) {
            return this._vhostsArray;
        }
        if (this._vhosts == null) {
            this._vhostsArray = new String[0];
        } else {
            this._vhostsArray = new String[this._vhosts.size()];
            this._vhostsArray = this._vhosts.toArray(this._vhostsArray);
        }
        return this._vhostsArray;
    }

    public void setHosts(String[] hosts) throws UnknownHostException {
        if (hosts == null || hosts.length == 0) {
            this._hosts = null;
        } else {
            this._hosts = new ArrayList();
            int i = 0;
            while (i < hosts.length) {
                if (hosts[i] != null) {
                    this._hosts.add(InetAddress.getByName(hosts[i]));
                }
                ++i;
            }
        }
    }

    public String[] getHosts() {
        if (this._hosts == null || this._hosts.size() == 0) {
            return null;
        }
        String[] hosts = new String[this._hosts.size()];
        int i = 0;
        while (i < hosts.length) {
            InetAddress a = (InetAddress)this._hosts.get(i);
            if (a != null) {
                hosts[i] = a.getHostName();
            }
            ++i;
        }
        return hosts;
    }

    public void setSystemClasses(String[] classes) {
        this._systemClasses = classes;
    }

    public String[] getSystemClasses() {
        return this._systemClasses;
    }

    public void setServerClasses(String[] classes) {
        this._serverClasses = classes;
    }

    public String[] getServerClasses() {
        return this._serverClasses;
    }

    public void setHandlers(HttpHandler[] handlers) {
        int i;
        ArrayList old = new ArrayList(this._handlers);
        if (handlers != null) {
            i = 0;
            while (i < handlers.length) {
                boolean existing = old.remove(handlers[i]);
                if (!existing) {
                    this.addHandler(handlers[i]);
                }
                ++i;
            }
        }
        i = 0;
        while (i < old.size()) {
            this.removeHandler((HttpHandler)old.get(i));
            ++i;
        }
    }

    public HttpHandler[] getHandlers() {
        if (this._handlersArray != null) {
            return this._handlersArray;
        }
        if (this._handlers == null) {
            this._handlersArray = new HttpHandler[0];
        } else {
            this._handlersArray = new HttpHandler[this._handlers.size()];
            this._handlersArray = this._handlers.toArray(this._handlersArray);
        }
        return this._handlersArray;
    }

    public synchronized void addHandler(int i, HttpHandler handler) {
        this._handlers.add(i, handler);
        this._handlersArray = null;
        HttpContext context = handler.getHttpContext();
        if (context == null) {
            handler.initialize(this);
        } else if (context != this) {
            throw new IllegalArgumentException("Handler in another HttpContext");
        }
        this.addComponent(handler);
    }

    public synchronized void addHandler(HttpHandler handler) {
        this.addHandler(this._handlers.size(), handler);
    }

    public int getHandlerIndex(HttpHandler handler) {
        int h = 0;
        while (h < this._handlers.size()) {
            if (handler == this._handlers.get(h)) {
                return h;
            }
            ++h;
        }
        return -1;
    }

    public synchronized HttpHandler getHandler(Class handlerClass) {
        int h = 0;
        while (h < this._handlers.size()) {
            HttpHandler handler = (HttpHandler)this._handlers.get(h);
            if (handlerClass.isInstance(handler)) {
                return handler;
            }
            ++h;
        }
        return null;
    }

    public synchronized HttpHandler removeHandler(int i) {
        HttpHandler handler = this._handlersArray[i];
        if (handler.isStarted()) {
            try {
                handler.stop();
            }
            catch (InterruptedException e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
        this._handlers.remove(i);
        this._handlersArray = null;
        this.removeComponent(handler);
        return handler;
    }

    public synchronized void removeHandler(HttpHandler handler) {
        if (handler.isStarted()) {
            try {
                handler.stop();
            }
            catch (InterruptedException e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
        this._handlers.remove(handler);
        this.removeComponent(handler);
        this._handlersArray = null;
    }

    public void setInitParameter(String param, String value) {
        this._initParams.put(param, value);
    }

    public String getInitParameter(String param) {
        return (String)this._initParams.get(param);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public synchronized void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Map getAttributes() {
        return this._attributes;
    }

    public void setAttributes(Map attributes) {
        this._attributes = attributes;
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this._attributes.keySet());
    }

    public synchronized void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void flushCache() {
        this._resources.flushCache();
    }

    public String[] getWelcomeFiles() {
        return this._welcomes;
    }

    public void setWelcomeFiles(String[] welcomes) {
        this._welcomes = welcomes == null ? new String[0] : welcomes;
    }

    public void addWelcomeFile(String welcomeFile) {
        if (welcomeFile.startsWith("/") || welcomeFile.startsWith(File.separator) || welcomeFile.endsWith("/") || welcomeFile.endsWith(File.separator)) {
            log.warn((Object)("Invalid welcome file: " + welcomeFile));
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this._welcomes));
        list.add(welcomeFile);
        this._welcomes = list.toArray(this._welcomes);
    }

    public void removeWelcomeFile(String welcomeFile) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this._welcomes));
        list.remove(welcomeFile);
        this._welcomes = list.toArray(this._welcomes);
    }

    public String getWelcomeFile(Resource resource) throws IOException {
        if (!resource.isDirectory()) {
            return null;
        }
        int i = 0;
        while (i < this._welcomes.length) {
            Resource welcome = resource.addPath(this._welcomes[i]);
            if (welcome.exists()) {
                return this._welcomes[i];
            }
            ++i;
        }
        return null;
    }

    public String getClassPath() {
        return this._classPath;
    }

    public String getFileClassPath() throws IllegalStateException {
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            throw new IllegalStateException("Context classloader not initialized");
        }
        LinkedList<String> paths = new LinkedList<String>();
        LinkedList<ClassLoader> loaders = new LinkedList<ClassLoader>();
        while (loader != null) {
            loaders.add(0, loader);
            loader = loader.getParent();
        }
        loader = this.getClassLoader();
        if (loader instanceof ContextLoader && !((ContextLoader)loader).isJava2Compliant()) {
            loaders.remove(loader);
            loaders.add(0, loader);
        }
        int i = 0;
        while (i < loaders.size()) {
            loader = (ClassLoader)loaders.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("extract paths from " + loader));
            }
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                int j = 0;
                while (urls != null && j < urls.length) {
                    try {
                        File file;
                        Resource path = Resource.newResource(urls[j]);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("path " + path));
                        }
                        if ((file = path.getFile()) != null) {
                            paths.add(file.getAbsolutePath());
                        }
                    }
                    catch (Exception e) {
                        LogSupport.ignore(log, e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        String jcp = System.getProperty("java.class.path");
        if (jcp != null) {
            StringTokenizer tok = new StringTokenizer(jcp, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String path = tok.nextToken();
                if (!paths.contains(path)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("PATH=" + path));
                    }
                    paths.add(path);
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("done=" + path));
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(iter.next().toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("fileClassPath=" + buf));
        }
        return buf.toString();
    }

    public void setClassPath(String classPath) {
        this._classPath = classPath;
        if (this.isStarted()) {
            log.warn((Object)"classpath set while started");
        }
    }

    public void addClassPath(String classPath) {
        this._classPath = this._classPath == null || this._classPath.length() == 0 ? classPath : String.valueOf(this._classPath) + "," + classPath;
        if (this.isStarted()) {
            log.warn((Object)"classpath set while started");
        }
    }

    public void addClassPaths(Resource lib) {
        if (this.isStarted()) {
            log.warn((Object)"classpaths set while started");
        }
        if (lib.exists() && lib.isDirectory()) {
            String[] files = lib.list();
            int f = 0;
            while (files != null && f < files.length) {
                try {
                    Resource fn = lib.addPath(files[f]);
                    String fnlc = fn.getName().toLowerCase();
                    if (fnlc.endsWith(".jar") || fnlc.endsWith(".zip")) {
                        this.addClassPath(fn.toString());
                    }
                }
                catch (Exception ex) {
                    log.warn((Object)"EXCEPTION ", (Throwable)ex);
                }
                ++f;
            }
        }
    }

    public boolean isClassLoaderJava2Compliant() {
        return this._classLoaderJava2Compliant;
    }

    public void setClassLoaderJava2Compliant(boolean compliant) {
        this._classLoaderJava2Compliant = compliant;
        if (this._loader != null && this._loader instanceof ContextLoader) {
            ((ContextLoader)this._loader).setJava2Compliant(compliant);
        }
    }

    public void setTempDirectory(File dir) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (dir != null) {
            try {
                dir = new File(dir.getCanonicalPath());
            }
            catch (IOException e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
        if (dir != null && !dir.exists()) {
            dir.mkdir();
            dir.deleteOnExit();
        }
        if (!(dir == null || dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad temp directory: " + dir);
        }
        this._tmpDir = dir;
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
    }

    public File getTempDirectory() {
        if (this._tmpDir != null) {
            return this._tmpDir;
        }
        Object t = this.getAttribute("javax.servlet.context.tempdir");
        if (t != null && t instanceof File) {
            this._tmpDir = (File)t;
            if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                return this._tmpDir;
            }
        }
        if (t != null && t instanceof String) {
            try {
                this._tmpDir = new File((String)t);
                if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Converted to File " + this._tmpDir + " for " + this));
                    }
                    this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
                    return this._tmpDir;
                }
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
        File work = null;
        try {
            work = new File(System.getProperty("jetty.home"), "work");
            if (!(work.exists() && work.canWrite() && work.isDirectory())) {
                work = null;
            }
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
        }
        try {
            HttpListener httpListener = this._httpServer.getListeners()[0];
            String vhost = null;
            int h = 0;
            while (vhost == null && this._vhosts != null && h < this._vhosts.size()) {
                vhost = (String)this._vhosts.get(h);
                ++h;
            }
            String host = httpListener.getHost();
            String temp = "Jetty_" + (host == null ? "" : host) + "_" + httpListener.getPort() + "_" + (vhost == null ? "" : vhost) + this.getContextPath();
            temp = temp.replace('/', '_');
            temp = temp.replace('.', '_');
            temp = temp.replace('\\', '_');
            if (work != null) {
                this._tmpDir = new File(work, temp);
            } else {
                this._tmpDir = new File(System.getProperty("java.io.tmpdir"), temp);
                if (this._tmpDir.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete existing temp dir " + this._tmpDir + " for " + this));
                    }
                    if (!IO.delete(this._tmpDir) && log.isDebugEnabled()) {
                        log.debug((Object)("Failed to delete temp dir " + this._tmpDir));
                    }
                    if (this._tmpDir.exists()) {
                        String old = this._tmpDir.toString();
                        this._tmpDir = File.createTempFile(String.valueOf(temp) + "_", "");
                        if (this._tmpDir.exists()) {
                            this._tmpDir.delete();
                        }
                        log.warn((Object)("Can't reuse " + old + ", using " + this._tmpDir));
                    }
                }
            }
            if (!this._tmpDir.exists()) {
                this._tmpDir.mkdir();
            }
            if (work == null) {
                this._tmpDir.deleteOnExit();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created temp dir " + this._tmpDir + " for " + this));
            }
        }
        catch (Exception e) {
            this._tmpDir = null;
            LogSupport.ignore(log, e);
        }
        if (this._tmpDir == null) {
            try {
                this._tmpDir = File.createTempFile("JettyContext", "");
                if (this._tmpDir.exists()) {
                    this._tmpDir.delete();
                }
                this._tmpDir.mkdir();
                this._tmpDir.deleteOnExit();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created temp dir " + this._tmpDir + " for " + this));
                }
            }
            catch (IOException e) {
                log.fatal((Object)e);
                System.exit(1);
            }
        }
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
        return this._tmpDir;
    }

    public synchronized void setClassLoader(ClassLoader loader) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._loader = loader;
    }

    public synchronized ClassLoader getClassLoader() {
        return this._loader;
    }

    public synchronized void setParentClassLoader(ClassLoader loader) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._parent = loader;
    }

    public ClassLoader getParentClassLoader() {
        return this._parent;
    }

    protected void initClassLoader(boolean forceContextLoader) throws MalformedURLException, IOException {
        ClassLoader parent = this._parent;
        if (this._loader == null) {
            if (parent == null) {
                parent = Thread.currentThread().getContextClassLoader();
            }
            if (parent == null) {
                parent = this.getClass().getClassLoader();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Init classloader from " + this._classPath + ", " + parent + " for " + this));
            }
            if (forceContextLoader || this._classPath != null || this._permissions != null) {
                ContextLoader loader = new ContextLoader(this, this._classPath, parent, this._permissions);
                loader.setJava2Compliant(this._classLoaderJava2Compliant);
                this._loader = loader;
            } else {
                this._loader = parent;
            }
        }
    }

    public synchronized Class loadClass(String className) throws ClassNotFoundException {
        if (this._loader == null) {
            try {
                this.initClassLoader(false);
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                return null;
            }
        }
        if (className == null) {
            return null;
        }
        if (this._loader == null) {
            return Class.forName(className);
        }
        return this._loader.loadClass(className);
    }

    public void setRealmName(String realmName) {
        this._realmName = realmName;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public void setRealm(UserRealm realm) {
        this._userRealm = realm;
    }

    public UserRealm getRealm() {
        return this._userRealm;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this._authenticator = authenticator;
    }

    public void addSecurityConstraint(String pathSpec, SecurityConstraint sc) {
        Object scs = this._constraintMap.get(pathSpec);
        scs = LazyList.add(scs, sc);
        this._constraintMap.put(pathSpec, scs);
        if (log.isDebugEnabled()) {
            log.debug((Object)("added " + sc + " at " + pathSpec));
        }
    }

    public void clearSecurityConstraints() {
        this._constraintMap.clear();
    }

    public boolean checkSecurityConstraints(String pathInContext, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        UserRealm realm = this.getRealm();
        List scss = this._constraintMap.getMatches(pathInContext);
        String pattern = null;
        if (scss != null && scss.size() > 0) {
            Object constraints = null;
            int m = 0;
            block0: while (m < scss.size()) {
                Map.Entry entry = (Map.Entry)scss.get(m);
                Object scs = entry.getValue();
                String p = (String)entry.getKey();
                int c = 0;
                while (c < LazyList.size(scs)) {
                    SecurityConstraint sc = (SecurityConstraint)LazyList.get(scs, c);
                    if (sc.forMethod(request.getMethod())) {
                        if (pattern != null && !pattern.equals(p)) break block0;
                        pattern = p;
                        constraints = LazyList.add(constraints, sc);
                    }
                    ++c;
                }
                ++m;
            }
            return SecurityConstraint.check(LazyList.getList(constraints), this._authenticator, realm, pathInContext, request, response);
        }
        request.setUserPrincipal(HttpRequest.__NOT_CHECKED);
        return true;
    }

    public void setRedirectNullPath(boolean b) {
        this._redirectNullPath = b;
    }

    public boolean isRedirectNullPath() {
        return this._redirectNullPath;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public void addPermission(Permission permission) {
        if (this._permissions == null) {
            this._permissions = new Permissions();
        }
        this._permissions.add(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        String pathInContext;
        Socket s;
        Object o;
        if (!this.isStarted() || this._gracefulStop) {
            return;
        }
        if (this._hosts != null && this._hosts.size() > 0 && (o = request.getHttpConnection().getConnection()) instanceof Socket && !this._hosts.contains((s = (Socket)o).getLocalAddress())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(s.getLocalAddress() + " not in " + this._hosts));
            }
            return;
        }
        if (this._statsOn) {
            o = this._statsLock;
            synchronized (o) {
                ++this._requests;
                ++this._requestsActive;
                if (this._requestsActive > this._requestsActiveMax) {
                    this._requestsActiveMax = this._requestsActive;
                }
            }
        }
        if ((pathInContext = URI.canonicalPath(request.getPath())) == null) {
            throw new HttpException(400);
        }
        if (this._contextPath.length() > 1) {
            pathInContext = pathInContext.substring(this._contextPath.length());
        }
        if (this._redirectNullPath && (pathInContext == null || pathInContext.length() == 0)) {
            StringBuffer buf = request.getRequestURL();
            buf.append("/");
            String q = request.getQuery();
            if (q != null && q.length() != 0) {
                buf.append("?" + q);
            }
            response.sendRedirect(buf.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " consumed all of path " + request.getPath() + ", redirect to " + buf.toString()));
            }
            return;
        }
        String pathParams = null;
        int semi = pathInContext.lastIndexOf(59);
        if (semi >= 0) {
            int pl = pathInContext.length() - semi;
            String ep = request.getEncodedPath();
            if (';' == ep.charAt(ep.length() - pl)) {
                pathParams = pathInContext.substring(semi + 1);
                pathInContext = pathInContext.substring(0, semi);
            }
        }
        try {
            this.handle(pathInContext, pathParams, request, response);
        }
        finally {
            if (this._userRealm != null && request.hasUserPrincipal()) {
                this._userRealm.disassociate(request.getUserPrincipal());
            }
        }
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        Object old_scope = null;
        try {
            old_scope = this.enterContextScope(request, response);
            HttpHandler[] handlers = this.getHandlers();
            int k = 0;
            while (k < handlers.length) {
                HttpHandler handler = handlers[k];
                if (handler == null) {
                    handlers = this.getHandlers();
                    k = -1;
                } else if (!handler.isStarted()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(handler + " not started in " + this));
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Handler " + handler));
                    }
                    handler.handle(pathInContext, pathParams, request, response);
                    if (request.isHandled()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Handled by " + handler));
                        }
                        return;
                    }
                }
                ++k;
            }
            return;
        }
        finally {
            this.leaveContextScope(request, response, old_scope);
        }
    }

    public Object enterContextScope(HttpRequest request, HttpResponse response) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        HttpContext c = response.getHttpContext();
        Scope scope = null;
        if (cl != HttpContext.class.getClassLoader() || c != null) {
            scope = new Scope();
            scope._classLoader = cl;
            scope._httpContext = c;
        }
        if (this._loader != null) {
            thread.setContextClassLoader(this._loader);
        }
        response.setHttpContext(this);
        return scope;
    }

    public void leaveContextScope(HttpRequest request, HttpResponse response, Object oldScope) {
        if (oldScope == null) {
            Thread.currentThread().setContextClassLoader(HttpContext.class.getClassLoader());
            response.setHttpContext(null);
        } else {
            Scope old = (Scope)oldScope;
            Thread.currentThread().setContextClassLoader(old._classLoader);
            response.setHttpContext(old._httpContext);
        }
    }

    public String getHttpContextName() {
        if (this._contextName == null) {
            this._contextName = String.valueOf(this._vhosts.size() > 1 ? String.valueOf(this._vhosts.toString()) + ":" : "") + this._contextPath;
        }
        return this._contextName;
    }

    public void setHttpContextName(String s) {
        this._contextName = s;
    }

    public String toString() {
        return "HttpContext[" + this.getContextPath() + "," + this.getHttpContextName() + "]";
    }

    public String toString(boolean detail) {
        return "HttpContext[" + this.getContextPath() + "," + this.getHttpContextName() + "]" + (detail ? "=" + this._handlers : "");
    }

    @Override
    protected synchronized void doStart() throws Exception {
        if (this.isStarted()) {
            return;
        }
        if (this._httpServer.getServerClasses() != null) {
            this._serverClasses = this._httpServer.getServerClasses();
        }
        if (this._httpServer.getSystemClasses() != null) {
            this._systemClasses = this._httpServer.getSystemClasses();
        }
        this._resources.start();
        this.statsReset();
        if (this._httpServer == null) {
            throw new IllegalStateException("No server for " + this);
        }
        this._resources.getMimeMap();
        this._resources.getEncodingMap();
        if (this._userRealm == null && this._authenticator != null) {
            this._userRealm = this._httpServer.getRealm(this._realmName);
            if (this._userRealm == null) {
                log.warn((Object)("No Realm: " + this._realmName));
            }
        }
        this.initClassLoader(false);
        String attr = this.getInitParameter(__fileClassPathAttr);
        if (attr != null && attr.length() > 0) {
            this.setAttribute(attr, this.getFileClassPath());
        }
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            if (this._requestLog != null) {
                this._requestLog.start();
            }
            this.startHandlers();
        }
        finally {
            thread.setContextClassLoader(lastContextLoader);
            this.getHandlers();
        }
    }

    protected void startHandlers() throws Exception {
        MultiException mx = new MultiException();
        for (HttpHandler handler : this._handlers) {
            if (handler.isStarted()) continue;
            try {
                handler.start();
            }
            catch (Exception e) {
                mx.add(e);
            }
        }
        mx.ifExceptionThrow();
    }

    public void stop(boolean graceful) throws InterruptedException {
        boolean gs = this._gracefulStop;
        try {
            this._gracefulStop = true;
            while (graceful && this._statsOn && this._requestsActive > 0 && this._httpServer != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                }
            }
            this.stop();
        }
        finally {
            this._gracefulStop = gs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        if (this._httpServer == null) {
            throw new InterruptedException("Destroy called");
        }
        HttpContext httpContext = this;
        synchronized (httpContext) {
            Thread thread = Thread.currentThread();
            ClassLoader lastContextLoader = thread.getContextClassLoader();
            try {
                if (this._loader != null) {
                    thread.setContextClassLoader(this._loader);
                }
                for (HttpHandler handler : this._handlers) {
                    if (!handler.isStarted()) continue;
                    try {
                        handler.stop();
                    }
                    catch (Exception e) {
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                    }
                }
                if (this._requestLog != null) {
                    this._requestLog.stop();
                }
            }
            finally {
                thread.setContextClassLoader(lastContextLoader);
            }
            if (this._loader instanceof ContextLoader) {
                ((ContextLoader)this._loader).destroy();
                LogFactory.release(this._loader);
            }
            this._loader = null;
        }
        this._resources.flushCache();
        this._resources.stop();
    }

    @Override
    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._httpServer != null) {
            this._httpServer.removeContext(this);
        }
        this._httpServer = null;
        if (this._handlers != null) {
            this._handlers.clear();
        }
        this._handlers = null;
        this._parent = null;
        this._loader = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._attributes = null;
        if (this._initParams != null) {
            this._initParams.clear();
        }
        this._initParams = null;
        if (this._vhosts != null) {
            this._vhosts.clear();
        }
        this._vhosts = null;
        this._hosts = null;
        this._tmpDir = null;
        this._permissions = null;
        this.removeComponent(this._resources);
        if (this._resources != null) {
            this._resources.flushCache();
            if (this._resources.isStarted()) {
                try {
                    this._resources.stop();
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                }
            }
            this._resources.destroy();
        }
        this._resources = null;
        super.destroy();
    }

    public void setRequestLog(RequestLog log) {
        this._requestLog = log;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public void sendError(HttpResponse response, int code, String msg) throws IOException {
        response.sendError(code, msg);
    }

    public static void sendContextError(HttpResponse response, int code, String msg) throws IOException {
        HttpContext context = response.getHttpContext();
        if (context != null) {
            context.sendError(response, code, msg);
        } else {
            response.sendError(code, msg);
        }
    }

    public void setStatsOn(boolean on) {
        log.info((Object)("setStatsOn " + on + " for " + this));
        this._statsOn = on;
        this.statsReset();
    }

    public boolean getStatsOn() {
        return this._statsOn;
    }

    public long getStatsOnMs() {
        return this._statsOn ? System.currentTimeMillis() - this._statsStartedAt : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statsReset() {
        Object object = this._statsLock;
        synchronized (object) {
            if (this._statsOn) {
                this._statsStartedAt = System.currentTimeMillis();
            }
            this._requests = 0;
            this._requestsActiveMax = this._requestsActive;
            this._responses1xx = 0;
            this._responses2xx = 0;
            this._responses3xx = 0;
            this._responses4xx = 0;
            this._responses5xx = 0;
        }
    }

    public int getRequests() {
        return this._requests;
    }

    public int getRequestsActive() {
        return this._requestsActive;
    }

    public int getRequestsActiveMax() {
        return this._requestsActiveMax;
    }

    public int getResponses1xx() {
        return this._responses1xx;
    }

    public int getResponses2xx() {
        return this._responses2xx;
    }

    public int getResponses3xx() {
        return this._responses3xx;
    }

    public int getResponses4xx() {
        return this._responses4xx;
    }

    public int getResponses5xx() {
        return this._responses5xx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(HttpRequest request, HttpResponse response, int length) {
        if (this._statsOn) {
            Object object = this._statsLock;
            synchronized (object) {
                if (--this._requestsActive < 0) {
                    this._requestsActive = 0;
                }
                if (response != null) {
                    switch (response.getStatus() / 100) {
                        case 1: {
                            ++this._responses1xx;
                            break;
                        }
                        case 2: {
                            ++this._responses2xx;
                            break;
                        }
                        case 3: {
                            ++this._responses3xx;
                            break;
                        }
                        case 4: {
                            ++this._responses4xx;
                            break;
                        }
                        case 5: {
                            ++this._responses5xx;
                        }
                    }
                }
            }
        }
        if (this._requestLog != null && request != null && response != null) {
            this._requestLog.log(request, response, length);
        } else if (this._httpServer != null) {
            this._httpServer.log(request, response, length);
        }
    }

    @Override
    public String getName() {
        return this.getContextPath();
    }

    @Override
    public HttpContext getHttpContext() {
        return this;
    }

    @Override
    public void initialize(HttpContext context) {
        throw new UnsupportedOperationException();
    }

    public Resource getBaseResource() {
        return this._resources.getBaseResource();
    }

    public String getEncodingByMimeType(String type) {
        return this._resources.getEncodingByMimeType(type);
    }

    public Map getEncodingMap() {
        return this._resources.getEncodingMap();
    }

    public int getMaxCachedFileSize() {
        return this._resources.getMaxCachedFileSize();
    }

    public int getMaxCacheSize() {
        return this._resources.getMaxCacheSize();
    }

    public String getMimeByExtension(String filename) {
        return this._resources.getMimeByExtension(filename);
    }

    public Map getMimeMap() {
        return this._resources.getMimeMap();
    }

    public Resource getResource(String pathInContext) throws IOException {
        return this._resources.getResource(pathInContext);
    }

    public String getResourceBase() {
        return this._resources.getResourceBase();
    }

    public ResourceCache.ResourceMetaData getResourceMetaData(Resource resource) {
        return this._resources.getResourceMetaData(resource);
    }

    public void setBaseResource(Resource base) {
        this._resources.setBaseResource(base);
    }

    public void setEncodingMap(Map encodingMap) {
        this._resources.setEncodingMap(encodingMap);
    }

    public void setMaxCachedFileSize(int maxCachedFileSize) {
        this._resources.setMaxCachedFileSize(maxCachedFileSize);
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this._resources.setMaxCacheSize(maxCacheSize);
    }

    public void setMimeMap(Map mimeMap) {
        this._resources.setMimeMap(mimeMap);
    }

    public void setMimeMapping(String extension, String type) {
        this._resources.setMimeMapping(extension, type);
    }

    public void setResourceBase(String resourceBase) {
        this._resources.setResourceBase(resourceBase);
    }

    public void setTypeEncoding(String mimeType, String encoding) {
        this._resources.setTypeEncoding(mimeType, encoding);
    }

    private static class Scope {
        ClassLoader _classLoader;
        HttpContext _httpContext;

        private Scope() {
        }
    }
}

