/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpHandler;
import net.lightbody.bmp.proxy.jetty.http.HttpListener;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.PathMap;
import net.lightbody.bmp.proxy.jetty.http.RequestLog;
import net.lightbody.bmp.proxy.jetty.http.SocketListener;
import net.lightbody.bmp.proxy.jetty.http.UserRealm;
import net.lightbody.bmp.proxy.jetty.http.Version;
import net.lightbody.bmp.proxy.jetty.http.handler.DumpHandler;
import net.lightbody.bmp.proxy.jetty.http.handler.NotFoundHandler;
import net.lightbody.bmp.proxy.jetty.http.handler.ResourceHandler;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.Container;
import net.lightbody.bmp.proxy.jetty.util.EventProvider;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import net.lightbody.bmp.proxy.jetty.util.LifeCycle;
import net.lightbody.bmp.proxy.jetty.util.MultiException;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import net.lightbody.bmp.proxy.jetty.util.StringMap;
import net.lightbody.bmp.proxy.jetty.util.ThreadPool;
import net.lightbody.bmp.proxy.jetty.util.URI;
import org.apache.commons.logging.Log;

public class HttpServer
extends Container
implements LifeCycle,
EventProvider,
Serializable {
    private static Log log = LogFactory.getLog(HttpServer.class);
    private static WeakHashMap __servers = new WeakHashMap();
    private static Collection __roServers = Collections.unmodifiableCollection(__servers.keySet());
    private static String[] __noVirtualHost = new String[1];
    private List _listeners = new ArrayList(3);
    private HashMap _realmMap = new HashMap(3);
    private StringMap _virtualHostMap = new StringMap();
    private boolean _trace = false;
    private RequestLog _requestLog;
    private int _requestsPerGC;
    private boolean _resolveRemoteHost = false;
    private String[] _serverClasses;
    private String[] _systemClasses;
    private transient int _gcRequests;
    private transient HttpContext _notFoundContext = null;
    private transient boolean _gracefulStop;
    private boolean _statsOn = false;
    private transient Object _statsLock = new Object[0];
    private transient long _statsStartedAt = 0L;
    private transient int _connections;
    private transient int _connectionsOpen;
    private transient int _connectionsOpenMin;
    private transient int _connectionsOpenMax;
    private transient long _connectionsDurationMin;
    private transient long _connectionsDurationMax;
    private transient long _connectionsDurationTotal;
    private transient int _errors;
    private transient int _requests;
    private transient int _requestsActive;
    private transient int _requestsActiveMin;
    private transient int _requestsActiveMax;
    private transient int _connectionsRequestsMin;
    private transient int _connectionsRequestsMax;
    private transient long _requestsDurationMin;
    private transient long _requestsDurationMax;
    private transient long _requestsDurationTotal;

    public static Collection getHttpServers() {
        return __roServers;
    }

    public static List getHttpServerList() {
        return new ArrayList(__roServers);
    }

    public HttpServer() {
        this(false);
    }

    public HttpServer(boolean anonymous) {
        this.setAnonymous(anonymous);
        this._virtualHostMap.setIgnoreCase(true);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        HttpListener[] listeners = this.getListeners();
        HttpContext[] contexts = this.getContexts();
        this._listeners.clear();
        this._virtualHostMap.clear();
        this.setContexts(contexts);
        this.setListeners(listeners);
        this._statsLock = new Object[0];
    }

    public void setAnonymous(boolean anonymous) {
        if (anonymous) {
            __servers.remove(this);
        } else {
            __servers.put(this, __servers);
        }
    }

    public void setStopGracefully(boolean graceful) {
        this._gracefulStop = graceful;
    }

    public boolean getStopGracefully() {
        return this._gracefulStop;
    }

    public void setListeners(HttpListener[] listeners) {
        ArrayList old = new ArrayList(this._listeners);
        int i = 0;
        while (i < listeners.length) {
            boolean existing = old.remove(listeners[i]);
            if (!existing) {
                this.addListener(listeners[i]);
            }
            ++i;
        }
        i = 0;
        while (i < old.size()) {
            HttpListener listener = (HttpListener)old.get(i);
            this.removeListener(listener);
            ++i;
        }
    }

    public HttpListener[] getListeners() {
        if (this._listeners == null) {
            return new HttpListener[0];
        }
        HttpListener[] listeners = new HttpListener[this._listeners.size()];
        return this._listeners.toArray(listeners);
    }

    public HttpListener addListener(String address) throws IOException {
        return this.addListener(new InetAddrPort(address));
    }

    public HttpListener addListener(InetAddrPort address) throws IOException {
        SocketListener listener = new SocketListener(address);
        listener.setHttpServer(this);
        this._listeners.add(listener);
        this.addComponent(listener);
        return listener;
    }

    public HttpListener addListener(HttpListener listener) throws IllegalArgumentException {
        listener.setHttpServer(this);
        this._listeners.add(listener);
        this.addComponent(listener);
        return listener;
    }

    public void removeListener(HttpListener listener) {
        if (listener == null) {
            return;
        }
        int l = 0;
        while (l < this._listeners.size()) {
            if (listener.equals(this._listeners.get(l))) {
                this._listeners.remove(l);
                this.removeComponent(listener);
                if (listener.isStarted()) {
                    try {
                        listener.stop();
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                    }
                }
                listener.setHttpServer(null);
            }
            ++l;
        }
    }

    public synchronized void setContexts(HttpContext[] contexts) {
        List<HttpContext> old = Arrays.asList(this.getContexts());
        int i = 0;
        while (i < contexts.length) {
            boolean existing = old.remove(contexts[i]);
            if (!existing) {
                this.addContext(contexts[i]);
            }
            ++i;
        }
        i = 0;
        while (i < old.size()) {
            this.removeContext(old.get(i));
            ++i;
        }
    }

    public synchronized HttpContext[] getContexts() {
        if (this._virtualHostMap == null) {
            return new HttpContext[0];
        }
        ArrayList<HttpContext> contexts = new ArrayList<HttpContext>(33);
        for (PathMap pm : this._virtualHostMap.values()) {
            for (List list : pm.values()) {
                int i = 0;
                while (i < list.size()) {
                    HttpContext context = (HttpContext)list.get(i);
                    if (!contexts.contains(context)) {
                        contexts.add(context);
                    }
                    ++i;
                }
            }
        }
        return contexts.toArray(new HttpContext[contexts.size()]);
    }

    public HttpContext addContext(HttpContext context) {
        if (context.getContextPath() == null || context.getContextPath().length() == 0) {
            throw new IllegalArgumentException("No Context Path Set");
        }
        boolean existing = this.removeMappings(context);
        if (!existing) {
            context.setHttpServer(this);
            this.addComponent(context);
        }
        this.addMappings(context);
        return context;
    }

    public boolean removeContext(HttpContext context) throws IllegalStateException {
        if (this.removeMappings(context)) {
            this.removeComponent(context);
            if (context.isStarted()) {
                try {
                    context.stop();
                }
                catch (InterruptedException e) {
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                }
            }
            context.setHttpServer(null);
            return true;
        }
        return false;
    }

    public HttpContext addContext(String virtualHost, HttpContext context) {
        if (virtualHost != null) {
            context.addVirtualHost(virtualHost);
        }
        this.addContext(context);
        return context;
    }

    public HttpContext addContext(String contextPath) {
        HttpContext hc = this.newHttpContext();
        hc.setContextPath(contextPath);
        this.addContext(hc);
        return hc;
    }

    public HttpContext addContext(String virtualHost, String contextPathSpec) {
        if (virtualHost != null && virtualHost.length() == 0) {
            virtualHost = null;
        }
        HttpContext hc = this.newHttpContext();
        hc.setContextPath(contextPathSpec);
        if (virtualHost != null) {
            hc.addVirtualHost(virtualHost);
        }
        this.addContext(hc);
        return hc;
    }

    public HttpContext getContext(String virtualHost, String contextPathSpec, int i) {
        List contextList;
        HttpContext hc = null;
        contextPathSpec = HttpContext.canonicalContextPathSpec(contextPathSpec);
        PathMap contextMap = (PathMap)this._virtualHostMap.get(virtualHost);
        if (contextMap != null && (contextList = (List)contextMap.get(contextPathSpec)) != null) {
            if (i >= contextList.size()) {
                return null;
            }
            hc = (HttpContext)contextList.get(i);
        }
        return hc;
    }

    public HttpContext getContext(String virtualHost, String contextPathSpec) {
        List contextList;
        HttpContext hc = null;
        contextPathSpec = HttpContext.canonicalContextPathSpec(contextPathSpec);
        PathMap contextMap = (PathMap)this._virtualHostMap.get(virtualHost);
        if (contextMap != null && (contextList = (List)contextMap.get(contextPathSpec)) != null && contextList.size() > 0) {
            hc = (HttpContext)contextList.get(contextList.size() - 1);
        }
        if (hc == null) {
            hc = this.addContext(virtualHost, contextPathSpec);
        }
        return hc;
    }

    public HttpContext getContext(String contextPathSpec) {
        return this.getContext(null, contextPathSpec);
    }

    protected HttpContext newHttpContext() {
        return new HttpContext();
    }

    synchronized void addMapping(String virtualHost, HttpContext context) {
        String contextPathSpec;
        ArrayList<HttpContext> contextList;
        PathMap contextMap = (PathMap)this._virtualHostMap.get(virtualHost);
        if (contextMap == null) {
            contextMap = new PathMap(7);
            this._virtualHostMap.put(virtualHost, (Object)contextMap);
        }
        if ((contextList = (ArrayList<HttpContext>)contextMap.get(contextPathSpec = HttpContext.canonicalContextPathSpec(context.getContextPath()))) == null) {
            contextList = new ArrayList<HttpContext>(1);
            contextMap.put(contextPathSpec, contextList);
        }
        contextList.add(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + context + " for host " + (virtualHost == null ? "*" : virtualHost)));
        }
    }

    synchronized void addMappings(HttpContext context) {
        if (context == this._notFoundContext) {
            return;
        }
        String[] hosts = context.getVirtualHosts();
        if (hosts == null || hosts.length == 0) {
            hosts = __noVirtualHost;
        }
        int h = 0;
        while (h < hosts.length) {
            String virtualHost = hosts[h];
            this.addMapping(virtualHost, context);
            ++h;
        }
    }

    synchronized boolean removeMapping(String virtualHost, HttpContext context) {
        boolean existing = false;
        if (this._virtualHostMap != null) {
            PathMap contextMap = (PathMap)this._virtualHostMap.get(virtualHost);
            Iterator i2 = contextMap.values().iterator();
            while (i2.hasNext()) {
                List contextList = (List)i2.next();
                if (contextList.remove(context)) {
                    existing = true;
                }
                if (contextList.size() != 0) continue;
                i2.remove();
            }
        }
        return existing;
    }

    synchronized boolean removeMappings(HttpContext context) {
        boolean existing = false;
        if (this._virtualHostMap != null) {
            for (String virtualHost : this._virtualHostMap.keySet()) {
                if (!this.removeMapping(virtualHost, context)) continue;
                existing = true;
            }
        }
        return existing;
    }

    public boolean getTrace() {
        return this._trace;
    }

    public void setTrace(boolean trace) {
        this._trace = trace;
    }

    public int getRequestsPerGC() {
        return this._requestsPerGC;
    }

    public void setRequestsPerGC(int requestsPerGC) {
        this._requestsPerGC = requestsPerGC;
    }

    public void setSystemClasses(String[] classes) {
        this._systemClasses = classes;
    }

    public String[] getSystemClasses() {
        return this._systemClasses;
    }

    public void setServerClasses(String[] classes) {
        this._serverClasses = classes;
    }

    public String[] getServerClasses() {
        return this._serverClasses;
    }

    @Override
    protected synchronized void doStart() throws Exception {
        log.info((Object)("Version " + Version.getImplVersion()));
        MultiException mex = new MultiException();
        this.statsReset();
        if (log.isDebugEnabled()) {
            log.debug((Object)("LISTENERS: " + this._listeners));
            log.debug((Object)("HANDLER: " + this._virtualHostMap));
        }
        if (this._requestLog != null && !this._requestLog.isStarted()) {
            try {
                this._requestLog.start();
            }
            catch (Exception e) {
                mex.add(e);
            }
        }
        HttpContext[] contexts = this.getContexts();
        int i = 0;
        while (i < contexts.length) {
            HttpContext context = contexts[i];
            try {
                context.start();
            }
            catch (Exception e) {
                mex.add(e);
            }
            ++i;
        }
        int l = 0;
        while (l < this._listeners.size()) {
            HttpListener listener = (HttpListener)this._listeners.get(l);
            listener.setHttpServer(this);
            if (!listener.isStarted()) {
                try {
                    listener.start();
                }
                catch (Exception e) {
                    mex.add(e);
                }
            }
            ++l;
        }
        mex.ifExceptionThrowMulti();
    }

    @Override
    protected synchronized void doStop() throws InterruptedException {
        int l = 0;
        while (l < this._listeners.size()) {
            HttpListener listener = (HttpListener)this._listeners.get(l);
            if (listener.isStarted()) {
                try {
                    listener.stop();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                    }
                    log.warn((Object)e.toString());
                }
            }
            ++l;
        }
        HttpContext[] contexts = this.getContexts();
        int i = 0;
        while (i < contexts.length) {
            HttpContext context = contexts[i];
            context.stop(this._gracefulStop);
            ++i;
        }
        if (this._notFoundContext != null) {
            this._notFoundContext.stop();
            this.removeComponent(this._notFoundContext);
        }
        this._notFoundContext = null;
        if (this._requestLog != null && this._requestLog.isStarted()) {
            this._requestLog.stop();
        }
    }

    public synchronized void stop(boolean graceful) throws InterruptedException {
        boolean ov = this._gracefulStop;
        try {
            this._gracefulStop = graceful;
            this.stop();
        }
        finally {
            this._gracefulStop = ov;
        }
    }

    public void join() throws InterruptedException {
        int l = 0;
        while (l < this._listeners.size()) {
            HttpListener listener = (HttpListener)this._listeners.get(l);
            if (listener.isStarted() && listener instanceof ThreadPool) {
                ((ThreadPool)((Object)listener)).join();
            }
            ++l;
        }
    }

    public void addHostAlias(String virtualHost, String alias) {
        log.warn((Object)"addHostAlias is deprecated. Use HttpContext.addVirtualHost");
        Object contextMap = this._virtualHostMap.get(virtualHost);
        if (contextMap == null) {
            throw new IllegalArgumentException("No Such Host: " + virtualHost);
        }
        this._virtualHostMap.put(alias, contextMap);
    }

    public synchronized void setRequestLog(RequestLog log) {
        if (this._requestLog != null) {
            this.removeComponent(this._requestLog);
        }
        this._requestLog = log;
        if (this._requestLog != null) {
            this.addComponent(this._requestLog);
        }
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    void log(HttpRequest request, HttpResponse response, int length) {
        if (this._requestLog != null && request != null && response != null) {
            this._requestLog.log(request, response, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpContext service(HttpRequest request, HttpResponse response) throws IOException, HttpException {
        String host = request.getHost();
        if (this._requestsPerGC > 0 && this._gcRequests++ > this._requestsPerGC) {
            this._gcRequests = 0;
            System.gc();
        }
        while (true) {
            List contextLists;
            PathMap contextMap;
            if ((contextMap = (PathMap)this._virtualHostMap.get(host)) != null && (contextLists = contextMap.getMatches(request.getPath())) != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Contexts at " + request.getPath() + ": " + contextLists));
                }
                int i = 0;
                while (i < contextLists.size()) {
                    Map.Entry entry = (Map.Entry)contextLists.get(i);
                    List contextList = (List)entry.getValue();
                    int j = 0;
                    while (j < contextList.size()) {
                        HttpContext context = (HttpContext)contextList.get(j);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Try " + context + "," + j));
                        }
                        context.handle(request, response);
                        if (request.isHandled()) {
                            return context;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (host == null) break;
            host = null;
        }
        HttpServer httpServer = this;
        synchronized (httpServer) {
            if (this._notFoundContext == null) {
                this._notFoundContext = new HttpContext();
                this._notFoundContext.setContextPath("/");
                this._notFoundContext.setHttpServer(this);
                try {
                    this._notFoundContext.addHandler((NotFoundHandler)Class.forName("RootNotFoundHandler").newInstance());
                }
                catch (Exception exception) {
                    this._notFoundContext.addHandler(new NotFoundHandler());
                }
                this.addComponent(this._notFoundContext);
                try {
                    this._notFoundContext.start();
                }
                catch (Exception e) {
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                }
            }
            this._notFoundContext.handle(request, response);
            if (!request.isHandled()) {
                response.sendError(404);
            }
            return this._notFoundContext;
        }
    }

    public HttpHandler findHandler(Class handlerClass, String uri, String[] vhosts) {
        uri = URI.stripPath(uri);
        if (vhosts == null || vhosts.length == 0) {
            vhosts = __noVirtualHost;
        }
        int h = 0;
        while (h < vhosts.length) {
            List contextLists;
            String host = vhosts[h];
            PathMap contextMap = (PathMap)this._virtualHostMap.get(host);
            if (contextMap != null && (contextLists = contextMap.getMatches(uri)) != null) {
                int i = 0;
                while (i < contextLists.size()) {
                    Map.Entry entry = (Map.Entry)contextLists.get(i);
                    List contextList = (List)entry.getValue();
                    int j = 0;
                    while (j < contextList.size()) {
                        HttpContext context = (HttpContext)contextList.get(j);
                        HttpHandler handler = context.getHandler(handlerClass);
                        if (handler != null) {
                            return handler;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            ++h;
        }
        return null;
    }

    public UserRealm addRealm(UserRealm realm) {
        return this._realmMap.put(realm.getName(), realm);
    }

    public UserRealm getRealm(String realmName) {
        if (realmName == null) {
            if (this._realmMap.size() == 1) {
                return (UserRealm)this._realmMap.values().iterator().next();
            }
            log.warn((Object)"Null realmName with multiple known realms");
        }
        return (UserRealm)this._realmMap.get(realmName);
    }

    public UserRealm removeRealm(String realmName) {
        return (UserRealm)this._realmMap.remove(realmName);
    }

    public Map getHostMap() {
        return this._virtualHostMap;
    }

    public boolean getResolveRemoteHost() {
        return this._resolveRemoteHost;
    }

    public void setResolveRemoteHost(boolean resolveRemoteHost) {
        this._resolveRemoteHost = resolveRemoteHost;
    }

    public void statsReset() {
        this._statsStartedAt = System.currentTimeMillis();
        this._connections = 0;
        this._connectionsOpenMin = this._connectionsOpen;
        this._connectionsOpenMax = this._connectionsOpen;
        this._connectionsOpen = 0;
        this._connectionsDurationMin = 0L;
        this._connectionsDurationMax = 0L;
        this._connectionsDurationTotal = 0L;
        this._errors = 0;
        this._requests = 0;
        this._requestsActiveMin = this._requestsActive;
        this._requestsActiveMax = this._requestsActive;
        this._requestsActive = 0;
        this._connectionsRequestsMin = 0;
        this._connectionsRequestsMax = 0;
        this._requestsDurationMin = 0L;
        this._requestsDurationMax = 0L;
        this._requestsDurationTotal = 0L;
    }

    public void setStatsOn(boolean on) {
        log.info((Object)("Statistics on = " + on + " for " + this));
        this._statsOn = on;
    }

    public boolean getStatsOn() {
        return this._statsOn;
    }

    public long getStatsOnMs() {
        return this._statsOn ? System.currentTimeMillis() - this._statsStartedAt : 0L;
    }

    public long getConnectionsDurationMin() {
        return this._connectionsDurationMin;
    }

    public long getConnectionsDurationTotal() {
        return this._connectionsDurationTotal;
    }

    public int getConnectionsOpenMin() {
        return this._connectionsOpenMin;
    }

    public int getConnectionsRequestsMin() {
        return this._connectionsRequestsMin;
    }

    public int getRequestsActiveMin() {
        return this._requestsActiveMin;
    }

    public long getRequestsDurationMin() {
        return this._requestsDurationMin;
    }

    public long getRequestsDurationTotal() {
        return this._requestsDurationTotal;
    }

    public int getConnections() {
        return this._connections;
    }

    public int getConnectionsOpen() {
        return this._connectionsOpen;
    }

    public int getConnectionsOpenMax() {
        return this._connectionsOpenMax;
    }

    public long getConnectionsDurationAve() {
        return this._connections == 0 ? 0L : this._connectionsDurationTotal / (long)this._connections;
    }

    public long getConnectionsDurationMax() {
        return this._connectionsDurationMax;
    }

    public int getConnectionsRequestsAve() {
        return this._connections == 0 ? 0 : this._requests / this._connections;
    }

    public int getConnectionsRequestsMax() {
        return this._connectionsRequestsMax;
    }

    public int getErrors() {
        return this._errors;
    }

    public int getRequests() {
        return this._requests;
    }

    public int getRequestsActive() {
        return this._requestsActive;
    }

    public int getRequestsActiveMax() {
        return this._requestsActiveMax;
    }

    public long getRequestsDurationAve() {
        return this._requests == 0 ? 0L : this._requestsDurationTotal / (long)this._requests;
    }

    public long getRequestsDurationMax() {
        return this._requestsDurationMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statsOpenConnection() {
        Object object = this._statsLock;
        synchronized (object) {
            ++this._connectionsOpen;
            if (this._connectionsOpen > this._connectionsOpenMax) {
                this._connectionsOpenMax = this._connectionsOpen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statsGotRequest() {
        Object object = this._statsLock;
        synchronized (object) {
            ++this._requestsActive;
            if (this._requestsActive > this._requestsActiveMax) {
                this._requestsActiveMax = this._requestsActive;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statsEndRequest(long duration, boolean ok) {
        Object object = this._statsLock;
        synchronized (object) {
            ++this._requests;
            --this._requestsActive;
            if (this._requestsActive < 0) {
                this._requestsActive = 0;
            }
            if (this._requestsActive < this._requestsActiveMin) {
                this._requestsActiveMin = this._requestsActive;
            }
            if (ok) {
                this._requestsDurationTotal += duration;
                if (this._requestsDurationMin == 0L || duration < this._requestsDurationMin) {
                    this._requestsDurationMin = duration;
                }
                if (duration > this._requestsDurationMax) {
                    this._requestsDurationMax = duration;
                }
            } else {
                ++this._errors;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void statsCloseConnection(long duration, int requests) {
        Object object = this._statsLock;
        synchronized (object) {
            ++this._connections;
            --this._connectionsOpen;
            this._connectionsDurationTotal += duration;
            if (this._connectionsOpen < 0) {
                this._connectionsOpen = 0;
            }
            if (this._connectionsOpen < this._connectionsOpenMin) {
                this._connectionsOpenMin = this._connectionsOpen;
            }
            if (this._connectionsDurationMin == 0L || duration < this._connectionsDurationMin) {
                this._connectionsDurationMin = duration;
            }
            if (duration > this._connectionsDurationMax) {
                this._connectionsDurationMax = duration;
            }
            if (this._connectionsRequestsMin == 0 || requests < this._connectionsRequestsMin) {
                this._connectionsRequestsMin = requests;
            }
            if (requests > this._connectionsRequestsMax) {
                this._connectionsRequestsMax = requests;
            }
        }
    }

    public void save(String saveat) throws MalformedURLException, IOException {
        Resource resource = Resource.newResource(saveat);
        ObjectOutputStream out = new ObjectOutputStream(resource.getOutputStream());
        out.writeObject(this);
        out.flush();
        out.close();
        log.info((Object)("Saved " + this + " to " + resource));
    }

    @Override
    public void destroy() {
        __servers.remove(this);
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._listeners != null) {
            this._listeners.clear();
        }
        this._listeners = null;
        if (this._virtualHostMap != null) {
            this._virtualHostMap.clear();
        }
        this._virtualHostMap = null;
        this._notFoundContext = null;
        super.destroy();
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 2) {
            System.err.println("\nUsage - java HttpServer [<addr>:]<port>");
            System.err.println("\nUsage - java HttpServer -r [savefile]");
            System.err.println("  Serves files from '.' directory");
            System.err.println("  Dump handler for not found requests");
            System.err.println("  Default port is 8080");
            System.exit(1);
        }
        try {
            if (args.length == 1) {
                HttpServer server = new HttpServer();
                String host = null;
                HttpContext context = server.getContext(host, "/");
                context.setResourceBase(".");
                context.addHandler(new ResourceHandler());
                context.addHandler(new DumpHandler());
                context.addHandler(new NotFoundHandler());
                InetAddrPort address = new InetAddrPort(args[0]);
                server.addListener(address);
                server.start();
            } else {
                Resource resource = Resource.newResource(args[1]);
                ObjectInputStream in = new ObjectInputStream(resource.getInputStream());
                HttpServer server = (HttpServer)in.readObject();
                in.close();
                server.start();
            }
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }
}

