/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.jetty;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.HttpServer;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHttpContext;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.WebApplicationContext;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.LogSupport;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import net.lightbody.bmp.proxy.jetty.xml.XmlConfiguration;
import org.apache.commons.logging.Log;

public class Server
extends HttpServer {
    static Log log = LogFactory.getLog(Server.class);
    private String[] _webAppConfigurationClassNames = new String[]{"XMLConfiguration", "JettyWebConfiguration"};
    private String _configuration;
    private String _rootWebApp;
    private static ShutdownHookThread hookThread = new ShutdownHookThread();

    public Server() {
    }

    public Server(String configuration) throws IOException {
        this(Resource.newResource(configuration).getURL());
    }

    public Server(Resource configuration) throws IOException {
        this(configuration.getURL());
    }

    public Server(URL configuration) throws IOException {
        this._configuration = configuration.toString();
        hookThread.add(this);
        try {
            XmlConfiguration config = new XmlConfiguration(configuration);
            config.configure(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            log.warn((Object)"EXCEPTION ", e.getTargetException());
            throw new IOException("Jetty configuration problem: " + e.getTargetException());
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            throw new IOException("Jetty configuration problem: " + e);
        }
    }

    public boolean getStopAtShutdown() {
        return hookThread.contains(this);
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            hookThread.add(this);
        } else {
            hookThread.remove(this);
        }
    }

    public String getRootWebApp() {
        return this._rootWebApp;
    }

    public void setRootWebApp(String rootWebApp) {
        this._rootWebApp = rootWebApp;
    }

    public void configure(String configuration) throws IOException {
        URL url = Resource.newResource(configuration).getURL();
        if (this._configuration != null && this._configuration.equals(url.toString())) {
            return;
        }
        if (this._configuration != null) {
            throw new IllegalStateException("Already configured with " + this._configuration);
        }
        try {
            XmlConfiguration config = new XmlConfiguration(url);
            this._configuration = url.toString();
            config.configure(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            throw new IOException("Jetty configuration problem: " + e);
        }
    }

    public String getConfiguration() {
        return this._configuration;
    }

    @Override
    protected HttpContext newHttpContext() {
        return new ServletHttpContext();
    }

    protected WebApplicationContext newWebApplicationContext(String webApp) {
        return new WebApplicationContext(webApp);
    }

    public WebApplicationContext addWebApplication(String contextPathSpec, String webApp) throws IOException {
        return this.addWebApplication(null, contextPathSpec, webApp);
    }

    public WebApplicationContext addWebApplication(String virtualHost, String contextPathSpec, String webApp) throws IOException {
        WebApplicationContext appContext = this.newWebApplicationContext(webApp);
        appContext.setContextPath(contextPathSpec);
        this.addContext(virtualHost, appContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Web Application " + appContext + " added"));
        }
        return appContext;
    }

    public WebApplicationContext[] addWebApplications(String webapps) throws IOException {
        return this.addWebApplications(null, webapps, null, false);
    }

    public WebApplicationContext[] addWebApplications(String host, String webapps) throws IOException {
        return this.addWebApplications(host, webapps, null, false);
    }

    public WebApplicationContext[] addWebApplications(String host, String webapps, boolean extract) throws IOException {
        return this.addWebApplications(host, webapps, null, extract);
    }

    public WebApplicationContext[] addWebApplications(String host, String webapps, String defaults, boolean extract) throws IOException {
        return this.addWebApplications(host, webapps, defaults, extract, true);
    }

    public WebApplicationContext[] addWebApplications(String host, String webapps, String defaults, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        ArrayList<WebApplicationContext> wacs = new ArrayList<WebApplicationContext>();
        Resource r = Resource.newResource(webapps);
        if (!r.exists()) {
            throw new IllegalArgumentException("No such webapps resource " + r);
        }
        if (!r.isDirectory()) {
            throw new IllegalArgumentException("Not directory webapps resource " + r);
        }
        String[] files = r.list();
        int f = 0;
        while (files != null && f < files.length) {
            String context = files[f];
            if (!(context.equalsIgnoreCase("CVS/") || context.equalsIgnoreCase("CVS") || context.startsWith("."))) {
                Resource unpacked;
                String app = r.addPath(r.encode(files[f])).toString();
                if (!context.toLowerCase().endsWith(".war") && !context.toLowerCase().endsWith(".jar") || (unpacked = r.addPath(context = context.substring(0, context.length() - 4))) == null || !unpacked.exists() || !unpacked.isDirectory()) {
                    context = this._rootWebApp != null && (context.equals(this._rootWebApp) || context.equals(String.valueOf(this._rootWebApp) + "/")) ? "/" : "/" + context;
                    WebApplicationContext wac = this.addWebApplication(host, context, app);
                    wac.setExtractWAR(extract);
                    wac.setClassLoaderJava2Compliant(java2CompliantClassLoader);
                    if (defaults != null) {
                        if (defaults.length() == 0) {
                            wac.setDefaultsDescriptor(null);
                        } else {
                            wac.setDefaultsDescriptor(defaults);
                        }
                    }
                    wacs.add(wac);
                }
            }
            ++f;
        }
        return wacs.toArray(new WebApplicationContext[wacs.size()]);
    }

    public void setWebApplicationConfigurationClassNames(String[] configurationClassNames) {
        if (configurationClassNames != null) {
            this._webAppConfigurationClassNames = new String[configurationClassNames.length];
            System.arraycopy(configurationClassNames, 0, this._webAppConfigurationClassNames, 0, configurationClassNames.length);
        }
    }

    public String[] getWebApplicationConfigurationClassNames() {
        return this._webAppConfigurationClassNames;
    }

    public static void main(String[] arg) {
        String[] dftConfig = new String[]{"etc/jetty.xml"};
        if (arg.length == 0) {
            log.info((Object)"Using default configuration: etc/jetty.xml");
            arg = dftConfig;
        }
        Server[] servers = new Server[arg.length];
        int i = 0;
        while (i < arg.length) {
            try {
                servers[i] = new Server(arg[i]);
                servers[i].setStopAtShutdown(true);
                servers[i].start();
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
            ++i;
        }
        i = 0;
        while (i < arg.length) {
            try {
                servers[i].join();
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
            }
            ++i;
        }
    }

    private static class ShutdownHookThread
    extends Thread {
        private boolean hooked = false;
        private ArrayList servers = new ArrayList();

        private ShutdownHookThread() {
        }

        private void createShutdownHook() {
            block3: {
                if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK") && !this.hooked) {
                    try {
                        Method shutdownHook = Runtime.class.getMethod("addShutdownHook", Thread.class);
                        shutdownHook.invoke((Object)Runtime.getRuntime(), this);
                        this.hooked = true;
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block3;
                        log.debug((Object)"No shutdown hook in JVM ", (Throwable)e);
                    }
                }
            }
        }

        public boolean add(Server server) {
            this.createShutdownHook();
            return this.servers.add(server);
        }

        public boolean contains(Server server) {
            return this.servers.contains(server);
        }

        public boolean addAll(Collection c) {
            this.createShutdownHook();
            return this.servers.addAll(c);
        }

        public void clear() {
            this.createShutdownHook();
            this.servers.clear();
        }

        public boolean remove(Server server) {
            this.createShutdownHook();
            return this.servers.remove(server);
        }

        public boolean removeAll(Collection c) {
            this.createShutdownHook();
            return this.servers.removeAll(c);
        }

        @Override
        public void run() {
            this.setName("Shutdown");
            log.info((Object)"Shutdown hook executing");
            for (Server svr : this.servers) {
                if (svr == null) continue;
                try {
                    svr.stop();
                }
                catch (Exception e) {
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                }
                log.info((Object)"Shutdown hook complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                }
            }
        }
    }
}

