/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.util;

public class BlockingQueue {
    Object[] elements;
    Object lock;
    int maxSize;
    int size = 0;
    int head = 0;
    int tail = 0;

    public BlockingQueue(int maxSize) {
        this(null, maxSize);
    }

    public BlockingQueue(Object lock, int maxSize) {
        this.maxSize = maxSize;
        if (maxSize == 0) {
            this.maxSize = 255;
        }
        this.elements = new Object[this.maxSize];
        this.lock = lock == null ? this.elements : lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.size = 0;
            this.head = 0;
            this.tail = 0;
        }
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object o) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size == this.maxSize) {
                this.lock.wait();
            }
            this.elements[this.tail] = o;
            if (++this.tail == this.maxSize) {
                this.tail = 0;
            }
            ++this.size;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object o, int timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size == this.maxSize) {
                this.lock.wait(timeout);
                if (this.size == this.maxSize) {
                    throw new InterruptedException("Timed out");
                }
            }
            this.elements[this.tail] = o;
            if (++this.tail == this.maxSize) {
                this.tail = 0;
            }
            ++this.size;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size == 0) {
                this.lock.wait();
            }
            Object o = this.elements[this.head];
            this.elements[this.head] = null;
            if (++this.head == this.maxSize) {
                this.head = 0;
            }
            if (this.size == this.maxSize) {
                this.lock.notifyAll();
            }
            --this.size;
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int timeoutMs) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            block7: {
                if (this.size == 0 && timeoutMs != 0) {
                    this.lock.wait(timeoutMs);
                }
                if (this.size != 0) break block7;
                return null;
            }
            Object o = this.elements[this.head];
            this.elements[this.head] = null;
            if (++this.head == this.maxSize) {
                this.head = 0;
            }
            if (this.size == this.maxSize) {
                this.lock.notifyAll();
            }
            --this.size;
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.size == 0) {
                    this.lock.wait();
                }
                if (this.size != 0) break block5;
                return null;
            }
            Object o = this.elements[this.head];
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(int timeoutMs) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.size == 0) {
                    this.lock.wait(timeoutMs);
                }
                if (this.size != 0) break block5;
                return null;
            }
            Object o = this.elements[this.head];
            return o;
        }
    }
}

