/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import net.lightbody.bmp.proxy.jetty.util.Loader;
import net.lightbody.bmp.proxy.jetty.util.LogSupport;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import net.lightbody.bmp.proxy.jetty.util.TypeUtil;
import net.lightbody.bmp.proxy.jetty.xml.XmlParser;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration {
    private static Log log = LogFactory.getLog(XmlConfiguration.class);
    private static Class[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static Class[] __primitiveHolders = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static XmlParser __parser;
    private XmlParser.Node _config;
    private Map _idMap = new HashMap();

    private static synchronized void initParser() throws IOException {
        if (__parser != null) {
            return;
        }
        __parser = new XmlParser();
        URL config13URL = XmlConfiguration.class.getClassLoader().getResource("net/lightbody/bmp/proxy/jetty/xml/configure_1_3.dtd");
        __parser.redirectEntity("configure.dtd", config13URL);
        __parser.redirectEntity("configure_1_3.dtd", config13URL);
        __parser.redirectEntity("http://jetty.jetty.org/configure_1_3.dtd", config13URL);
        __parser.redirectEntity("http://jetty.jetty.org/configure.dtd", config13URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.3//EN", config13URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", config13URL);
        URL config12URL = XmlConfiguration.class.getClassLoader().getResource("net/lightbody/bmp/proxy/jetty/xml/configure_1_2.dtd");
        __parser.redirectEntity("configure_1_2.dtd", config12URL);
        __parser.redirectEntity("http://jetty.jetty.org/configure_1_2.dtd", config12URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.2//EN", config12URL);
        URL config11URL = XmlConfiguration.class.getClassLoader().getResource("net/lightbody/bmp/proxy/jetty/xml/configure_1_1.dtd");
        __parser.redirectEntity("configure_1_1.dtd", config11URL);
        __parser.redirectEntity("http://jetty.jetty.org/configure_1_1.dtd", config11URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.1//EN", config11URL);
        URL config10URL = XmlConfiguration.class.getClassLoader().getResource("net/lightbody/bmp/proxy/jetty/xml/configure_1_0.dtd");
        __parser.redirectEntity("configure_1_0.dtd", config10URL);
        __parser.redirectEntity("http://jetty.jetty.org/configure_1_0.dtd", config10URL);
        __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure 1.0//EN", config10URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(URL configuration) throws SAXException, IOException {
        XmlConfiguration.initParser();
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(configuration.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(String configuration) throws SAXException, IOException {
        XmlConfiguration.initParser();
        configuration = "<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n<!DOCTYPE Configure PUBLIC \"-//Mort Bay Consulting//DTD Configure 1.2//EN\" \"http://jetty.jetty.org/configure_1_2.dtd\">" + configuration;
        InputSource source = new InputSource(new StringReader(configuration));
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(InputStream configuration) throws SAXException, IOException {
        XmlConfiguration.initParser();
        InputSource source = new InputSource(configuration);
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._config = __parser.parse(source);
        }
    }

    public void configure(Object obj) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class oClass = this.nodeClass(this._config);
        if (oClass != null) {
            if (obj != null && !oClass.isInstance(obj)) {
                throw new IllegalArgumentException("Object is not of type " + oClass);
            }
            if (obj == null) {
                obj = oClass.newInstance();
            }
        }
        this.configure(obj, this._config, 0);
    }

    public Object newInstance() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class oClass = this.nodeClass(this._config);
        Object obj = null;
        if (oClass != null) {
            obj = oClass.newInstance();
        }
        this.configure(obj, this._config, 0);
        return obj;
    }

    private Class nodeClass(XmlParser.Node node) throws ClassNotFoundException {
        String className = node.getAttribute("class");
        if (className == null) {
            return null;
        }
        return Loader.loadClass(XmlConfiguration.class, className);
    }

    private void configure(Object obj, XmlParser.Node cfg, int i) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        block21: {
            XmlParser.Node node = null;
            try {
                while (i < cfg.size()) {
                    Object o = cfg.get(i);
                    if (!(o instanceof String)) {
                        node = (XmlParser.Node)o;
                        String tag = node.getTag();
                        if ("Set".equals(tag)) {
                            this.set(obj, node);
                        } else if ("Put".equals(tag)) {
                            this.put(obj, node);
                        } else if ("Call".equals(tag)) {
                            this.call(obj, node);
                        } else if ("Get".equals(tag)) {
                            this.get(obj, node);
                        } else if ("New".equals(tag)) {
                            this.newObj(obj, node);
                        } else if ("Ref".equals(tag)) {
                            this.refObj(obj, node);
                        } else {
                            throw new IllegalStateException("Unknown tag: " + tag);
                        }
                    }
                    ++i;
                }
            }
            catch (InvocationTargetException e) {
                log.warn((Object)("Exception at " + node.toString()), e.getTargetException());
                throw e;
            }
            catch (Error e) {
                log.debug(node);
                throw e;
            }
            catch (Exception e) {
                log.debug(node);
                if (e instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e;
                }
                if (e instanceof InvocationTargetException) {
                    throw (InvocationTargetException)e;
                }
                if (e instanceof IllegalAccessException) {
                    throw (IllegalAccessException)e;
                }
                if (!(e instanceof RuntimeException)) break block21;
                throw (RuntimeException)e;
            }
        }
    }

    private void set(Object obj, XmlParser.Node node) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String attr = node.getAttribute("name");
        String name = "set" + attr.substring(0, 1).toUpperCase() + attr.substring(1);
        Object value = this.value(obj, node);
        Object[] arg = new Object[]{value};
        Class<?> oClass = this.nodeClass(node);
        if (oClass != null) {
            obj = null;
        } else {
            oClass = obj.getClass();
        }
        Class[] vClass = new Class[]{Object.class};
        if (value != null) {
            vClass[0] = value.getClass();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(obj + "." + name + "(" + vClass[0] + " " + value + ")"));
        }
        try {
            Method set = oClass.getMethod(name, vClass);
            set.invoke(obj, arg);
            return;
        }
        catch (IllegalArgumentException e) {
            LogSupport.ignore(log, e);
        }
        catch (IllegalAccessException e) {
            LogSupport.ignore(log, e);
        }
        catch (NoSuchMethodException e) {
            LogSupport.ignore(log, e);
        }
        try {
            Field type = vClass[0].getField("TYPE");
            vClass[0] = (Class)type.get(null);
            Method set = oClass.getMethod(name, vClass);
            set.invoke(obj, arg);
            return;
        }
        catch (NoSuchFieldException e) {
            LogSupport.ignore(log, e);
        }
        catch (IllegalArgumentException e) {
            LogSupport.ignore(log, e);
        }
        catch (IllegalAccessException e) {
            LogSupport.ignore(log, e);
        }
        catch (NoSuchMethodException e) {
            LogSupport.ignore(log, e);
        }
        try {
            Field field = oClass.getField(attr);
            if (Modifier.isPublic(field.getModifiers())) {
                field.set(obj, value);
                return;
            }
        }
        catch (NoSuchFieldException e) {
            LogSupport.ignore(log, e);
        }
        Method[] sets = oClass.getMethods();
        Method set = null;
        int s = 0;
        while (sets != null && s < sets.length) {
            if (name.equals(sets[s].getName()) && sets[s].getParameterTypes().length == 1) {
                try {
                    set = sets[s];
                    sets[s].invoke(obj, arg);
                    return;
                }
                catch (IllegalArgumentException e) {
                    LogSupport.ignore(log, e);
                }
                catch (IllegalAccessException e) {
                    LogSupport.ignore(log, e);
                }
            }
            ++s;
        }
        if (set != null) {
            try {
                Class sClass = set.getParameterTypes()[0];
                if (sClass.isPrimitive()) {
                    int t = 0;
                    while (t < __primitives.length) {
                        if (sClass.equals(__primitives[t])) {
                            sClass = __primitiveHolders[t];
                            break;
                        }
                        ++t;
                    }
                }
                Constructor<?> cons = sClass.getConstructor(vClass);
                arg[0] = cons.newInstance(arg);
                set.invoke(obj, arg);
                return;
            }
            catch (NoSuchMethodException e) {
                LogSupport.ignore(log, e);
            }
            catch (IllegalAccessException e) {
                LogSupport.ignore(log, e);
            }
            catch (InstantiationException e) {
                LogSupport.ignore(log, e);
            }
        }
        throw new NoSuchMethodException(oClass + "." + name + "(" + vClass[0] + ")");
    }

    private void put(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        if (!(obj instanceof Map)) {
            throw new IllegalArgumentException("Object for put is not a Map: " + obj);
        }
        Map map = (Map)obj;
        String name = node.getAttribute("name");
        Object value = this.value(obj, node);
        map.put(name, value);
        if (log.isDebugEnabled()) {
            log.debug((Object)(obj + ".put(" + name + "+" + value + ")"));
        }
    }

    private Object get(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class<?> oClass = this.nodeClass(node);
        if (oClass != null) {
            obj = null;
        } else {
            oClass = obj.getClass();
        }
        String name = node.getAttribute("name");
        String id = node.getAttribute("id");
        if (log.isDebugEnabled()) {
            log.debug((Object)("get " + name));
        }
        try {
            Method method = oClass.getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), null);
            obj = method.invoke(obj, null);
            this.configure(obj, node, 0);
        }
        catch (NoSuchMethodException nsme) {
            try {
                Field field = oClass.getField(name);
                obj = field.get(obj);
                this.configure(obj, node, 0);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw nsme;
            }
        }
        if (id != null) {
            this._idMap.put(id, obj);
        }
        return obj;
    }

    private Object call(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        String id = node.getAttribute("id");
        Class<?> oClass = this.nodeClass(node);
        if (oClass != null) {
            obj = null;
        } else if (obj != null) {
            oClass = obj.getClass();
        }
        if (oClass == null) {
            throw new IllegalArgumentException(node.toString());
        }
        int size = 0;
        int argi = node.size();
        int i = 0;
        while (i < node.size()) {
            Object o = node.get(i);
            if (!(o instanceof String)) {
                if (!((XmlParser.Node)o).getTag().equals("Arg")) {
                    argi = i;
                    break;
                }
                ++size;
            }
            ++i;
        }
        Object[] arg = new Object[size];
        int i2 = 0;
        int j = 0;
        while (j < size) {
            Object o = node.get(i2);
            if (!(o instanceof String)) {
                arg[j++] = this.value(obj, (XmlParser.Node)o);
            }
            ++i2;
        }
        String method = node.getAttribute("name");
        if (log.isDebugEnabled()) {
            log.debug((Object)("call " + method));
        }
        Method[] methods = oClass.getMethods();
        int c = 0;
        while (methods != null && c < methods.length) {
            if (methods[c].getName().equals(method) && methods[c].getParameterTypes().length == size && Modifier.isStatic(methods[c].getModifiers()) == (obj == null) && (obj != null || methods[c].getDeclaringClass() == oClass)) {
                Object n = null;
                boolean called = false;
                try {
                    n = methods[c].invoke(obj, arg);
                    called = true;
                }
                catch (IllegalAccessException e) {
                    LogSupport.ignore(log, e);
                }
                catch (IllegalArgumentException e) {
                    LogSupport.ignore(log, e);
                }
                if (called) {
                    if (id != null) {
                        this._idMap.put(id, n);
                    }
                    this.configure(n, node, argi);
                    return n;
                }
            }
            ++c;
        }
        throw new IllegalStateException("No Method: " + node + " on " + oClass);
    }

    private Object newObj(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class oClass = this.nodeClass(node);
        String id = node.getAttribute("id");
        int size = 0;
        int argi = node.size();
        int i = 0;
        while (i < node.size()) {
            Object o = node.get(i);
            if (!(o instanceof String)) {
                if (!((XmlParser.Node)o).getTag().equals("Arg")) {
                    argi = i;
                    break;
                }
                ++size;
            }
            ++i;
        }
        Object[] arg = new Object[size];
        int i2 = 0;
        int j = 0;
        while (j < size) {
            Object o = node.get(i2);
            if (!(o instanceof String)) {
                arg[j++] = this.value(obj, (XmlParser.Node)o);
            }
            ++i2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new " + oClass));
        }
        Constructor<?>[] constructors = oClass.getConstructors();
        int c = 0;
        while (constructors != null && c < constructors.length) {
            if (constructors[c].getParameterTypes().length == size) {
                Object n = null;
                boolean called = false;
                try {
                    n = constructors[c].newInstance(arg);
                    called = true;
                }
                catch (IllegalAccessException e) {
                    LogSupport.ignore(log, e);
                }
                catch (InstantiationException e) {
                    LogSupport.ignore(log, e);
                }
                catch (IllegalArgumentException e) {
                    LogSupport.ignore(log, e);
                }
                if (called) {
                    if (id != null) {
                        this._idMap.put(id, n);
                    }
                    this.configure(n, node, argi);
                    return n;
                }
            }
            ++c;
        }
        throw new IllegalStateException("No Constructor: " + node + " on " + obj);
    }

    private Object refObj(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        String id = node.getAttribute("id");
        obj = this._idMap.get(id);
        if (obj == null) {
            throw new IllegalStateException("No object for id=" + id);
        }
        this.configure(obj, node, 0);
        return obj;
    }

    private Object newArray(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class aClass = Object.class;
        String type = node.getAttribute("type");
        String id = node.getAttribute("id");
        if (type != null && (aClass = TypeUtil.fromName(type)) == null) {
            aClass = "String".equals(type) ? String.class : ("URL".equals(type) ? URL.class : ("InetAddress".equals(type) ? InetAddress.class : ("InetAddrPort".equals(type) ? InetAddrPort.class : Loader.loadClass(XmlConfiguration.class, type))));
        }
        Object array = Array.newInstance(aClass, node.size());
        if (id != null) {
            this._idMap.put(id, obj);
        }
        int i = 0;
        while (i < node.size()) {
            Object o = node.get(i);
            if (!(o instanceof String)) {
                XmlParser.Node item = (XmlParser.Node)o;
                if (!item.getTag().equals("Item")) {
                    throw new IllegalStateException("Not an Item");
                }
                id = item.getAttribute("id");
                Object v = this.value(obj, item);
                if (v != null) {
                    Array.set(array, i, v);
                }
                if (id != null) {
                    this._idMap.put(id, v);
                }
            }
            ++i;
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object value(Object obj, XmlParser.Node node) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Object value = null;
        String type = node.getAttribute("type");
        String ref = node.getAttribute("ref");
        if (ref != null) {
            value = this._idMap.get(ref);
        } else {
            if (node.size() == 0) {
                if ("String".equals(type)) {
                    return "";
                }
                return null;
            }
            int first = 0;
            int last = node.size() - 1;
            if (type == null || !"String".equals(type)) {
                Object item = null;
                while (first <= last) {
                    item = node.get(first);
                    if (!(item instanceof String) || ((String)(item = ((String)item).trim())).length() > 0) break;
                    ++first;
                }
                while (first < last) {
                    item = node.get(last);
                    if (!(item instanceof String) || ((String)(item = ((String)item).trim())).length() > 0) break;
                    --last;
                }
                if (first > last) {
                    return null;
                }
            }
            if (first == last) {
                value = this.itemValue(obj, node.get(first));
            } else {
                StringBuffer buf;
                StringBuffer stringBuffer = buf = new StringBuffer();
                synchronized (stringBuffer) {
                    int i = first;
                    while (i <= last) {
                        Object item = node.get(i);
                        buf.append(this.itemValue(obj, item));
                        ++i;
                    }
                    value = buf.toString();
                }
            }
        }
        if (value == null) {
            if ("String".equals(type)) {
                return "";
            }
            return null;
        }
        if (type == null) {
            if (value != null && value instanceof String) {
                return ((String)value).trim();
            }
            return value;
        }
        if ("String".equals(type) || "java.lang.String".equals(type)) {
            return value.toString();
        }
        Class pClass = TypeUtil.fromName(type);
        if (pClass != null) {
            return TypeUtil.valueOf(pClass, value.toString());
        }
        if ("URL".equals(type) || "java.net.URL".equals(type)) {
            if (value instanceof URL) {
                return value;
            }
            try {
                return new URL(value.toString());
            }
            catch (MalformedURLException e) {
                throw new InvocationTargetException(e);
            }
        }
        if ("InetAddress".equals(type) || "java.net.InetAddress".equals(type)) {
            if (value instanceof InetAddress) {
                return value;
            }
            try {
                return InetAddress.getByName(value.toString());
            }
            catch (UnknownHostException e) {
                throw new InvocationTargetException(e);
            }
        }
        if ("InetAddrPort".equals(type) || "InetAddrPort".equals(type)) {
            if (value instanceof InetAddrPort) {
                return value;
            }
            try {
                return new InetAddrPort(value.toString());
            }
            catch (UnknownHostException e) {
                throw new InvocationTargetException(e);
            }
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    private Object itemValue(Object obj, Object item) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        if (item instanceof String) {
            return item;
        }
        XmlParser.Node node = (XmlParser.Node)item;
        String tag = node.getTag();
        if ("Call".equals(tag)) {
            return this.call(obj, node);
        }
        if ("Get".equals(tag)) {
            return this.get(obj, node);
        }
        if ("New".equals(tag)) {
            return this.newObj(obj, node);
        }
        if ("Ref".equals(tag)) {
            return this.refObj(obj, node);
        }
        if ("Array".equals(tag)) {
            return this.newArray(obj, node);
        }
        if ("SystemProperty".equals(tag)) {
            String name = node.getAttribute("name");
            String defaultValue = node.getAttribute("default");
            return System.getProperty(name, defaultValue);
        }
        log.warn((Object)("Unknown value tag: " + node), new Throwable());
        return null;
    }

    public static void main(String[] arg) {
        try {
            int i = 0;
            while (i < arg.length) {
                new XmlConfiguration(Resource.newResource(arg[i]).getURL()).newInstance();
                ++i;
            }
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }
}

