/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.selenium;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import net.lightbody.bmp.mitm.keys.RSAKeyGenerator;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.selenium.ServerCertificateCreator;
import net.lightbody.bmp.proxy.selenium.ThumbprintUtil;
import org.apache.commons.logging.Log;

public class KeyStoreManager {
    static Log log = LogFactory.getLog(KeyStoreManager.class);
    private final String CERTMAP_SER_FILE = "certmap.ser";
    private final String SUBJMAP_SER_FILE = "subjmap.ser";
    private final char[] _keypassword = "password".toCharArray();
    private final char[] _keystorepass = "password".toCharArray();
    private final String _caPrivateKeystore = "ca-keystore-rsa.p12";
    public static final String _caPrivKeyAlias = "key";
    X509Certificate _caCert;
    PrivateKey _caPrivKey;
    KeyStore _ks;
    private HashMap<PublicKey, PrivateKey> _rememberedPrivateKeys;
    private HashMap<PublicKey, PublicKey> _mappedPublicKeys;
    private HashMap<String, String> _certMap;
    private HashMap<String, String> hostnameThumbprintMap;
    private final String KEYMAP_SER_FILE = "keymap.ser";
    private final String PUB_KEYMAP_SER_FILE = "pubkeymap.ser";
    public final String RSA_KEYGEN_ALGO = "RSA";
    public final String DSA_KEYGEN_ALGO = "DSA";
    private boolean persistImmediately = true;
    private File root;

    public KeyStoreManager(File root) {
        File file;
        ObjectInputStream in;
        this.root = root;
        try {
            File privKeys = new File(root, "keymap.ser");
            if (!privKeys.exists()) {
                this._rememberedPrivateKeys = new HashMap();
            } else {
                in = new ObjectInputStream(new FileInputStream(privKeys));
                this._rememberedPrivateKeys = (HashMap)in.readObject();
                in.close();
            }
            File pubKeys = new File(root, "pubkeymap.ser");
            if (!pubKeys.exists()) {
                this._mappedPublicKeys = new HashMap();
            } else {
                ObjectInputStream in2 = new ObjectInputStream(new FileInputStream(pubKeys));
                this._mappedPublicKeys = (HashMap)in2.readObject();
                in2.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        try {
            this._ks = KeyStore.getInstance("PKCS12");
            this.reloadKeystore();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                this.createKeystore();
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        try {
            file = new File(root, "certmap.ser");
            if (!file.exists()) {
                this._certMap = new HashMap();
            } else {
                in = new ObjectInputStream(new FileInputStream(file));
                this._certMap = (HashMap)in.readObject();
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        try {
            file = new File(root, "subjmap.ser");
            if (!file.exists()) {
                this.hostnameThumbprintMap = new HashMap();
            } else {
                in = new ObjectInputStream(new FileInputStream(file));
                this.hostnameThumbprintMap = (HashMap)in.readObject();
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private void reloadKeystore() throws FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableEntryException {
        FileInputStream is = new FileInputStream(new File(this.root, "ca-keystore-rsa.p12"));
        this._ks.load(is, this._keystorepass);
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this._ks.getEntry(_caPrivKeyAlias, new KeyStore.PasswordProtection(this._keypassword));
        this._caCert = (X509Certificate)privateKeyEntry.getCertificate();
        this._caPrivKey = privateKeyEntry.getPrivateKey();
    }

    protected void createKeystore() {
        if (this._caCert == null || this._caPrivKey == null) {
            throw new RuntimeException("Legacy ProxyServer implementation does not support dynamic CA generation");
        }
        log.debug((Object)"Successfully loaded keystore.");
        log.debug((Object)this._caCert);
    }

    public synchronized void addCertAndPrivateKey(String hostname, X509Certificate cert, PrivateKey privKey) throws KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try {
            this._ks.deleteEntry(hostname);
        }
        catch (KeyStoreException keyStoreException) {}
        this._ks.setKeyEntry(hostname, privKey, this._keypassword, new Certificate[]{cert, this.getSigningCert()});
        if (this.persistImmediately) {
            this.persist();
        }
    }

    public synchronized void persist() throws KeyStoreException, NoSuchAlgorithmException, CertificateException {
        try {
            FileOutputStream kso = new FileOutputStream(new File(this.root, "ca-keystore-rsa.p12"));
            this._ks.store(kso, this._keystorepass);
            kso.flush();
            kso.close();
            this.persistCertMap();
            this.persistSubjectMap();
            this.persistKeyPairMap();
            this.persistPublicKeyMap();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public synchronized X509Certificate getCertificateByAlias(String alias) throws KeyStoreException {
        return (X509Certificate)this._ks.getCertificate(alias);
    }

    public synchronized X509Certificate getCertificateByHostname(String hostname) throws KeyStoreException, CertificateParsingException, InvalidKeyException, CertificateExpiredException, CertificateNotYetValidException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        String alias = this.hostnameThumbprintMap.get(hostname);
        if (alias != null) {
            return (X509Certificate)this._ks.getCertificate(alias);
        }
        return this.getMappedCertificateForHostname(hostname);
    }

    public synchronized X509Certificate getSigningCert() throws KeyStoreException {
        return this._caCert;
    }

    public synchronized PrivateKey getSigningPrivateKey() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this._caPrivKey;
    }

    public boolean getPersistImmediately() {
        return this.persistImmediately;
    }

    public void setPersistImmediately(boolean persistImmediately) {
        this.persistImmediately = persistImmediately;
    }

    public X509Certificate getMappedCertificateForHostname(String hostname) throws CertificateParsingException, InvalidKeyException, CertificateExpiredException, CertificateNotYetValidException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException {
        String thumbprint = this.hostnameThumbprintMap.get(hostname);
        if (thumbprint == null) {
            KeyPair kp = new RSAKeyGenerator().generate();
            X509Certificate newCert = ServerCertificateCreator.generateStdSSLServerCertificate(kp, this.getSigningCert(), this.getSigningPrivateKey(), hostname);
            this.addCertAndPrivateKey(hostname, newCert, kp.getPrivate());
            thumbprint = ThumbprintUtil.getThumbprint(newCert);
            this.hostnameThumbprintMap.put(hostname, thumbprint);
            if (this.persistImmediately) {
                this.persist();
            }
            return newCert;
        }
        return this.getCertificateByAlias(thumbprint);
    }

    private synchronized void persistCertMap() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.root, "certmap.ser")));
            out.writeObject(this._certMap);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private synchronized void persistSubjectMap() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.root, "subjmap.ser")));
            out.writeObject(this.hostnameThumbprintMap);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    public synchronized PrivateKey getPrivateKeyForLocalCert(X509Certificate cert) throws CertificateEncodingException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        String thumbprint = ThumbprintUtil.getThumbprint(cert);
        return (PrivateKey)this._ks.getKey(thumbprint, this._keypassword);
    }

    private synchronized void persistPublicKeyMap() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.root, "pubkeymap.ser")));
            out.writeObject(this._mappedPublicKeys);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private synchronized void persistKeyPairMap() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.root, "keymap.ser")));
            out.writeObject(this._rememberedPrivateKeys);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private synchronized void rememberKeyPair(KeyPair kp) {
        this._rememberedPrivateKeys.put(kp.getPublic(), kp.getPrivate());
        if (this.persistImmediately) {
            this.persistKeyPairMap();
        }
    }

    public synchronized void mapPublicKeys(PublicKey original, PublicKey substitute) {
        this._mappedPublicKeys.put(original, substitute);
        if (this.persistImmediately) {
            this.persistPublicKeyMap();
        }
    }

    public synchronized PublicKey getMappedPublicKey(PublicKey original) {
        return this._mappedPublicKeys.get(original);
    }

    public synchronized PrivateKey getPrivateKey(PublicKey pk) {
        return this._rememberedPrivateKeys.get(pk);
    }

    public KeyStore getKeyStore() {
        return this._ks;
    }
}

