/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.util;

import java.io.ByteArrayOutputStream;

public class CappedByteArrayOutputStream
extends ByteArrayOutputStream {
    private int maxBytes;
    private boolean writeable = true;

    public CappedByteArrayOutputStream(int maxBytes) {
        this.maxBytes = maxBytes;
    }

    @Override
    public void write(int b) {
        if (this.writeable) {
            super.write(b);
            this.checkWritable();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.writeable) {
            super.write(b, off, len);
            this.checkWritable();
        }
    }

    private void checkWritable() {
        if (this.count > this.maxBytes) {
            this.writeable = false;
        }
    }
}

