/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDirectoryTask
implements Runnable {
    private final Path directory;

    public DeleteDirectoryTask(Path directory) {
        this.directory = directory;
    }

    @Override
    public void run() {
        try {
            Files.walkFileTree(this.directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        LogHolder.log.warn("Unable to delete file or directory", (Throwable)e);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException e) {
                        LogHolder.log.warn("Unable to delete file or directory", (Throwable)e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LogHolder.log.warn("Unable to delete file or directory", (Throwable)e);
        }
    }

    private static class LogHolder {
        private static final Logger log = LoggerFactory.getLogger(DeleteDirectoryTask.class);

        private LogHolder() {
        }
    }
}

