/*
 * Decompiled with CFR 0.152.
 */
package org.java_bandwidthlimiter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.java_bandwidthlimiter.BandwidthLimiter;
import org.java_bandwidthlimiter.MaximumTransferExceededException;

public class StreamManager
implements BandwidthLimiter {
    private double actualPayloadPercentage = 0.95;
    private boolean enabled = false;
    private long maxBytesPerSecond;
    private final StreamParams downStream = new StreamParams();
    private final StreamParams upStream = new StreamParams();
    private long latency = 0L;
    private final Random randomGenerator = new Random();

    public StreamManager(long maxBitsPerSecond) {
        this.maxBytesPerSecond = maxBitsPerSecond / 8L;
        this.setMaxBps(this.downStream, this.maxBytesPerSecond);
        this.setMaxBps(this.upStream, this.maxBytesPerSecond);
        this.actualPayloadPercentage = 0.95;
        this.setMaxBytes(this.downStream, 0L);
        this.setMaxBytes(this.upStream, 0L);
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    @Override
    public void setDownstreamKbps(long downstreamKbps) {
        long bytesPerSecond = downstreamKbps * 1000L / 8L;
        this.setMaxBps(this.downStream, bytesPerSecond);
    }

    @Override
    public void setUpstreamKbps(long upstreamKbps) {
        long bytesPerSecond = upstreamKbps * 1000L / 8L;
        this.setMaxBps(this.upStream, bytesPerSecond);
    }

    @Override
    public void setLatency(long latency) {
        this.latency = latency;
    }

    @Override
    public void setDownstreamMaxKB(long downstreamMaxKB) {
        this.setMaxBytes(this.downStream, downstreamMaxKB * 1000L);
    }

    @Override
    public void setUpstreamMaxKB(long upstreamMaxKB) {
        this.setMaxBytes(this.upStream, upstreamMaxKB * 1000L);
    }

    public long getLatency() {
        return this.latency;
    }

    public void setPayloadPercentage(int payloadPercentage) {
        if (payloadPercentage <= 0 || payloadPercentage > 100) {
            payloadPercentage = 95;
        }
        this.actualPayloadPercentage = (double)payloadPercentage / 100.0;
        this.setMaxBps(this.downStream, this.downStream.maxBps);
        this.setMaxBps(this.upStream, this.upStream.maxBps);
    }

    public InputStream registerStream(InputStream in) {
        return new ManagedInputStream(in, this);
    }

    public OutputStream registerStream(OutputStream out) {
        return new ManagedOutputStream(out, this);
    }

    public void setMaxBitsPerSecondThreshold(long maxBitsPerSecond) {
        this.maxBytesPerSecond = maxBitsPerSecond / 8L;
        this.setMaxBps(this.downStream, this.downStream.maxBps);
        this.setMaxBps(this.upStream, this.upStream.maxBps);
    }

    public long getMaxUpstreamKB() {
        return this.upStream.maxBytes / 1000L;
    }

    public long getRemainingUpstreamKB() {
        return this.upStream.remainingBytes / 1000L;
    }

    public long getMaxDownstreamKB() {
        return this.downStream.maxBytes / 1000L;
    }

    public long getRemainingDownstreamKB() {
        return this.downStream.remainingBytes / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaxBps(StreamParams direction, long maxBps) {
        StreamParams streamParams = direction;
        synchronized (streamParams) {
            direction.maxBps = Math.min(this.maxBytesPerSecond, maxBps);
            direction.adjustedMaxBps = (long)((double)direction.maxBps * this.actualPayloadPercentage);
            direction.nextResetSubIntervals = 2L;
            direction.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaxBytes(StreamParams direction, long maxBytes) {
        StreamParams streamParams = direction;
        synchronized (streamParams) {
            direction.maxBytes = maxBytes;
            direction.remainingBytes = maxBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long timeToNextReset(StreamParams direction) {
        StreamParams streamParams = direction;
        synchronized (streamParams) {
            return direction.timeToNextReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounterIfNecessary(StreamParams direction) {
        StreamParams streamParams = direction;
        synchronized (streamParams) {
            if (direction.timeToNextReset() < 0L) {
                direction.reset();
            }
        }
    }

    private int getAllowedBytesRead(ManagedInputStream stream, int bufferLength) {
        return this.getAllowedBytesUnFair(this.downStream, bufferLength);
    }

    private int getAllowedBytesWrite(ManagedOutputStream stream, int bufferLength) {
        return this.getAllowedBytesUnFair(this.upStream, bufferLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAllowedBytesUnFair(StreamParams direction, int bufferLength) {
        int allowed;
        StreamParams streamParams = direction;
        synchronized (streamParams) {
            this.resetCounterIfNecessary(direction);
            allowed = (long)bufferLength > direction.remainingBps ? (int)direction.remainingBps : bufferLength;
            direction.remainingBps -= (long)allowed;
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustBytes(StreamParams direction, long adjustBy) {
        StreamParams streamParams = direction;
        synchronized (streamParams) {
            direction.adjustBytes(adjustBy);
        }
    }

    private int manageRead(ManagedInputStream stream, byte[] b, int off, int len) throws IOException {
        if (!this.enabled) {
            return stream.doRead(b, off, len);
        }
        assert (this.maxBytesPerSecond > 0L);
        int allowed = this.getAllowedBytesRead(stream, len);
        if (allowed > 0) {
            int bytesRead = stream.doRead(b, off, allowed);
            if (this.downStream.maxBytes > 0L && (this.downStream.remainingBytes -= (long)bytesRead) < 0L) {
                throw new MaximumTransferExceededException(this.getMaxDownstreamKB(), false);
            }
            this.adjustBytes(this.downStream, allowed - bytesRead);
            return bytesRead;
        }
        long sleepTime = this.timeToNextReset(this.downStream);
        if (sleepTime > 0L) {
            StreamManager.threadSleep(sleepTime += (long)this.randomGenerator.nextInt(21));
        }
        return 0;
    }

    private void manageWrite(ManagedOutputStream stream, byte[] b, int off, int len) throws IOException {
        if (!this.enabled) {
            stream.doWrite(b, off, len);
        } else {
            assert (this.maxBytesPerSecond > 0L);
            int bytesWritten = 0;
            while (bytesWritten < len) {
                int allowed = this.getAllowedBytesWrite(stream, len);
                if (allowed > 0) {
                    stream.doWrite(b, off, allowed);
                    bytesWritten += allowed;
                    if (this.upStream.maxBytes <= 0L || (this.upStream.remainingBytes -= (long)allowed) >= 0L) continue;
                    throw new MaximumTransferExceededException(this.getMaxUpstreamKB(), true);
                }
                long sleepTime = this.timeToNextReset(this.upStream);
                if (sleepTime <= 0L) continue;
                StreamManager.threadSleep(sleepTime += (long)this.randomGenerator.nextInt(11));
            }
        }
    }

    private static void threadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private class ManagedInputStream
    extends InputStream {
        InputStream stream;
        StreamManager manager;
        long lastActivity;
        boolean roundUp;
        private final byte[] oneByteBuff = new byte[1];

        public ManagedInputStream(InputStream stream, StreamManager manager) {
            assert (manager != null);
            assert (stream != null);
            this.stream = stream;
            this.manager = manager;
            this.lastActivity = System.currentTimeMillis() - 2L * StreamManager.this.latency;
        }

        public InputStream getWrappedStream() {
            return this.stream;
        }

        public long getLastActivity() {
            return this.lastActivity;
        }

        public boolean getRoundUp() {
            this.roundUp = !this.roundUp;
            return this.roundUp;
        }

        @Override
        public int read() throws IOException {
            this.read(this.oneByteBuff, 0, 1);
            return this.oneByteBuff[0];
        }

        @Override
        public int read(byte[] b) throws IOException {
            int length = b.length;
            int bytesRead = this.read(b, 0, length);
            return bytesRead;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int readBytes = this.manager.manageRead(this, b, off, len);
            if (readBytes > 0) {
                this.lastActivity = System.currentTimeMillis();
            }
            return readBytes;
        }

        public int doRead(byte[] b, int offset, int length) throws IOException {
            if (length <= 0) {
                return 0;
            }
            return this.stream.read(b, offset, length);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public void mark(int readLimit) {
            this.stream.mark(readLimit);
        }

        @Override
        public void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }

    private class ManagedOutputStream
    extends OutputStream {
        OutputStream stream;
        StreamManager manager;
        long lastActivity;
        boolean roundUp;
        private final byte[] oneByteBuff = new byte[1];

        public ManagedOutputStream(OutputStream stream, StreamManager manager) {
            assert (manager != null);
            assert (stream != null);
            this.stream = stream;
            this.manager = manager;
            this.lastActivity = System.currentTimeMillis() - 2L * StreamManager.this.latency;
        }

        public OutputStream getWrappedStream() {
            return this.stream;
        }

        public long getLastActivity() {
            return this.lastActivity;
        }

        public boolean getRoundUp() {
            this.roundUp = !this.roundUp;
            return this.roundUp;
        }

        @Override
        public void write(int b) throws IOException {
            this.oneByteBuff[0] = (byte)b;
            this.write(this.oneByteBuff, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.manager.manageWrite(this, b, off, len);
            this.lastActivity = System.currentTimeMillis();
        }

        public void doWrite(byte[] b, int offset, int length) throws IOException {
            if (length <= 0) {
                return;
            }
            this.stream.write(b, offset, length);
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }

    private class StreamParams {
        public long maxBps;
        public long adjustedMaxBps;
        public long remainingBps;
        public long nextResetTimestamp;
        public long nextResetSubIntervals;
        public long maxBytes;
        public long remainingBytes;

        private StreamParams() {
        }

        private long timeToNextReset() {
            return this.nextResetTimestamp - System.currentTimeMillis();
        }

        private void reset() {
            this.remainingBps = this.adjustedMaxBps / this.nextResetSubIntervals;
            this.nextResetTimestamp = System.currentTimeMillis() + 1000L / this.nextResetSubIntervals;
        }

        private void adjustBytes(long bytesNumber) {
            this.remainingBps = Math.min(this.remainingBps + bytesNumber, this.adjustedMaxBps / this.nextResetSubIntervals);
        }
    }
}

