/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsParameter {
    private Map<String, SequenceType> allowedOptions = new HashMap<String, SequenceType>(8);
    private Map<String, Sequence> defaultValues = new HashMap<String, Sequence>(8);
    private Map<String, Set<String>> allowedValues = new HashMap<String, Set<String>>(8);
    private String errorCodeForDisallowedValue;

    public void addAllowedOption(String name, SequenceType type) {
        this.allowedOptions.put(name, type);
    }

    public void addAllowedOption(String name, SequenceType type, Sequence defaultValue) {
        this.allowedOptions.put(name, type);
        if (defaultValue != null) {
            this.defaultValues.put(name, defaultValue);
        }
    }

    public void setAllowedValues(String name, String errorCode, String ... values) {
        HashSet<String> valueSet = new HashSet<String>(Arrays.asList(values));
        this.allowedValues.put(name, valueSet);
        this.errorCodeForDisallowedValue = errorCode;
    }

    public Map<String, Sequence> processSuppliedOptions(MapItem supplied, XPathContext context) throws XPathException {
        HashMap<String, Sequence> result = new HashMap<String, Sequence>();
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        for (Map.Entry<String, SequenceType> allowed : this.allowedOptions.entrySet()) {
            String key = allowed.getKey();
            SequenceType required = allowed.getValue();
            Sequence actual = supplied.get(new StringValue(key));
            if (actual != null) {
                if (!required.matches(actual, th)) {
                    RoleDiagnostic role = new RoleDiagnostic(15, key, 0);
                    role.setErrorCode("XPTY0004");
                    actual = th.applyFunctionConversionRules(actual, required, role, ExplicitLocation.UNKNOWN_LOCATION);
                }
                actual = SequenceTool.toGroundedValue(actual).reduce();
                Set<String> permitted = this.allowedValues.get(key);
                if (!(permitted == null || actual instanceof AtomicValue && permitted.contains(((AtomicValue)actual).getStringValue()))) {
                    String message = "Invalid option " + key + "=" + Err.depictSequence(actual) + ". Valid values are:";
                    int i = 0;
                    for (String v : permitted) {
                        message = message + (i++ == 0 ? " " : ", ") + v;
                    }
                    throw new XPathException(message, this.errorCodeForDisallowedValue);
                }
                result.put(key, actual);
                continue;
            }
            Sequence def = this.defaultValues.get(key);
            if (def == null) continue;
            result.put(key, def);
        }
        return result;
    }

    public Map<String, Sequence> getDefaultOptions() throws XPathException {
        HashMap<String, Sequence> result = new HashMap<String, Sequence>();
        for (Map.Entry<String, Sequence> entry : this.defaultValues.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

