/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.collection.AbstractSerializableCollectionDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedCollection<I, O>
extends AbstractSerializableCollectionDecorator {
    private static final long serialVersionUID = 8692300188161871514L;
    protected final Transformer<? super I, ? extends O> transformer;

    public static <I, O> Collection<O> decorate(Collection<I> coll, Transformer<? super I, ? extends O> transformer) {
        return new TransformedCollection<I, O>(coll, transformer);
    }

    protected TransformedCollection(Collection<I> coll, Transformer<? super I, ? extends O> transformer) {
        super(coll);
        if (transformer == null) {
            throw new IllegalArgumentException("Transformer must not be null");
        }
        this.transformer = transformer;
    }

    protected O transform(I object) {
        return this.transformer.transform(object);
    }

    protected Collection<O> transform(Collection<? extends I> coll) {
        ArrayList<O> list = new ArrayList<O>(coll.size());
        Iterator<I> it = coll.iterator();
        while (it.hasNext()) {
            list.add(this.transform(it.next()));
        }
        return list;
    }

    @Override
    public boolean add(Object object) {
        O transformed = this.transform(object);
        return this.getCollection().add(transformed);
    }

    public boolean addTyped(I object) {
        return this.add(object);
    }

    @Override
    public boolean addAll(Collection coll) {
        Collection<O> col2 = this.transform(coll);
        return this.getCollection().addAll(col2);
    }

    public boolean addAllTyped(Collection<? extends I> coll) {
        return this.addAll(coll);
    }
}

