/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.io.H2IOUtils;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SearchRow;

public abstract class AbstractH2LeafIO
extends BPlusLeafIO<GridH2SearchRow>
implements H2RowLinkIO {
    AbstractH2LeafIO(int type, int ver, int itemSize) {
        super(type, ver, itemSize);
    }

    public final void storeByOffset(long pageAddr, int off, GridH2SearchRow row) {
        GridH2Row row0 = (GridH2Row)row;
        H2IOUtils.storeRow(row0, pageAddr, off, this.storeMvccInfo());
    }

    public final void store(long dstPageAddr, int dstIdx, BPlusIO<GridH2SearchRow> srcIo, long srcPageAddr, int srcIdx) {
        assert (srcIo == this);
        H2IOUtils.store(dstPageAddr, this.offset(dstIdx), srcIo, srcPageAddr, srcIdx, this.storeMvccInfo());
    }

    public final GridH2SearchRow getLookupRow(BPlusTree<GridH2SearchRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long link = this.getLink(pageAddr, idx);
        if (this.storeMvccInfo()) {
            long mvccCrdVer = this.getMvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = this.getMvccCounter(pageAddr, idx);
            int mvccOpCntr = this.getMvccOperationCounter(pageAddr, idx);
            return ((H2Tree)tree).createRowFromLink(link, mvccCrdVer, mvccCntr, mvccOpCntr);
        }
        return ((H2Tree)tree).createRowFromLink(link);
    }

    @Override
    public long getLink(long pageAddr, int idx) {
        return PageUtils.getLong((long)pageAddr, (int)this.offset(idx));
    }
}

