/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class Uuid5Evaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> namespace;

    public Uuid5Evaluator(Evaluator<String> subject, Evaluator<String> namespace) {
        this.subject = subject;
        this.namespace = namespace;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        String nsValue = this.namespace.evaluate(evaluationContext).getValue();
        UUID nsUUID = nsValue == null ? new UUID(0L, 0L) : UUID.fromString(nsValue);
        byte[] nsBytes = ByteBuffer.wrap(new byte[16]).putLong(nsUUID.getMostSignificantBits()).putLong(nsUUID.getLeastSignificantBits()).array();
        byte[] subjectBytes = subjectValue.getBytes();
        byte[] nameBytes = ArrayUtils.addAll((byte[])nsBytes, (byte[])subjectBytes);
        byte[] nameHash = DigestUtils.sha1((byte[])nameBytes);
        byte[] uuidBytes = Arrays.copyOf(nameHash, 16);
        uuidBytes[6] = (byte)(uuidBytes[6] & 0xF);
        uuidBytes[6] = (byte)(uuidBytes[6] | 0x50);
        uuidBytes[8] = (byte)(uuidBytes[8] & 0x3F);
        uuidBytes[8] = (byte)(uuidBytes[8] | 0x80);
        return new StringQueryResult(Uuid5Evaluator.toString(uuidBytes));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }

    private static String toString(byte[] uuid) {
        if (uuid == null) {
            return new UUID(0L, 0L).toString();
        }
        String encoded = Hex.encodeHexString((byte[])Objects.requireNonNull(uuid));
        StringBuffer sb = new StringBuffer(encoded);
        while (sb.length() != 32) {
            sb.insert(0, "0");
        }
        sb.ensureCapacity(32);
        sb.insert(8, '-');
        sb.insert(13, '-');
        sb.insert(18, '-');
        sb.insert(23, '-');
        return sb.toString();
    }
}

