/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.handler.sharding.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobShardingStrategy;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.impl.AverageAllocationJobShardingStrategy;

public final class RoundRobinByNameJobShardingStrategy
implements JobShardingStrategy {
    private final AverageAllocationJobShardingStrategy averageAllocationJobShardingStrategy = new AverageAllocationJobShardingStrategy();

    @Override
    public Map<JobInstance, List<Integer>> sharding(List<JobInstance> jobInstances, String jobName, int shardingTotalCount) {
        return this.averageAllocationJobShardingStrategy.sharding(this.rotateServerList(jobInstances, jobName), jobName, shardingTotalCount);
    }

    private List<JobInstance> rotateServerList(List<JobInstance> shardingUnits, String jobName) {
        int shardingUnitsSize = shardingUnits.size();
        int offset = Math.abs(jobName.hashCode()) % shardingUnitsSize;
        if (0 == offset) {
            return shardingUnits;
        }
        ArrayList<JobInstance> result = new ArrayList<JobInstance>(shardingUnitsSize);
        for (int i = 0; i < shardingUnitsSize; ++i) {
            int index = (i + offset) % shardingUnitsSize;
            result.add(shardingUnits.get(index));
        }
        return result;
    }

    @Override
    public String getType() {
        return "ROUND_ROBIN";
    }
}

