/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.condition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptEqualCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionBuilder;

public final class EncryptConditionEngine {
    private final EncryptRule encryptRule;
    private final PhysicalSchemaMetaData schemaMetaData;

    public List<EncryptCondition> createEncryptConditions(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptyList();
        }
        Optional whereSegment = ((WhereAvailable)sqlStatementContext).getWhere();
        if (!whereSegment.isPresent()) {
            return Collections.emptyList();
        }
        ExpressionSegment expression = ((WhereSegment)((WhereAvailable)sqlStatementContext).getWhere().get()).getExpr();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(expression);
        LinkedList andPredicates = new LinkedList(expressionBuilder.extractAndPredicates().getAndPredicates());
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        for (AndPredicate each : andPredicates) {
            result.addAll(this.createEncryptConditions(sqlStatementContext, each));
        }
        return result;
    }

    private Collection<EncryptCondition> createEncryptConditions(SQLStatementContext sqlStatementContext, AndPredicate andPredicate) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        HashSet<Integer> stopIndexes = new HashSet<Integer>();
        for (ExpressionSegment predicate : andPredicate.getPredicates()) {
            if (!stopIndexes.add(predicate.getStopIndex())) continue;
            this.createEncryptCondition(sqlStatementContext, predicate).ifPresent(result::add);
        }
        return result;
    }

    private Optional<EncryptCondition> createEncryptCondition(SQLStatementContext sqlStatementContext, ExpressionSegment expression) {
        Optional column = ColumnExtractor.extract((ExpressionSegment)expression);
        if (!column.isPresent()) {
            return Optional.empty();
        }
        Optional tableName = sqlStatementContext.getTablesContext().findTableName((ColumnSegment)column.get(), this.schemaMetaData);
        return tableName.isPresent() && this.encryptRule.findEncryptor((String)tableName.get(), ((ColumnSegment)column.get()).getIdentifier().getValue()).isPresent() ? this.createEncryptCondition(expression, (String)tableName.get()) : Optional.empty();
    }

    private Optional<EncryptCondition> createEncryptCondition(ExpressionSegment expression, String tableName) {
        if (expression instanceof BinaryOperationExpression) {
            boolean logical;
            String operator = ((BinaryOperationExpression)expression).getOperator();
            boolean bl = logical = "and".equalsIgnoreCase(operator) || "&&".equalsIgnoreCase(operator) || "OR".equalsIgnoreCase(operator) || "||".equalsIgnoreCase(operator);
            if (!logical) {
                ExpressionSegment rightValue = ((BinaryOperationExpression)expression).getRight();
                return this.isSupportedOperator(((BinaryOperationExpression)expression).getOperator()) ? EncryptConditionEngine.createCompareEncryptCondition(tableName, (BinaryOperationExpression)expression, rightValue) : Optional.empty();
            }
        }
        if (expression instanceof InExpression) {
            return EncryptConditionEngine.createInEncryptCondition(tableName, (InExpression)expression, ((InExpression)expression).getRight());
        }
        if (expression instanceof BetweenExpression) {
            throw new ShardingSphereException("The SQL clause 'BETWEEN...AND...' is unsupported in encrypt rule.", new Object[0]);
        }
        return Optional.empty();
    }

    private static Optional<EncryptCondition> createCompareEncryptCondition(String tableName, BinaryOperationExpression expression, ExpressionSegment compareRightValue) {
        if (!(expression.getLeft() instanceof ColumnSegment)) {
            return Optional.empty();
        }
        return compareRightValue instanceof SimpleExpressionSegment ? Optional.of(new EncryptEqualCondition(((ColumnSegment)expression.getLeft()).getIdentifier().getValue(), tableName, compareRightValue.getStartIndex(), expression.getStopIndex(), compareRightValue)) : Optional.empty();
    }

    private static Optional<EncryptCondition> createInEncryptCondition(String tableName, InExpression inExpression, ExpressionSegment inRightValue) {
        if (!(inExpression.getLeft() instanceof ColumnSegment)) {
            return Optional.empty();
        }
        LinkedList<ExpressionSegment> expressionSegments = new LinkedList<ExpressionSegment>();
        for (ExpressionSegment each : inExpression.getExpressionList()) {
            if (!(each instanceof SimpleExpressionSegment)) continue;
            expressionSegments.add(each);
        }
        return Optional.of(new EncryptInCondition(((ColumnSegment)inExpression.getLeft()).getIdentifier().getValue(), tableName, inRightValue.getStartIndex(), inRightValue.getStopIndex(), expressionSegments));
    }

    private boolean isSupportedOperator(String operator) {
        return "=".equals(operator) || "<>".equals(operator) || "!=".equals(operator);
    }

    @Generated
    public EncryptConditionEngine(EncryptRule encryptRule, PhysicalSchemaMetaData schemaMetaData) {
        this.encryptRule = encryptRule;
        this.schemaMetaData = schemaMetaData;
    }
}

