/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionBuilder;

public final class EncryptPredicateColumnTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator,
SchemaMetaDataAware,
QueryWithCipherColumnAware {
    private PhysicalSchemaMetaData schemaMetaData;
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && ((WhereAvailable)sqlStatementContext).getWhere().isPresent();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Preconditions.checkState((boolean)((WhereAvailable)sqlStatementContext).getWhere().isPresent());
        LinkedHashSet<SubstitutableColumnNameToken> result = new LinkedHashSet<SubstitutableColumnNameToken>();
        ExpressionSegment expression = ((WhereSegment)((WhereAvailable)sqlStatementContext).getWhere().get()).getExpr();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(expression);
        LinkedList andPredicates = new LinkedList(expressionBuilder.extractAndPredicates().getAndPredicates());
        for (AndPredicate each : andPredicates) {
            result.addAll(this.generateSQLTokens(sqlStatementContext, each));
        }
        return result;
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext, AndPredicate andPredicate) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (ExpressionSegment each : andPredicate.getPredicates()) {
            Optional plainColumn;
            Optional<EncryptTable> encryptTable;
            Optional column = ColumnExtractor.extract((ExpressionSegment)each);
            if (!column.isPresent() || !(encryptTable = this.findEncryptTable(sqlStatementContext, (ColumnSegment)column.get())).isPresent() || !encryptTable.get().findEncryptorName(((ColumnSegment)column.get()).getIdentifier().getValue()).isPresent()) continue;
            int startIndex = ((ColumnSegment)column.get()).getOwner().isPresent() ? ((OwnerSegment)((ColumnSegment)column.get()).getOwner().get()).getStopIndex() + 2 : ((ColumnSegment)column.get()).getStartIndex();
            int stopIndex = ((ColumnSegment)column.get()).getStopIndex();
            if (!this.queryWithCipherColumn && (plainColumn = encryptTable.get().findPlainColumn(((ColumnSegment)column.get()).getIdentifier().getValue())).isPresent()) {
                result.add(new SubstitutableColumnNameToken(startIndex, stopIndex, (String)plainColumn.get()));
                continue;
            }
            Optional assistedQueryColumn = encryptTable.get().findAssistedQueryColumn(((ColumnSegment)column.get()).getIdentifier().getValue());
            SubstitutableColumnNameToken encryptColumnNameToken = assistedQueryColumn.map(columnName -> new SubstitutableColumnNameToken(startIndex, stopIndex, columnName)).orElseGet(() -> new SubstitutableColumnNameToken(startIndex, stopIndex, ((EncryptTable)encryptTable.get()).getCipherColumn(((ColumnSegment)column.get()).getIdentifier().getValue())));
            result.add(encryptColumnNameToken);
        }
        return result;
    }

    private Optional<EncryptTable> findEncryptTable(SQLStatementContext sqlStatementContext, ColumnSegment column) {
        return sqlStatementContext.getTablesContext().findTableName(column, this.schemaMetaData).flatMap(tableName -> this.getEncryptRule().findEncryptTable(tableName));
    }

    @Generated
    public void setSchemaMetaData(PhysicalSchemaMetaData schemaMetaData) {
        this.schemaMetaData = schemaMetaData;
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

