/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationTableMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class FederationSchemaMetaData {
    private final String name;
    private final Map<String, FederationTableMetaData> tables;

    public FederationSchemaMetaData(String name, Map<String, TableMetaData> metaData) {
        this.name = name;
        this.tables = new ConcurrentHashMap<String, FederationTableMetaData>(metaData.size(), 1.0f);
        for (Map.Entry<String, TableMetaData> entry : metaData.entrySet()) {
            this.tables.put(entry.getKey().toLowerCase(), new FederationTableMetaData(entry.getValue().getName(), entry.getValue()));
        }
    }

    public void put(TableMetaData metaData) {
        this.tables.put(metaData.getName().toLowerCase(), new FederationTableMetaData(metaData.getName(), metaData));
    }

    public void remove(String tableName) {
        this.tables.remove(tableName.toLowerCase());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, FederationTableMetaData> getTables() {
        return this.tables;
    }
}

