/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.judge.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.shadow.condition.ShadowCondition;
import org.apache.shardingsphere.shadow.condition.ShadowConditionEngine;
import org.apache.shardingsphere.shadow.route.engine.judge.ShadowDataSourceJudgeEngine;
import org.apache.shardingsphere.shadow.route.engine.judge.util.ShadowValueJudgeUtil;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class SimpleShadowDataSourceJudgeEngine
implements ShadowDataSourceJudgeEngine {
    private final ShadowRule shadowRule;
    private final SQLStatementContext<?> sqlStatementContext;

    @Override
    public boolean isShadow() {
        if (this.sqlStatementContext instanceof InsertStatementContext) {
            for (InsertValueContext each : ((InsertStatementContext)this.sqlStatementContext).getInsertValueContexts()) {
                if (!this.judgeShadowSqlForInsert(each, (InsertStatementContext)this.sqlStatementContext)) continue;
                return true;
            }
            return false;
        }
        if (this.sqlStatementContext instanceof WhereAvailable) {
            Optional shadowCondition = new ShadowConditionEngine(this.shadowRule).createShadowCondition(this.sqlStatementContext);
            if (!shadowCondition.isPresent()) {
                return false;
            }
            List values = ((ShadowCondition)shadowCondition.get()).getValues(Collections.emptyList());
            return !values.isEmpty() && ShadowValueJudgeUtil.isShadowValue(values.get(0));
        }
        return false;
    }

    private boolean judgeShadowSqlForInsert(InsertValueContext insertValueContext, InsertStatementContext insertStatementContext) {
        Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            if (!this.shadowRule.getColumn().equals(columnName)) continue;
            int columnIndex = insertStatementContext.getColumnNames().indexOf(columnName);
            return ShadowValueJudgeUtil.isShadowValue(insertValueContext.getValue(columnIndex));
        }
        return false;
    }

    @Generated
    public SimpleShadowDataSourceJudgeEngine(ShadowRule shadowRule, SQLStatementContext<?> sqlStatementContext) {
        this.shadowRule = shadowRule;
        this.sqlStatementContext = sqlStatementContext;
    }
}

