/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovySourcesMojo;
import org.codehaus.gmavenplus.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompileMojo
extends AbstractGroovySourcesMojo {
    protected File outputDirectory;
    protected File testOutputDirectory;
    protected String sourceEncoding;
    protected String targetBytecode;
    protected boolean debug;
    protected boolean verbose;
    protected int warningLevel;
    protected int tolerance;
    protected boolean invokeDynamic;
    protected File configScript;

    protected synchronized void doCompile(Set<File> sourcesToCompile, List classpath, File compileOutputDirectory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, MalformedURLException {
        if (sourcesToCompile == null || sourcesToCompile.isEmpty()) {
            this.getLog().info((CharSequence)"No sources specified for compilation.  Skipping.");
            return;
        }
        Class<?> compilerConfigurationClass = Class.forName("org.codehaus.groovy.control.CompilerConfiguration");
        Class<?> compilationUnitClass = Class.forName("org.codehaus.groovy.control.CompilationUnit");
        Class<?> groovyClassLoaderClass = Class.forName("groovy.lang.GroovyClassLoader");
        Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
        if (this.configScript != null) {
            if (this.getGroovyVersion().compareTo(new Version(2, 1, 0, "beta-1")) >= 0) {
                Class<?> bindingClass = Class.forName("groovy.lang.Binding");
                Class<?> importCustomizerClass = Class.forName("org.codehaus.groovy.control.customizers.ImportCustomizer");
                Class<?> groovyShellClass = Class.forName("groovy.lang.GroovyShell");
                Object binding = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(bindingClass, new Class[0]), new Object[0]);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class), binding, "configuration", compilerConfiguration);
                Object shellCompilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
                Object importCustomizer = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(importCustomizerClass, new Class[0]), new Object[0]);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(importCustomizerClass, "addStaticStar", String.class), importCustomizer, "org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder");
                List compilationCustomizers = (List)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getCompilationCustomizers", new Class[0]), shellCompilerConfiguration, new Object[0]);
                compilationCustomizers.add(importCustomizer);
                Object shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, bindingClass, compilerConfigurationClass), binding, shellCompilerConfiguration);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "evaluate", File.class), shell, this.configScript);
            } else {
                this.getLog().warn((CharSequence)"Requested to use configScript, but your Groovy version doesn't support it (must be 2.1.0-beta-1 or newer).  Ignoring configScript parameter.");
            }
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setDebug", Boolean.TYPE), compilerConfiguration, this.debug);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setVerbose", Boolean.TYPE), compilerConfiguration, this.verbose);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setWarningLevel", Integer.TYPE), compilerConfiguration, this.warningLevel);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTolerance", Integer.TYPE), compilerConfiguration, this.tolerance);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetBytecode", String.class), compilerConfiguration, this.targetBytecode);
        if (this.sourceEncoding != null) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, this.sourceEncoding);
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetDirectory", String.class), compilerConfiguration, compileOutputDirectory.getAbsolutePath());
        if (this.invokeDynamic) {
            if (this.getGroovyVersion().compareTo(new Version(2, 0, 0, "beta-3")) >= 0) {
                if (this.isGroovyIndy()) {
                    if (this.isJavaSupportIndy()) {
                        Map optimizationOptions = (Map)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getOptimizationOptions", new Class[0]), compilerConfiguration, new Object[0]);
                        optimizationOptions.put("indy", true);
                        optimizationOptions.put("int", false);
                    } else {
                        this.getLog().warn((CharSequence)("Tried to use to use an indy version of Groovy, but your Java version (" + this.getJavaVersionString() + ") doesn't support it.  Ignoring invokeDynamic parameter."));
                    }
                } else {
                    this.getLog().warn((CharSequence)"Requested to use InvokeDynamic, but the version of Groovy on the project classpath doesn't support it (must use have indy classifier).  Ignoring invokeDynamic parameter.");
                }
            } else {
                this.getLog().warn((CharSequence)"Requested to use invokeDynamic, but your Groovy version doesn't support it (must be 2.0.0-beta-3 or newer).  Ignoring invokeDynamic parameter.");
            }
        }
        Object groovyClassLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class, compilerConfigurationClass), compilationUnitClass.getClassLoader(), compilerConfiguration);
        Object transformLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class), compilationUnitClass.getClassLoader());
        this.getLog().debug((CharSequence)"Classpath: ");
        if (classpath != null) {
            for (Object classpathElement : classpath) {
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyClassLoaderClass, "addURL", URL.class), groovyClassLoader, new File((String)classpathElement).toURI().toURL());
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyClassLoaderClass, "addURL", URL.class), transformLoader, new File((String)classpathElement).toURI().toURL());
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("    " + classpathElement));
            }
        }
        Object compilationUnit = this.getGroovyVersion().compareTo(new Version(1, 6, 0)) >= 0 ? ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilationUnitClass, compilerConfigurationClass, CodeSource.class, groovyClassLoaderClass, groovyClassLoaderClass), compilerConfiguration, null, groovyClassLoader, transformLoader) : ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilationUnitClass, compilerConfigurationClass, CodeSource.class, groovyClassLoaderClass), compilerConfiguration, null, groovyClassLoader);
        this.getLog().debug((CharSequence)"Adding Groovy to compile:");
        for (File source : sourcesToCompile) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("    " + source));
            }
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilationUnitClass, "addSource", File.class), compilationUnit, source);
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilationUnitClass, "compile", new Class[0]), compilationUnit, new Object[0]);
        List classes = (List)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilationUnitClass, "getClasses", new Class[0]), compilationUnit, new Object[0]);
        this.getLog().info((CharSequence)("Compiled " + classes.size() + " file" + (classes.size() > 1 || classes.size() == 0 ? "s" : "") + "."));
    }
}

