/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.codehaus.mojo.exec.ExecJavaMojo;
import org.codehaus.mojo.exec.URLClassLoaderBuilder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class LoaderFinder {
    LoaderFinder() {
    }

    static ClassLoader find(List<Path> dependencies, String mainClass) throws IOException {
        int sepIndex = mainClass.indexOf(47);
        if (sepIndex < 0) {
            return URLClassLoaderBuilder.builder().setPaths(dependencies).build();
        }
        String moduleName = mainClass.substring(0, sepIndex);
        String bootClass = mainClass.substring(sepIndex + 1);
        ModuleFinder finder = ModuleFinder.of(dependencies.toArray(new Path[0]));
        ModuleLayer parent = ModuleLayer.boot();
        Configuration cf = parent.configuration().resolve(finder, ModuleFinder.of(new Path[0]), Set.of(moduleName));
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(cf, Arrays.asList(parent), scl);
        try {
            ModuleLayer layer = controller.layer();
            String mainPackageName = layer.findLoader(moduleName).loadClass(bootClass).getPackageName();
            Module source = layer.findModule(moduleName).orElseThrow(null);
            Module target = ExecJavaMojo.class.getModule();
            controller = controller.addExports(source, mainPackageName, target);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return controller.layer().findLoader(moduleName);
    }
}

