/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jacoco.maven.AbstractReportMojo;
import org.jacoco.maven.ReportSupport;
import org.jacoco.report.IReportGroupVisitor;

@Mojo(name="report-integration", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class ReportITMojo
extends AbstractReportMojo {
    @Parameter(defaultValue="${project.reporting.outputDirectory}/jacoco-it")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/jacoco-it.exec")
    private File dataFile;

    boolean canGenerateReportRegardingDataFiles() {
        return this.dataFile.exists();
    }

    boolean canGenerateReportRegardingClassesDirectory() {
        return new File(this.project.getBuild().getOutputDirectory()).exists();
    }

    void loadExecutionData(ReportSupport support) throws IOException {
        support.loadExecutionData(this.dataFile);
    }

    File getOutputDirectory() {
        return this.outputDirectory;
    }

    void createReport(IReportGroupVisitor visitor, ReportSupport support) throws IOException {
        support.processProject(visitor, this.title, this.project, this.getIncludes(), this.getExcludes(), this.sourceEncoding);
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("jacoco-it") ? new File(reportOutputDirectory, "jacoco-it") : reportOutputDirectory;
    }

    public String getOutputName() {
        return "jacoco-it/index";
    }

    public String getName(Locale locale) {
        return "JaCoCo IT";
    }
}

